[mkinls.inc]

{ =================================================== }
{       Das MKINL Programm -- INCLUDE Dateien         }
{                                                     }
{               TEIL S : ZWEITER DURCHLAUF            }
{                                                     }
{ =================================================== }

procedure SecPass;

  procedure Header;
  begin
    case OutMode of
    INL   : begin
              Write(InlFile,'begin');
              if PrgName<>'' then Write(InlFile,'{Modul ',PrgName,'}');
              Writeln(InlFile);
              Write(InlFile,'  inline (');
            end;
    CONS,
    PHASE : Write(InlFile,'         (');
    end;
  end;

  procedure WriteLine;
  var
    EndLine    : boolean;
    ItemCnt    : 0..15;

    procedure WriteItem;

      procedure WriteNorm;
      begin
        write (InlFile,'$',Copy(Hex(Prog[PC].Cont),3,2));
        PC := Succ(PC);
        ItemCnt := Succ(ItemCnt)
      end;

      procedure WriteRel;
      var
      Item     : string[5];
      Value    : integer;
      begin
        case OutMode of
          INL   : begin
                    Value := RetrWd(PC) - PC;
                    Str(Value,Item);
                    if Value>=0 then Item := '+' + Item;
                    write (InlFile,'*',Item);
                  end;
          PHASE : begin
                    Value := RetrWd(PC) + PhasePC;
                    write(InlFile,'$',Copy(Hex(lo(Value)),3,2),',');
                    write(InlFile,'$',Copy(Hex(hi(Value)),3,2));
                  end;
          end;
        PC := Succ(Succ(PC));
        ItemCnt := Succ(Succ(ItemCnt));
      end;

      procedure WriteExtern;
      var
        Name   : SymString;
        OP     : byte;
        Offset : integer;
        OffStr : string[6];
      begin
        Name := SymTab[Prog[PC].Cont];
        PC := Succ(PC);
        OP := Prog[PC].Cont;
        PC := Succ(PC);
        if OP>0 then
                begin
                  Offset := OffsTab[OP].Value;
                  Str (Offset,OffStr);
                  if Offset>0 then Name := Name + '+';
                  Name := Name + OffStr
                end;
        Name:=LoStr(Name);
        Write (InlFile,Name);
        ItemCnt := ItemCnt + 2;
      end;

    begin { WriteItem }
      case Prog[PC].Flag of
       Norm: WriteNorm;
       Rel : WriteRel;
       Ext : WriteExtern
      end
    end; { WriteItem }

  begin   { WriteLine }
    writeln (InlFile);
    write   (InlFile,'  {',Hex(PC),'}  ');
    ItemCnt := 0;
    repeat
      WriteItem;
      EoPrg := (PC>=PrgLen);
      EndLine := (ItemCnt>15);
      if not EoPrg then
      begin
        case OutMode of
         INL   : write(InlFile,'/');
         CONS,
         PHASE : write(InlFile,',');
        end;
      end;
    until (EndLine or EoPrg)
  end;  { WriteLine }

  procedure ClosePrg;
  begin
    writeln (InlFile,');');
    if OutMode=INL then
    begin
      write   (InlFile,'end;');
      if PrgName<>'' then write (InlFile,' {',PrgName,'}');
      writeln (InlFile);
    end;
    close(InlFile);
  end;

  procedure Statistic_2;
  begin
    writeln('.. fertig');
    writeln;
    Video('INLINE Datei erzeugt :');
    write  (' ',InlName,' -- ');
    case OutMode of
      INL   : writeln('als normales INLINE Modul');
      CONS  : writeln('als KONSTANTen Modul');
      PHASE : writeln('als PHASE Module mit Offset ',UpStr(Hex(PhasePC)));
      end;
  end;

begin  { SecPass }
  init_pass('.. Schreiben der INLINE Datei');
  Header;
  repeat
    WriteLine
  until EoPrg;
  ClosePrg;
  Statistic_2;
end;   { SecPass }

                                                                     