[mkinlf.inc]

{ =================================================== }
{       Das MKINL Programm -- INCLUDE Dateien         }
{                                                     }
{               TEIL F : ERSTER DURCHLAUF             }
{                                                     }
{ =================================================== }

procedure FirstPass;

  procedure BothErr;
  begin
    Write('PC = ',Hex(PC));
    if length(PrgName)<>0 then write(', Modul: ',PrgName);
  end;

  procedure RelErr (Mess: SymString);
  begin
    BothErr;
    Writeln(',  ',Mess,' relativ;  Argument: ',Hex(GetWord));
    StopErr;
  end;

  procedure SplErr (Item: ItemT);
  begin
    BothErr;
    Writeln(', Element: ',Item:2,', AFeld: ',Hex(AField),', BFeld: ',BField);
    StopErr;
  end;

  procedure Store (Bt: byte; F: FlagT);
  begin
    with Prog[PC] do
                  begin
                    Flag := F;
                    Cont := Bt
                  end;
    PC := Succ(PC)
  end;

  procedure GetAField;
  begin
    case GetBits(2) of
      0,1: AField := GetWord;
        2: RelErr ('Data  ');
        3: RelErr ('Common')
       end
  end;

  procedure GetBField;
  var
    N          : 1..6;
  begin
    BField[0] := Chr(GetBits(3));
    for N :=1 to Length (BField) do Bfield[N] := Chr(GetByte)
  end;

  procedure SetExtern;
  var
    Next       : integer;
  begin
    SymTab[SymPtr] := BField;
    repeat
      Next := RetrWd(AField);
      with Prog [AField] do
                         begin
                           Cont := SymPtr;
                           Flag := Ext
                         end;
      Prog [Succ (AField)].Cont := 0;
      AField := Next;
    until Next=0;
    SymPtr := Succ (SymPtr)
  end;

  procedure SetOffs;
  var
    N          : byte;
  begin
    for N := 1 to Pred(OffsPtr) do Prog[Succ(OffsTab[N].OPC)].Cont := N
  end;

  procedure ExtLink;
  var
    N          : 1..7;
  begin
    BField[0] := Chr(Max(Succ(GetBits(3)),2));
    for N := 1 to length(BField) do BField[N] := Chr(GetByte)
  end;

  procedure DefOffs (Offset: integer);
  begin
    with OffsTab[OffsPtr] do
                          begin
                            OPC := PC;
                            Value := Offset
                          end;
    OffsPtr := Succ(OffsPtr)
  end;

  procedure StoreWd (Word: integer; F: FlagT);
  begin
    Store (Lo(Word),F);
    Store (Hi(Word),F)
  end;

  procedure SpLink;
  var
    Item       : ItemT;
    i          : integer;
  begin
    Item := GetBits(4);
    AField := 0;
    BField := '';
    if Item in [5..14] then GetAField;
    if Item in [0..3,5..7] then GetBField
                           else case Item of
                                 4:  ExtLink;
                                end;
    case Item of
     1,3..5,12   : SplErr (Item);
     2           : PrgName := BField;
     6           : if OutMode=INL then SetExtern
                                  else ModeErr('EXTERNAL');
     8           : DefOffs (-AField);
     9           : DefOffs (AField);
     13          : CodeLen:=AField;
     14,15       : begin
                     PrgLen := PC;
                     BitCnt := 0;
                     EoPrg := true
                   end;
     11          : if PC>=AField then SplErr(Item)
                                 else for i:=1 to AField-PC do Store(0,Norm);
    end;
  end;

  procedure Statistic_1;
  begin
    writeln('.. fertig');
    writeln;
    Video('Statistik von Lauf 1 :');
    writeln;
    writeln;
    write('Modul-Name : ');
    if length(PrgName)>0 then write(PrgName)
                         else Video('NONE');
    write  (' -- L{nge des Codes : ');
    if CodeLen>0 then write(CodeLen,' Bytes')
                 else Video('KEINER');
    case OutMode of
     INL   : begin
               write  (' -- Externals gefunden : ');
               if SymPtr>1 then writeln(pred(SymPtr))
                           else writeln('KEINER');
             end;
     CONS,
     PHASE : writeln;
      end;
    writeln;
  end;

begin
  init_pass('.. Analyse der REL Datei');
  SymPtr := 1;
  OffsPtr := 1;
  repeat
    if GetBits(1)=0 then Store (GetByte,Norm)
                    else case GetBits(2) of
                          0: SpLink;
                          1: if OutMode=CONS then ModeErr('RELOKATIBLER Code')
                                             else StoreWd (GetWord,Rel);
                          2: RelErr ('Data  ');
                          3: RelErr ('Common')
                         end
  until EoPrg;
  SetOffs;
  Statistic_1;
end;


                                                                                                      