[mkinl8.inc]

{ =================================================== }
{       Das MKINL Programm -- INCLUDE Dateien         }
{                                                     }
{       TEIL 8 : Datei Ein/Ausgabe Funktionen         }
{                                                     }
{ =================================================== }

function Get_File(Message:Anystring):FName;
var
  FilName      : FName;
begin
  write(Message);
  GetCursor;
  readln(FilName);
  Get_File:=UpStr(FilName);
end;

function File_Test(FN:FName):boolean;
var
  i,ch,dot     : byte;
  My_FN        : FName;
  FileSet      : ASCII;
begin
  ch:=0;
  dot:=0;
  FileSet:=['0'..'9','A'..'Z','_','.','+','$','@'];
  if FN[2]=':' then My_FN:=copy(FN,3,length(FN)-2)
               else My_FN:=FN;
  if My_FN[1] in ['A'..'Z'] then
  begin
    for i:=1 to length(My_FN) do
    begin
      if My_FN[i] in FileSet then ch:=succ(ch);
      if My_FN[i]='.' then dot:=succ(dot);
    end;
    File_Test:=((ch=length(My_FN)) and (dot<2));
  end
  else File_Test:=false;
end;

function Length_Test(FN:FName):boolean;
var
  MinLen       : byte;
begin
  if FN[2]=':' then MinLen:=2
               else MinLen:=0;
  Length_Test:=Length(FN)>MinLen;
end;

procedure DefNam;
begin
  InlName:=copy(RelName,1,pos('.',RelName)) + 'INL'
end;

procedure MakeFile;
begin
  if InlName='' then DefNam
  else
  begin
    if pos ('.',InlName)=0 then InlName:=InlName + '.INL';
    if not File_Test(InlName) then
                              begin
                                Video('HINWEIS :');
                                writeln(' Fehler im Dateibezeichner : ',InlName);
                                DefNam;
                                writeln('     Umbenannt in : ',InlName);
                              end;
  end;
  assign (InlFile,InlName);
  {$I-}rewrite (InlFile){$I+};
  if IOResult>0 then IOErr ('Inline-Datei kann nicht angelegt werden')
end;

procedure OpenFile;
var
  PPos,PPar    : byte;
  FileOk       : boolean;
begin
  PPar:=ParamCount;
  if PPar>0 then begin
                   writeln;
                   GetCursor;
                 end;
  repeat
    FileOk:=Length_Test(RelName);
    if FileOk then
    begin
      FileOk:=File_Test(RelName);
      if FileOk then
      begin
        PPos := Pos ('.',RelName);
        if PPos=0 then
        begin
          PPos := length(RelName) + 1;
          RelName := RelName + '.REL'
        end;
        assign (RelFile,RelName);
        {$I-}reset (RelFile){$I+};
        FileOk:=IOResult=0;
        if not FileOk then flash('Rel-Datei : '+RelName+' nicht gefunden');
      end
      else flash('Ung}ltiger Bezeichner in : '+RelName);
    end
    else flash('Dateiname wird ben|tigt');
    if not FileOk then
                  begin
                    if PPar>0 then
                              begin
                                RelName:=Get_File('   REL-Datei: ');
                                PPar:=0;
                              end
                              else
                              begin
                                readln(RelName);
                                RelName:=UpStr(RelName);
                              end;
                  end;
  until FileOk;
end;

                                                                                      