[mkinl6.inc]

{ =================================================== }
{       Das MKINL Programm -- INCLUDE Dateien         }
{                                                     }
{       TEIL 6 : Initialisierungsfunktionen           }
{                                                     }
{ =================================================== }

procedure Titel;
const
  version      = 'INLINE Generator fuer TURBO PASCAL 3.0 - V ';
var
  ver          : AnyString;
begin
  ver:=version+ver_num;
  if ParamCount=0 then Video(ver)
                  else writeln(ver);
end;

procedure await_cr;
var
  kc           : char;
begin
  writeln;
  gotoxy(25,wherey);
  video('Weiter mit BELIEBIGER Taste');
  read(kbd,kc);
  writeln;
  writeln;
end;

procedure help;
const
  help_max     = 24;
type
  help_attr    = (NORM,VID,NEW);
var
  lin          : integer;

  procedure hlp(attr:help_attr; Message:AnyString);
  begin
    case attr of
      NORM  : write(Message);
      VID   : video(Message);
      NEW   : begin
                writeln(Message);
                lin:=succ(lin);
              end;
      end;
    if lin>=help_max then
    begin
      await_cr;
      lin:=1;
    end;
  end;

begin
  lin:=1;
  hlp(norm,'Dieses Programm ben|tigt das LINK80 REL ');
  hlp(new,'Dateiformat wie vom MICROSOFT M80 oder ');
  hlp(new,'DIGITAL RESEARCH RMAC Assembler erzeugt.');
  hlp(new,'');
  hlp(norm,'Aufruf mit:  ');
  hlp(vid,'MKINL { dat1{.ty1} { dat2{.ty2} } {[opt]} }');
  hlp(new,'');
  hlp(new,'');
  hlp(norm,'Ohne Parameter wird dieser Hilfstext angezeigt ');
  hlp(new,'und nach den Dateien gefragt.');
  hlp(new,'');
  hlp(new,'Mit ''dat1.ty1'' als Eingabe und ''dat1.INL'' als Ausgabe.');
  hlp(new,'Ohne ''ty1'' wird REL gew{hlt.');
  hlp(new,'');
  hlp(new,'Mit ''dat1.ty1'' als Eingabe und ''dat2.ty2'' als Ausgabe.');
  hlp(new,'''ty1'' ist auf REL und ''ty2'' auf INL eingestellt.');
  hlp(new,'');
  hlp(norm,'Es gibt zwei Optionen, mit denen der KONSTANTen Modus ');
  hlp(new,'gewa{hlt werden kann.');
  hlp(new,'Dieser Modus verwendet ein Komma statt des Schr{gstriches und');
  hlp(new,'erzeugt keine BEGIN, INLINE und END Anweisungen.');
  hlp(new,' In diesem Modus sind keine EXTERNALs erlaubt.');
  hlp(new,'');
  hlp(new,'Im echten KONSTANTen Modus ist kein RELOKATIBLER Code erlaubt.');
  hlp(new,'');
  hlp(new,'Die weitere KONSTANTen Option ist die PHASE Emulation f}r den RMAC.');
  hlp(new,'Diese Option erlaubt RELOKATIBLEN Code.');
  hlp(new,'');
  hlp(new,'Die zul{ssigen Optionen sind:');
  hlp(new,'');
  hlp(vid,'- I -');
  hlp(new,' Auswahl der INLINE Option, dies ist die Voreinstellung.');
  hlp(new,'');
  hlp(vid,'- K -');
  hlp(new,' Auswahl der KONSTANTen Option.');
  hlp(new,'      Nur zusammen mit der M80 Anweisung ''.PHASE'' verwenden.');
  hlp(new,'');
  hlp(vid,'- P -');
  hlp(new,' Auswahl der PHASE Option. Die Syntax ist : ''P=hex_number''.');
end;

procedure test_help;
var
  c            : char;
begin
  Video('Anleitung ausgeben [N,(J)] ');
  repeat
    read(kbd,c);
    c:=upcase(c);
  until c in [cr,'N','J'];
  writeln;
  if c='J' then
  begin
    help;
    await_cr;
    clrscr;
    Titel;
    writeln;
  end;
end;

procedure TellRun;
begin
  if ParamCount=0 then
  begin
    ClrScr;
    GotoXY(20,5);
  end
  else writeln;
  Video('E S   G E H T   L O S');
  writeln;
  writeln;
end;

procedure init_pass(message:anystring);
begin
  writeln(message);
  PC:=0;
  EoPrg:=false;
end;

procedure initialize;
begin
  ClrScr;
  if ParamCount=0 then
  begin
    GotoXY(15,1);
    Titel;
    GotoXY(1,3);
  end
  else
  begin
    writeln;
    Titel;
  end;
  BytePtr := 128; { Bitstrom initialisieren }
  CodeLen:=0;     { .. und Codelaenge       }
  BitCnt := 0;    { .. und Bitzaehler       }
  PhasePC:=0;     { PHASE voreinstellen     }
  OutMode:=INL;   { INL voreinstellen       }
end;

                                                                                      