[mkinl4.inc]

{ =================================================== }
{       Das MKINL Programm -- INCLUDE Dateien         }
{                                                     }
{           TEIL 4 : String Funktionen                }
{                                                     }
{ =================================================== }

function LoCase(c:char):char;
var
  ch           : char;
begin
  ch:=c;
  if ch in ['A'..'Z'] then ch:=chr(ord(ch)+ord('a')-ord('A'));
  LoCase:=ch;
end;

function LoStr(Str:SymString):SymString;
var
  i            : integer;
  LocalString  : SymString;
begin
  LocalString:=Str;
  for i:=1 to length(LocalString) do LocalString[i]:=LoCase(Str[i]);
  LoStr:=LocalString;
end;

function UpStr(Str:FName):FName;
var
  i            : integer;
  LocalString  : FName;
begin
  LocalString:=Str;
  for i:=1 to length(LocalString) do LocalString[i]:=UpCase(Str[i]);
  UpStr:=LocalString;
end;

function HexToDec(hex:AnyString):boolean;
var
  i,hxb,len    : integer;
  OK           : boolean;

  function NibbleVal(c:char):integer;
  begin
    c:=UpCase(c);
    if not (c in ['0'..'9','A'..'F']) then NibbleVal:=256
    else if (c>'9') then NibbleVal:=ord(c)-ord('A')+10
                    else NibbleVal:=ord(c)-ord('0');
  end;

begin
  len:=length(hex);
  OK:=((len<=4) and (len>0));
  if OK then
  begin
    for i:=1 to length(hex) do
    begin
      hxb:=NibbleVal(hex[i]);
      if hxb>255 then OK:=false;
      PhasePC:=PhasePC*16+hxb;
    end;
  end;
  HexToDec:=OK;
end;

                                                                         