[mkinl.pas]

program MKINL;  { ****************************************** }
                { Quelle : MC Nr. 6 1986, Seite 78           }
                { 'Assembler-Routinen fuer Turbo-Pascal'     }
                { Modifiziert von W.Cirsovius, Hohe Weide 44 }
                {                      D-2000 Hamburg 20     }
                { Datum: 12-Nov-1987                         }
                { ****************************************** }

{ ************************************************************************** }
{ Um den Speicherbereich in vernuenftigen Grenzen zu halten, ist die Anzahl  }
{ EXTERNER Referenzen und OFFSETS beschraenkt auf jeweils 255.               }
{ Die Lanege des Programmcodes kann veraendert werden.                       }
{ Diese ist festgelegt mit der CONST MaxInd.                                 }
{ ************************************************************************** }

const
  MaxInd       = $1500;  { <<-- Aendern fuer GROESSERE Programme }
  ver_num      = '1.10'; { <<-- Aktuelle Versionsnummer          }
  esc          = #$1b;
  cr           = #$0d;
type
  PrgInd       = 0..MaxInd;
  SymInd       = 1..255;
  HexString    = string [  4];
  SymString    = string [  6];
  FName        = string [ 14];
  AnyString    = string [127];
  Bits         = 0..8;
  ItemT        = 0..15;
  FlagT        = (Norm,Rel,Ext,NegOffs,PosOffs);
  Light        = (ON,OFF,RESET);
  InlMode      = (INL,CONS,PHASE);
  ASCII        = set of char;
  ByteRec      = record
                   Low,High: byte
                 end;
var
  OutMode      : InlMode;
  Prog         : array[PrgInd] of
                               record
                                 Flag : FlagT;
                                 Cont : byte
                               end;
  PC,PhasePC   : integer;
  OffsPtr      : byte;
  SymTab       : array[SymInd] of SymString;
  OffsTab      : array[SymInd] of
                               record
                                 OPC,value : integer
                               end;
  EoPrg        : boolean;
  RelFile      : file;
  InlFile      : text;
  BytePtr      : 0..128;
  BitCnt       : Bits;
  Buffer       : array[0..127] of byte;
  WB           : ByteRec;
  WW           : integer absolute WB;
  PrgName      : SymString;
  CodeLen,
  PrgLen       : integer;
  SymPtr       : SymInd;
  AField       : integer;
  BField       : string[7];
  RelName,
  InlName      : FName;
  CursX,CursY  : byte;

{$I mkinl1.inc }    { JOYCE abhaengiger Code          }
{$I mkinl2.inc }    { Fehler Funktionen               }
{$I mkinl3.inc }    { INLINE Programme                }
{$I mkinl4.inc }    { String Funktionen               }
{$I mkinl5.inc }    { Bildschirm Functionen           }
{$I mkinl6.inc }    { Initialisierungsfunktionen      }
{$I mkinl7.inc }    { Parametereingabe Funktionen     }
{$I mkinl8.inc }    { Datei Ein/Ausgabe Funktionen    }

{$I mkinlf.inc }    { Erster  Durchlauf des Programms }
{$I mkinls.inc }    { Zweiter Durchlauf des Programms }

{ =================================================== }
{                                                     }
{         Das MKINL Programm -- MAIN Datei            }
{                                                     }
{ =================================================== }

begin  { MKINL }
  initialize;
  case ParamCount of
    0   : begin
            test_help;
            writeln;
            RelName:=Get_File('   REL-Datei: ');
            OpenFile;
            InlName:=Get_File('Inline-Datei: ');
            writeln;
            MakeFile;
            def_opt;
          end;
    1   : begin
            RelName:=ParamStr(1);
            OpenFile;
            InlName:='';
            MakeFile;
          end;
    2   : begin
            RelName:=ParamStr(1);
            OpenFile;
            if File_Test(ParamStr(2)) then InlName:=ParamStr(2)
                                      else
                                      begin
                                        InlName:='';
                                        OutMode:=get_opt(ParamStr(2));
                                      end;
            MakeFile;
          end;
    3   : begin
            RelName:=ParamStr(1);
            OpenFile;
            InlName:=ParamStr(2);
            MakeFile;
            OutMode:=get_opt(ParamStr(3));
          end;
    else  begin
            help;
            IOErr('Neu eingeben mit weniger Parametern');
          end;
    end;
  TellRun;
  FirstPass;
  if CodeLen>0
        then SecPass
        else IOErr('Keine INLINE Datei angelegt, da REL Datei leer ist');
  if ((SymPtr=1) and (OutMode=INL)) then
  begin
    writeln;
    writeln('HINWEIS: Keine Parameter mit EXTERNALS an die Routine uebergeben');
  end;
end.

                                                           