[Aheadtst.pas]

program test_ahead(input,output); { Zeichen lesen in Type    }
                                  { Ahead (TA) Puffer        }
                                  { (C) W.Cirsovius, Okt-87  }
const
  buff         = 80;   { Laenge des TA Puffers }
type
  line         = string[buff];
var
  lin          : line;
  i            : integer;

{ ============================================================== }
{ Die Include-Datei AHEAD.INC fuer die Type Ahead Eingabe        }
{ ============================================================== }
{ Copyright (C) Werner Cirsovius                                 }
{               Hohe Weide 44                                    }
{               D-2000 Hamburg 20                                }
{               Tel.: 040-4223247                                }
{               Version 1.0, October 1987                        }
{ ============================================================== }
{ Diese Include-Datei benoetigt den eingeschalteten Compiler-    }
{ befehl $U+. Dieser Befehl sollte nach der Initialisierung im   }
{ Hauptprogramm eingeschaltet werden. Diese Include-Datei sollte }
{ nach der Typen und Variablendeklarierung eingefuegt werden.    }
{ Die Include-Datei benoetigt den Typen LINE                     }
{ ============================================================== }
{ Der ERSTE Befehl im Hauptprogramm sollte sein:                 }
{        INI_AHEAD(Integer Laenge, Bool'sche Option              }
{ Mit                                                            }
{      Integer Laenge   ist die Laenge des Type Ahead Puffers.   }
{                       Sie sollte die Groesse des Typen LINE    }
{                       haben.                                   }
{      Bool'sche Option bildet den Originalbefehl $U ab          }
{                       TRUE  bedeutet $U+                       }
{                       FALSE bedeutet $U-                       }
{ ============================================================== }
{ Um eine Zeile aus dem Type Ahead Puffer zu lesen, wird         }
{ folgender Befehl aufgerufen:                                   }
{        String_var:=READ_LINE(Text)                             }
{ Mit                                                            }
{        String_var     die Variable, in die gelesen wird.       }
{                       Sie sollte die Groesse des Typen LINE    }
{                       haben.                                   }
{        Text           ist ein optionaler String, der auf die   }
{                       Konsole gschrieben wird, falls der Type  }
{                       Ahead Puffer leer oder nicht mit einem   }
{                       einem abgeschlossen ist.                 }
{ ============================================================== }

{ Die folgenden Variablen werden von den Inline-Routinen benutzt }
var
  buffer       : line;                     { Type Ahead Puffer   }
  uopt         : boolean;                  { Optionales BREAK    }
  bufmax       : integer;                  { Ahead Puffer Laenge }
  detect       : boolean;                  { RETURN Anzeige      }

{$U-}                                SEN BEFEHL NICHT VERAENDERN }

{ ****************** Die HAUPT-Laderoutine ********************** }
{ Diese Routine wird nur aufgerufen, wenn der Compilerbefehl $U+  }
{ eingestellt ist.                                                }
{ *************************************************************** }

procedure ahead;
begin{Module AHEADMAN}
  inline (
  {0000}  $cd/$a0/$00/$c8/$cd/$a3/$00/$5f/$fe/$03/$20/$08/$3a/uopt/$fe/
  {0010}  $00/$c2/$14/$20/$21/buffer/$4e/$06/$00/$0c/$c8/$e5/$2a/bufmax/
  {0020}  $b7/$ed/$42/$e1/$d8/$71/$09/$73);
end; {AHEADMAN}

{ ****************** Die INITIALISIERUNG ************************ }
{ Initialisiert den TA Puffer und Zeiger. Diese Prozedur MUSS vor }
{ der Nutzung der Type Ahead Funktionalitaet aufgerufen werden.   }
{ ACHTUNG: Der RST Vektor RST30 ist JOYCE spezifisch. An anderen  }
{          Maschinen sollte er auf $0039 geaendert werden         }
{ *************************************************************** }

procedure ini_ahead(buff:integer; opt:boolean);
var
  rst30        : integer absolute $0031;
begin
  bufmax:=buff;                    { Maximale Pufferlaenge setzen }
  buffer:='';                                   { String loeschen }
  rst30:=addr(ahead);                          { Routine einbauen }
  uopt:=opt;                                { BREAK Befehl setzen }
end;

{ ******************** Die CHECK Routine ************************ }
{ Zeile von Tatatur oder aus Type Ahead Puffer laden. Es wird     }
{ TRUE zurueckgegeben, wenn mindestens ein Zeichen im Puffer ist  }
{ Setzt die bool'sche Variable DTECT auf TRUE, wenn ein RETURN    }
{ gefunden wurde.                                                 }
{ *************************************************************** }

function get_ahead(var xin:line):boolean;
var
  ahead        : boolean;
begin
  detect:=false;
  xin:='';
  ahead:=length(buffer)>0;
  if ahead then
  begin{Module AHEADGET}
  inline (
  {0000}  $11/buffer/$2a/xin/$1a/$47/$0e/$00/$d5/$e5/$13/$23/$1a/$77/
  {0010}  $fe/$0d/$28/$08/$0c/$10/$f5/$3e/$ff/$32/detect/$e1/$71/$e1/$05/
  {0020}  $70/$28/$0c/$18/$04/$36/$00/$18/$06/$13/$23/$1a/$77/$10/$fa/$3a/
  {0030}  detect/$ee/$ff/$32/detect);
  end; {AHEADGET}
  get_ahead:=ahead;
end;

{ *********************** Der LESER ***************************** }
{ Zeile non Tatatur oder aus Type Ahead Puffer holen. Gibt String }
{ zurueck, der die gleiche Laenge wie der Typ LINE haben sollte.  }
{ Wenn der Puffer leer ist oder kein RETURN gefunden wurde, dann  }
{ wird der optionale String des Typs LINE ausgegeben und der      }
{ Puffer aufgefuellt bis ein RETURN gefunden wurde.               }
{ *************************************************************** }

function read_line(text:line):line;
var
  xin,yin      : line;
  zeile        : boolean;
begin
  zeile:=get_ahead(xin);
  if not detect then write(text);
  if not zeile then readln(xin)
  else
  begin
    if not detect then
    begin
      write(xin);
      readln(yin);
      xin:=concat(xin,yin);
    end;
  end;
  read_line:=xin;
end;

{ **************** Ende von AHEAD.INC *************************** }

BEGIN
  ini_ahead(buff,FALSE); { <--- KEIN BREAK }
{$U+}
  for i:=1 to 132 do writeln(i);
  lin:=read_line('What : ');
  writeln(lin);
  lin:=read_line('And  : ');
  writeln(lin);
END.
