{ ------------------------ SOKOGRAF.INC ---------------------------
  Include-File fuer Grafikbefehle auf dem JOYCE unter Turbo Pascal
  fuer das Spiel SOKOBAN
  Hauptmodul, enthaelt MCode und elementare Routinen. Muss auf alle
  Faelle ins Hauptprogramm eingebinden werden.
  Es sind enthalten:

     procedure GraphInit       -> Initialisierung des MCode
     procedure Plot(x,y,m)     -> Pixel set/reset/invert
     procedure ShowCursor      -> Cursor ein
     procedure HideCursor      -> Cursor aus
     procedure CLRGRAF         -> Grafikschirm loeschen

   Variablen & Prozeduren mit dem Namen GX_ sind zu vermeiden, um
   nicht mit Interna der Grafikerweiterungen zu kollidieren...

   Zum Compilieren die Endadresse auf $F3FF setzen, um nicht den
   MCode zu ueberschreiben!!!
--------------------------------------------------------------------- }

type
{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
  GX_MCode     = array[0..102] of byte; {Anpassen an Assembler Code}
{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
  GX_String    = string[8];
  Strg_14      = string[14];
  Strg_90      = string[90];

var
  GX_MProg     : GX_MCode absolute $F400;

const
  ESC                = #$1b;
  GX_Data : GX_MCode =
  (
  {0000}  $ED,$5B,$10,$F4,$2A,$12,$F4,$01,$14,$F4,$CD,$5A,$FC,$E9,$00,$C9,
  {0010}  $00,$00,$00,$00,$3E,$03,$A2,$57,$E5,$26,$00,$29,$01,$00,$B6,$09,
  {0020}  $4E,$23,$46,$79,$E6,$F8,$6F,$60,$29,$19,$7D,$E6,$F8,$6F,$79,$E6,
  {0030}  $07,$B5,$6F,$7B,$E6,$07,$3C,$47,$AF,$37,$1F,$10,$FD,$C1,$4F,$78,
  {0040}  $FE,$00,$20,$04,$79,$B6,$77,$C9,$FE,$01,$C0,$79,$2F,$A6,$77,$C9,
  {0050}  $01,$59,$F4,$CD,$5A,$FC,$E9,$00,$C9,$21,$30,$59,$36,$00,$11,$31,
  {0060}  $59,$01,$FF,$59,$ED,$B0,$C9
  );

procedure GX_Dot; external $F400;

procedure GX_Clr; external $F450;

procedure GraphInit;
Begin
  GX_MProg:=GX_Data;
End;

procedure Plot(x:integer; y,m:byte);
var  GX_X    : integer absolute $F410;
     GX_Y    : byte    absolute $F412;
     GX_M    : byte    absolute $F413;
Begin
  GX_X:=x;
  GX_Y:=y;
  GX_M:=m;
  GX_Dot;
End;

procedure HideCursor;
Begin
 write(ESC,'f');
End;

procedure ShowCursor;
Begin
  write(ESC,'e');
End;

procedure CLRGRAF;
Begin
  GX_Clr;
  clrscr;
End;

(*        Grafikkonstante f}r JOYCE                  *)

const
  aspect_ratio = 0.45;

procedure line(x1,y1,x2,y2:integer;modus:byte);

(* zieht Linie zwischen den Punkten x1/y1 und x2/y2
   im entsprechenden Modus                           *)

var
  x,dx,dy,
  diff,i1      : integer;
  y,z          : byte;
Begin
  z:=1;
  dx:=abs(x1-x2);
  dy:=abs(y1-y2);
  if (x1<x2) then
  begin
    x:=x1;
    y:=y1;
    if (y1>y2) then z:=-1;
  end else
  begin
    x:=x2;
    y:=y2;
    if (y2>y1) then z:=-1;
  end;
  plot(x,y,modus);
  if ((dx+dy)=0) then exit;
  if (dx>dy) then
  begin
    if (dy=0) then
    (* Horizontale Linie *)
       for i1:=1 to dx do
       begin
         x:=succ(x);
         plot(x,y,modus);
       end else
    (* Steigung < 1 *)
      begin
        diff:=dx shr 1;
        for i1:=1 to dx do
        begin
          diff:=diff+dy;
          if (diff>=dx) then
          begin
            diff:=diff-dx;
            y:=y+z;
          end;
          x:=succ(x);
          plot(x,y,modus);
        end;
      end;
  end else
  begin
    if (dx=0) then
    (* Vertikale Linie *)
       for i1:=1 to dy do
       begin
         y:=y+z;
         plot(x,y,modus);
       end else
       (* Steigung >=1 *)
       begin
         diff:= dy shr 1;
         for i1:=1 to dy do
         begin
           diff:=diff+dx;
           if (diff>=dy) then
           begin
             diff:=diff-dy;
             x:=succ(x);
           end;
           y:=y+z;
           plot(x,y,modus);
         end;
       end;
  end;
End;

procedure circle(x_center,y_center,radius: integer;modus:byte);

(* Kreis mit Mittelpunkt und Radius
   fuer das Spiel taucht grundsaetzlich der Aufruf mit Radius=3 auf.
   Deshalb laesst sich dieser Kreis mit 12 Pixeln darstellen,
   die aus der Originalroutine vorab erstellt wurden                  *)

Begin
  plot(x_center,  y_center+1,modus);
  plot(x_center+1,y_center+1,modus);
  plot(x_center+2,y_center+1,modus);
  plot(x_center+3,y_center,  modus);
  plot(x_center+2,y_center-1,modus);
  plot(x_center+1,y_center-1,modus);
  plot(x_center  ,y_center-1,modus);
  plot(x_center-1,y_center-1,modus);
  plot(x_center-2,y_center-1,modus);
  plot(x_center-3,y_center,  modus);
  plot(x_center-2,y_center+1,modus);
  plot(x_center-1,y_center+1,modus);
End;

