program Sokoban(input,output);

{
 SOKOBAN fuer die KC85/4 Maschine - laut TURBO Kompilat

 Quelle: http://www.iee.et.tu-dresden.de/~kc-club/index.html
    ->   http://www.iee.et.tu-dresden.de/~kc-club/09/RUBRIK17.HTM

 Sehr hilfreich:
         http://www.iee.et.tu-dresden.de/~kc-club/05/BOOK06/0506-000.HTML
 }

const
  NULL         = #0;
  CR           = #$0d;
  ESC          = #$1b;

  RECHTS       = #8;      { Cursorbewegungen }
  LINKS        = #4;
  RUNTER       = #5;
  HOCH         = #24;

  PIC          = 2000;     { Laenge einer PIC Definitionsdatei }
type
  string40     = string[40];
var
  AltX             : integer;
  AltY             : integer;
  NeuX             : integer;
  NeuY             : integer;
  AktuellesZeichen : char;
  VorigesZeichen   : char;
  DateiName        : string[14];
  PICDatei         : file;
  DateiGroesse     : byte;
  DateiNr          : byte;
  PICFeld          : array[0..PIC]      of char;     { PIC Feld }
  SpielFeld        : array[1..18,1..18] of char;
  FeldIndex        : integer;
  BildNr           : integer;
  FeldZeile        : byte;
  FeldSpalte       : byte;
  SpielSteine      : byte;
  Spalte           : byte;
  Zeile            : byte;
  DateiOk          : byte;
  PICindex         : integer;
  SchubNr          : integer;                        { Push Zaehler }
  ZugNr            : integer;                        { Move Zaehler }
  Eingabe1         : byte;
  Eingabe2         : byte;
  Eingabe3         : byte;

procedure ZeichenLesen;
{
  Zeichen mittels BIOS-Aufruf lesen
}
begin
  AktuellesZeichen:=NULL;
  delay(90);
  if (bios(1)<>NULL) then AktuellesZeichen:=bios(2);
end;

procedure SchreibeByte(Wert:integer);
{
  Zeichen von niederem Wortteil schreiben
}
begin
  write(char(Wert));
end;

procedure SchreibeWort(Wert:integer);
{
  Zwei Zeichen von einem Wort schreiben
}
begin
  write(char(Wert));
  write(char(hi(Wert)));
end;

procedure FarbAttribut(Wert:integer);
{
  Farbe des Monitors nach Adresse $B7D6 schreiben

$01: 00001.0.0.0 Blau
$02: 00010.0.0.0 Rot
$04: 00100.0.0.0 Gruen
$05: 00101.0.0.0 
$06: 00110.0.0.0 
$07: 00111.0.0.0 
$09: 01001.0.0.0 
$0A: 01010.0.0.0 
$0B: 01011.0.0.0 
$0C: 01100.0.0.0 
$0D: 01101.0.0.0 
$0F: 01111.0.0.0 
$11: 10001.0.0.0 
$40: 00000.0.1.0  * Loeschen
$41: 00001.0.1.0  * Loeschen

}
begin
  Wert:=Wert shl 3;
  Wert:=(Wert and $ff) + (Wert DIV 256);
  write(ESC,'S',$d6,$b7);
  SchreibeByte(Wert);
end;

procedure Linie(x1,y1,x2,y2:integer);
{
  Linie zeichnen von X-Anfang=x1
                     Y-Anfang=y1
                     X-Ende  =x2
                     Y-Ende  =y2
}
begin
  write(ESC,'D');
  SchreibeWort(x1);
  SchreibeByte(y1);
  SchreibeWort(x2);
  SchreibeByte(y2);
end;

procedure Kreis(x,y,r:integer);
{
  Kreis zeichen von x=x
                    y=y
                mit r=r
}
begin
  write(ESC,'E');
  SchreibeWort(x);
  SchreibeByte(y);
  SchreibeByte(r);
end;

procedure Hintergrund(Farbe:integer);
{
  Hintergrundfarbe auf Farbe setzen
}
begin
  write(ESC,'O');
  SchreibeByte(Farbe);
end;

procedure Palette(Vorne,Hinten:integer);
{
  Vordergrundfarbe auf Vorne
  Hintergrundfarbe auf Hinten
}
begin
  write(ESC,'H');
  SchreibeByte(Vorne);
  SchreibeByte(Hinten);
end;

procedure CursorEin;
{
  Cursor einschalten ?????
}
begin
  write(#$82);
end;

procedure CursorAus;
{
  Cursor ausschalten ?????
}
begin
  write(#$83);
end;

procedure Kiste(x,y:integer);
{
  Zeichen einer Kiste
}
begin
  Linie(x+11,y+11,x+11,y+1);
  Linie(x+1, y+1, x+1, y+11);
  Linie(x+1, y+1, x+11,y+11);
  Linie(x+1, y+1, x+11,y+1);
  Linie(x+11,y+11,x+1, y+11);
  Linie(x+11,y+1, x+1, y+11);
end;

procedure Mauer(x,y:integer);
{
  Zeichnen einer Mauer
}
begin
  Linie(x+12,y+12,x+12,y);
  Linie(x,   y,   x,   y+12);
  Linie(x,   y,   x+12,y);
  Linie(x+12,y+12,x,   y+12);
  Linie(x,   y+4, x+12,y+4);
  Linie(x,   y+8, x+12,y+8);
  Linie(x+4, y,   x+4, y+4);
  Linie(x+8, y,   x+8, y+4);
  Linie(x+6, y+4, x+6, y+8);
  Linie(x+4, y+8, x+4, y+12);
  Linie(x+8, y+8, x+8, y+12);
end;

procedure SpielerLinks(x,y:integer);
{
  Zeichnen Spieler links
}
begin
  Linie(x+10,y+6,x+3,y+10);
  Linie(x+10,y+6,x+3,y+2);
  Kreis(x+6,y+6,3);
end;

procedure SpielerRechts(x,y:integer);
{
  Zeichnen Spieler rechts
}
begin
  Linie(x+2,y+6,x+10,y+10);
  Linie(x+2,y+6,x+10,y+2);
  Kreis(x+6,y+6,3);
end;

procedure SpielerHoch(x,y:integer);
{
  Zeichnen Spieler hoch
}
begin
  Linie(x+6,y+2,x+3, y+10);
  Linie(x+6,y+2,x+10,y+10);
  Kreis(x+6,y+6,3);
end;

procedure SpielerRunter(x,y:integer);
{
  Zeichnen Spieler runter
}
begin
  Linie(x+6,y+10,x+3, y+2);
  Linie(x+6,y+10,x+10,y+2);
  Kreis(x+6,y+6,3);
end;

procedure BewegeSpieler SpielerRunter(xvon,yvon,xnach,ynach:integer);
{
  In Abhaengigkeit von der vorigen Eingabe Spieler bewegen
}
begin
  FarbAttribut($40);
  case VorigesZeichen of
    #8  : SpielerLinks (xvon,yvon);
    #4  : SpielerRechts(xvon,yvon);
    #5  : SpielerHoch  (xvon,yvon);
    #24 : SpielerRunter(xvon,yvon);
  end;
  FarbAttribut($04);
  case AktuellesZeichen of
    #8  : SpielerLinks (xnach,ynach);
    #4  : SpielerRechts(xnach,ynach);
    #5  : SpielerHoch  (xnach,ynach);
    #24 : SpielerRunter(xnach,ynach);
  end;
  VorigesZeichen:=AktuellesZeichen;
end;

procedure KistenPlatz(x,y:integer);
{
  Platz fuer Kiste zeichen
}
begin
  Linie(x+6, y+2, x+10,y+6);
  Linie(x+10,y+6, x+6, y+10);
  Linie(x+6, y+10,x+2, y+6);
  Linie(x+2, y+6, x+6, y+2);
end;

procedure TextAusgeben(x,y:integer; Meldung:string40);
{
  Cursor setzen und Text ausgeben
}
begin
  gotoxy(x,y);
  write(Meldung);
end;

procedure GrossesFenster;
{
  Grosse Fenster zeichen
}
begin
  Linie(  0,255,319,255);
  Linie(319,  0,319,255);
  Linie(  0,  0,319,  0);
  Linie(  0,  0,  0,255);
end;

procedure CLRGRAF;
{
  Grafikschirm loeschen
}
begin
  write(ESC,'M');
end;

procedure Zeichen1(x,y:integer);
{
  Ausgabe "1"
}
begin
  Linie(x+20,y-7,x+20,y-27);
  Linie(x+20,y-7,x+10,y-17);
end;

procedure Zeichen2(x,y:integer);
{
  Ausgabe "2"
}
begin
  Linie(x+10,y-7, x+22,y-7);
  Linie(x+22,y-7, x+22,y-17);
  Linie(x+10,y-17,x+22,y-17);
  Linie(x+10,y-17,x+10,y-27);
  Linie(x+10,y-27,x+22,y-27);
end;

procedure Zeichen3(x,y:integer);
{
  Ausgabe "3"
}
begin
  Linie(x+10,y-7, x+22,y-7);
  Linie(x+22,y-7, x+22,y-27);
  Linie(x+10,y-27,x+22,y-27);
  Linie(x+10,y-17,x+22,y-17);
end;

procedure Zeichen4(x,y:integer);
{
  Ausgabe "4"
}
begin
  Linie(x+20,y-7, x+20,y-27);
  Linie(x+20,y-7, x+9, y-21);
  Linie(x+9, y-21,x+27,y-21);
end;

procedure Zeichen5(x,y:integer);
{
  Ausgabe "5"
}
begin
  Linie(x+10,y-7, x+22,y-7);
  Linie(x+10,y-7, x+10,y-17);
  Linie(x+10,y-17,x+22,y-17);
  Linie(x+22,y-17,x+22,y-27);
  Linie(x+22,y-27,x+10,y-27);
end;

procedure Zeichen6(x,y:integer);
{
  Ausgabe "6"
}
begin
  Linie(x+10,y-7, x+22,y-7);
  Linie(x+10,y-7, x+10,y-27);
  Linie(x+10,y-27,x+22,y-27);
  Linie(x+22,y-27,x+22,y-17);
  Linie(x+22,y-17,x+10,y-17);
end;

procedure Zeichen7(x,y:integer);
{
  Ausgabe "7"
}
begin
  Linie(x+9, y-7, x+25,y-7);
  Linie(x+25,y-7, x+12,y-27);
  Linie(x+14,y-17,x+20,y-17);
end;

procedure Zeichen8(x,y:integer);
{
  Ausgabe "8"
}
begin
  Linie(x+10,y-7, x+22,y-7);
  Linie(x+22,y-7, x+22,y-27);
  Linie(x+10,y-7, x+10,y-27);
  Linie(x+10,y-17,x+22,y-17);
  Linie(x+10,y-27,x+22,y-27);
end;

procedure Zeichen9(x,y:integer);
{
  Ausgabe "9"
}
begin
  Linie(x+10,y-7, x+22,y-7);
  Linie(x+22,y-7, x+22,y-27);
  Linie(x+10,y-7, x+10,y-17);
  Linie(x+10,y-17,x+22,y-17);
  Linie(x+10,y-27,x+22,y-27);
end;

procedure Zeichen0(x,y:integer);
{
  Ausgabe "0"
}
begin
  Linie(x+10,y-7, x+22,y-7);
  Linie(x+10,y-7, x+10,y-27);
  Linie(x+22,y-7, x+22,y-27);
  Linie(x+10,y-27,x+22,y-27);
end;

procedure ZeichneZeichen(ZeichenNr,x,y:byte);
{
  Ziffern 0..9 grafisch darstellen
}
begin
  case ZeichenNr of
    1 : Zeichen1(x,y);
    2 : Zeichen2(x,y);
    3 : Zeichen3(x,y);
    4 : Zeichen4(x,y);
    5 : Zeichen5(x,y);
    6 : Zeichen6(x,y);
    7 : Zeichen7(x,y);
    8 : Zeichen8(x,y);
    9 : Zeichen9(x,y);
    0 : Zeichen0(x,y);
  end;
end;

procedure SpielWaehlen;
{
  Spiel auswaehlen
}
var
  WahlX        : byte;
  WahlY        : byte;
begin
  Palette(7,0);
  clrscr;
  FarbAttribut($0A);
  GrossesFenster;
  FarbAttribut($05);
  Linie( 20,240,119,240);
  Linie( 20,207,119,207);
  Linie( 20, 42,119, 42);
  Linie( 20,  9,119,  9);
  Linie( 20,240, 20,207);
  Linie(119,240,119,207);
  Linie( 20, 42, 20,  9);
  Linie(119, 42,119,  9);
  Linie(200,207,299,207);
  Linie(200,174,299,174);
  Linie(200,141,299,141);
  Linie(200,108,299,108);
  Linie(200, 75,299, 75);
  Linie(200, 42,299, 42);
  Linie(200,207,200,108);
  Linie(233,207,233, 75);
  Linie(266,207,266, 75);
  Linie(299,207,299,108);
  Linie(200, 75,200, 42);
  Linie(299, 75,299, 42);
  FarbAttribut($01);
  Zeichen1(200,207);
  FarbAttribut($02);
  Zeichen2(233,207);
  FarbAttribut($04);
  Zeichen3(266,207);
  FarbAttribut($05);
  Zeichen4(200,174);
  FarbAttribut($06);
  Zeichen5(233,174);
  FarbAttribut($09);
  Zeichen6(266,174);
  FarbAttribut($0A);
  Zeichen7(200,141);
  FarbAttribut($0B);
  Zeichen8(233,141);
  FarbAttribut($0C);
  Zeichen9(266,141);
  FarbAttribut($0D);
  Zeichen0(233,108);
  FarbAttribut($11);
  Linie(211,69,226,69);
  Linie(211,69,211,49);
  Linie(211,49,226,49);
  Linie(226,49,226,59);
  Linie(226,59,220,59);
  Linie(231,69,246,69);
  Linie(231,69,231,49);
  Linie(246,69,246,49);
  Linie(231,59,246,59);
  Linie(251,69,251,49);
  Linie(266,69,266,49);
  Linie(251,69,258,59);
  Linie(258,59,266,69);
  Linie(271,69,286,69);
  Linie(271,69,271,49);
  Linie(271,49,286,49);
  Linie(271,59,286,59);
  FarbAttribut($0F);
  TextAusgeben(9,6,'BEDIENUNGSANLEITUNG');
  Linie(30,185,110,185);
  TextAusgeben(4, 8,'Waehlen  Sie mit  Hilfe der Tastatur');
  TextAusgeben(4, 9,'eine Spielebene aus  und starten Sie');
  TextAusgeben(4,10,'mit der GAME-Taste. Zurueck zur Aus-');
  TextAusgeben(4,11,'wahl gelangen Sie ebenfalls mit "G".');
  TextAusgeben(4,12,'Sokoban beenden Sie mit Level 0.');
  TextAusgeben(4,14,'Ziel ist es, in der  kuerzesten Zeit');
  TextAusgeben(4,15,'und  mit den  wenigsten  Zuegen alle');
  TextAusgeben(4,16,'Kisten  einzeln an die vorbestimmten');
  TextAusgeben(4,17,'Plaetze zu schieben.');
  TextAusgeben(4,19,'         Aber Vorsicht');
  TextAusgeben(4,20,'Zwei Kisten sind fuer Sie zu schwer!');
  FarbAttribut($02);
  Mauer(200,230);
  FarbAttribut($01);
  Kiste(225,230);
  FarbAttribut($0B);
  KistenPlatz(225,230);
  KistenPlatz(245,230);
  FarbAttribut($01);
  Kiste(265,230);
  FarbAttribut($04);
  SpielerLinks(285,230);
  FarbAttribut($40);
  ZeichneZeichen(Eingabe2,60,42);
  ZeichneZeichen(Eingabe3,80,42);  {********* NICHT GESETZT ************}
  FarbAttribut($0F);
  if ((BildNr DIV 10)<>0) then ZeichneZeichen((BildNr DIV 10),60,250);
  ZeichneZeichen((BildNr MOD 10),80,250);
  Eingabe1:=0;
  Eingabe2:=0;
  WahlY:=80;
  repeat
    repeat
      ZeichenLesen;
    until (AktuellesZeichen<>NULL);
    if ((AktuellesZeichen>chr(ord('0')-1)) and (AktuellesZeichen<chr((ord('9')+1))) then
    begin
      write(^G);
      WahlX:=ord(AktuellesZeichen)-ord('0');
      if (WahlY=80) then
      begin
        Eingabe1:=WahlX;
        FarbAttribut($0F);
        ZeichneZeichen(Eingabe1,80,42);
        WahlY:=WahlY-20;
      end else
      begin
        FarbAttribut($40);
        ZeichneZeichen(Eingabe1,WahlY+20,42);
        ZeichneZeichen(Eingabe2,WahlY,42);
        FarbAttribut($0F);
        ZeichneZeichen(WahlX,WahlY+20,42);
        Eingabe2:=Eingabe1;
        Eingabe1:=WahlX;
        if (Eingabe2>0) then ZeichneZeichen(Eingabe2,WahlY,42);
      end;
    end;
  until (AktuellesZeichen='G');
  BildNr:=Eingabe2*10+Eingabe1;
  DateiNr:=Eingabe2*2;
  if ((Eingabe1=0) and (Eingabe2>0)) then
  begin
    DateiNr:=pred(DateiNr);
    Eingabe1:=5;
  end;
  if (Eingabe1>5) then
  begin
    DateiNr:=succ(DateiNr);
    Eingabe1:=Eingabe1-5;
  end;
end;

procedure PICdekodieren;
{
  .PIC Datei dekodieren
}
var
  PICZeiger    : integer;
begin
  PICindex:=0;
  if (Eingabe1>1) then
  begin
    PICZeiger:=2;
    for FeldIndex:=0 to PIC do
    begin
      if (PICFeld[FeldIndex]='0') then PICZeiger:=succ(PICZeiger);
      if (PICZeiger=Eingabe1) then PICindex:=FeldIndex+2;
    end;
  end;
  Hintergrund(0);
  CLRGRAF;
  AltX:=0;
  AltY:=240;
  FeldZeile:=1;
  FeldSpalte:=1;
  SpielSteine:=0;
  FarbAttribut($07);
  GrossesFenster;
  Linie(0,25,319,25);
  while (PICFeld[PICindex]<>'0') do
  begin
    case PICFeld[PICindex] of
        CR : begin
               AltX:=0;
               AltY:=AltY-12;
               FeldZeile:=succ(FeldZeile);
               FeldSpalte:=1;
             end;
       '@' : begin
               AltX:=AltX+12;
               SpielFeld[FeldSpalte,FeldZeile]:=NULL;
               FeldSpalte:=succ(FeldSpalte);
             end;
       'A' : begin
               FarbAttribut($02);
               Mauer(AltX,AltY);
               AltX:=AltX+12;
               SpielFeld[FeldSpalte,FeldZeile]:='A';
               FeldSpalte:=succ(FeldSpalte);
             end;
       'B' : begin
               FarbAttribut($01);
               Kiste(AltX,AltY);
               AltX:=AltX+12;
               SpielFeld[FeldSpalte,FeldZeile]:='B';
               FeldSpalte:=succ(FeldSpalte);
              end;
       'C' : begin
               FarbAttribut($0B);
               KistenPlatz(AltX,AltY);
               AltX:=AltX+12;
               SpielFeld[FeldSpalte,FeldZeile]:='C';
               FarbAttribut($0B);
               SpielSteine:=succ(SpielSteine);
               FeldSpalte:=succ(FeldSpalte);
             end;
       'D' : begin
               FarbAttribut($04);
               SpielerLinks(AltX,AltY);
               SpielFeld[FeldSpalte,FeldZeile]:=NULL;
               NeuX:=AltX;
               NeuY:=AltY;
               AltX:=AltX+12;
               Spalte:=FeldSpalte;
               Zeile:=FeldZeile;
               FeldSpalte:=succ(FeldSpalte);
             end;
       'E' : begin
               SpielFeld[FeldSpalte,FeldZeile]:='d';
               FarbAttribut($0B);
               KistenPlatz(AltX,AltY);
               FarbAttribut($01);
               Kiste(AltX,AltY);
               AltX:=AltX+12;
               FeldSpalte:=succ(FeldSpalte);
             end;
    end;
    PICindex:=succ(PICindex);
  end;
  VorigesZeichen:=#8;
  SchubNr:=0;
  ZugNr:=0;
  AltX:=NeuX;
  AltY:=NeuY;
  gotoxy(4,24);
  write('Bild : ',BildNr:2,'             Pushes : ',SchubNr:3,'                  Moves : ',ZugNr:3);
end;

procedure PIClesen(var Erfolg:byte);
{
  .PIC Datei laden
}
begin
  Erfolg:=0;
  str(DateiNr,DateiName);
  DateiName:='A:SOKO-'+DateiName+'.PIC';
  assign(PICDatei,DateiName);
  {$I-}reset(PICDatei);{$I+}
  if (ioresult=0) then
  begin
    FeldIndex:=0;
    DateiGroesse:=filesize(PICDatei);
    blockread(PICDatei,PICFeld[FeldIndex],DateiGroesse);
    close(PICDatei);
    DateiNr:=succ(DateiNr);
    PICindex:=0;
    Erfolg:=1;
  end;
end;

procedure SchiebeKisteLinks;
{
  Kiste nach links schieben
}
begin
  FarbAttribut($41);
  Kiste(AltX-12,AltY);
  FarbAttribut($01);
  Kiste(AltX-24,AltY);
  SchubNr:=succ(SchubNr);
  ZugNr:=succ(ZugNr);
  Spalte:=pred(Spalte);
  SpielFeld[Spalte,Zeile]:=NULL;
  NeuX:=AltX-12;
end;

procedure SchiebeKisteRechts;
{
  Kiste nach rechts schieben
}
begin
  FarbAttribut($41);
  Kiste(AltX+12,AltY);
  FarbAttribut($01);
  Kiste(AltX+24,AltY);
  SchubNr:=succ(SchubNr);
  ZugNr:=succ(ZugNr);
  Spalte:=succ(Spalte);
  SpielFeld[Spalte,Zeile]:=NULL;
  NeuX:=AltX+12;
end;

procedure SchiebeKisteHoch;
{
  Kiste hoch schieben
}
begin
  FarbAttribut($41);
  Kiste(AltX,AltY+12);
  FarbAttribut($01);
  Kiste(AltX,AltY+24);
  SchubNr:=succ(SchubNr);
  ZugNr:=succ(ZugNr);
  Zeile:=pred(Zeile);
  SpielFeld[Spalte,Zeile]:=NULL;
  NeuY:=AltY+12;
end;

procedure SchiebeKisteRunter;
{
  Kiste runter schieben
}
begin
  FarbAttribut($41);
  Kiste(AltX,AltY-12);
  FarbAttribut($01);
  Kiste(AltX,AltY-24);
  Zeile:=succ(Zeile);
  SchubNr:=succ(SchubNr);
  ZugNr:=succ(ZugNr);
  SpielFeld[Spalte,Zeile]:=NULL;
  NeuY:=AltY-12;
end;

BEGIN
{ M A I N }
  clrscr;
  CursorAus;
  Eingabe1:=0;
  Eingabe2:=0;
  BildNr:=0;
  repeat
    SpielWaehlen;
    PIClesen(DateiOk);
  until (DateiOk=1);
  if ((BildNr<>0) and (DateiOk=1)) then PICdekodieren;
  if (BildNr<>0) then
  repeat
    repeat
      ZeichenLesen;
    until (AktuellesZeichen<>NULL);
    case AktuellesZeichen of
      #8 :
           begin
             case SpielFeld[Spalte-1,Zeile] of
             NULL  : begin
                       NeuX:=AltX-12;
                       SchubNr:=succ(SchubNr);
                       Spalte:=pred(Spalte);
                     end;
               'B' : begin
                       case SpielFeld[Spalte-2,Zeile] of
                         'C' : begin
                                 SchiebeKisteLinks;
                                 SpielFeld[Spalte-1,Zeile]:='d';
                                 SpielSteine:=pred(SpielSteine);
                               end;
                       NULL  : begin
                                 SchiebeKisteLinks;
                                 SpielFeld[Spalte-1,Zeile]:='B';
                               end;
                       end;
                     end;
               'C' : begin
                       NeuX:=AltX-12;
                       FarbAttribut($40);
                       KistenPlatz(AltX,AltY);
                       SchubNr:=succ(SchubNr);
                       Spalte:=pred(Spalte);
                     end;
               'd' : begin
                       case SpielFeld[Spalte-2,Zeile] of
                         'C': begin
                                SchiebeKisteLinks;
                                SpielFeld[Spalte,Zeile]:='C';
                                SpielFeld[Spalte-1,Zeile]:='d';
                              end;
                       NULL : begin
                                SchiebeKisteLinks;
                                SpielFeld[Spalte,Zeile]:='C';
                                SpielFeld[Spalte-1,Zeile]:='B';
                                SpielSteine:=succ(SpielSteine);
                              end;
                       end;
                     end;
           end;
           BewegeSpieler(AltX,AltY,NeuX,NeuY);
           if (SpielFeld[Spalte+1,Zeile]='C') then KistenPlatz(AltX,AltY);
         end;
      #4 :
            begin
             case SpielFeld[Spalte+1,Zeile] of
              NULL : begin
                       NeuX:=AltX+12;
                       SchubNr:=succ(SchubNr);
                       Spalte:=succ(Spalte);
                     end;
               'B' : begin
                       case SpielFeld[Spalte+2,Zeile] of
                         'C' : begin
                                 SchiebeKisteRechts;
                                 SpielFeld[Spalte+1,Zeile]:='d';
                                 SpielSteine:=pred(SpielSteine);
                               end;
                        NULL : begin
                                 SchiebeKisteRechts;
                                 SpielFeld[Spalte+1,Zeile]:='B';
                               end;
                       end;
                     end;
               'C' : begin
                       NeuX:=AltX+12;
                       FarbAttribut($40);
                       KistenPlatz(AltX,AltY);
                       SchubNr:=succ(SchubNr);
                       Spalte:=succ(Spalte);
                     end;
               'd' : begin
                       case SpielFeld[Spalte+2,Zeile] of
                         'C' : begin
                                 SchiebeKisteRechts;
                                 SpielFeld[Spalte,  Zeile]:='C';
                                 SpielFeld[Spalte+1,Zeile]:='d';
                               end;
                        NULL : begin
                                 SchiebeKisteRechts;
                                 SpielFeld[Spalte,  Zeile]:='C';
                                 SpielFeld[Spalte+1,Zeile]:='B';
                                 SpielSteine:=succ(SpielSteine);
                               end;
                       end;
                     end;
             end;
             BewegeSpieler(AltX,AltY,NeuX,NeuY);
             if (SpielFeld[Spalte-1,Zeile]='C') then KistenPlatz(AltX,AltY);
           end;
      #5 :
           begin
             case SpielFeld[Spalte,Zeile-1] of
              NULL : begin
                       NeuY:=AltY+12;
                       SchubNr:=succ(SchubNr);
                       Zeile:=pred(Zeile);
                     end;
               'B' : begin
                       case SpielFeld[Spalte,Zeile-2] of
                         'C' : begin
                                 SchiebeKisteHoch;
                                 SpielFeld[Spalte,Zeile-1]:='d';
                                 SpielSteine:=pred(SpielSteine);
                               end;
                        NULL : begin
                                 SchiebeKisteHoch;
                                 SpielFeld[Spalte,Zeile-1]:='B';
                               end;
                       end;
                     end;
               'C' : begin
                       NeuY:=AltY+12;
                       FarbAttribut($40);
                       KistenPlatz(AltX,AltY);
                       SchubNr:=succ(SchubNr);
                       Zeile:=pred(Zeile);
                     end;
               'd' : begin
                       case SpielFeld[Spalte,Zeile-2] of
                          'C' : begin
                                  SchiebeKisteHoch;
                                  SpielFeld[Spalte,  Zeile]:='C';
                                 SpielFeld[Spalte,Zeile-1]:='d';
                                end;
                         NULL : begin
                                  SchiebeKisteHoch;
                                  SpielFeld[Spalte,  Zeile]:='C';
                                  SpielFeld[Spalte,Zeile-1]:='B';
                                  SpielSteine:=succ(SpielSteine);
                                end;
                       end;
                     end;
             end;
             BewegeSpieler(AltX,AltY,NeuX,NeuY);
             if (SpielFeld[Spalte,Zeile+1]='C') then KistenPlatz(AltX,AltY);
           end;
     #24 :
           begin
             case SpielFeld[Spalte,Zeile+1] of
             NULL : begin
                      NeuY:=AltY-12;
                      SchubNr:=succ(SchubNr);
                      Zeile:=succ(Zeile);
                    end;
               'B': begin
                      case SpielFeld[Spalte,Zeile+2] of
                        'C' : begin
                                SchiebeKisteRunter;
                                SpielFeld[Spalte,Zeile+1]:='d';
                                SpielSteine:=pred(SpielSteine);
                              end;
                       NULL : begin
                                SchiebeKisteRunter;
                                SpielFeld[Spalte,Zeile+1]:='B';
                              end;
                      end;
                    end;
               'C': begin
                      NeuY:=AltY-12;
                      FarbAttribut($40);
                      KistenPlatz(AltX,AltY);
                      SchubNr:=succ(SchubNr);
                      Zeile:=succ(Zeile);
                    end;
               'd': begin
                      case SpielFeld[Spalte,Zeile+2] of
                        'C' : begin
                                SchiebeKisteRunter;
                                SpielFeld[Spalte,Zeile  ]:='C';
                                SpielFeld[Spalte,Zeile+1]:='d';
                              end;
                       NULL : begin
                                SchiebeKisteRunter;
                                SpielFeld[Spalte,Zeile  ]:='C';
                                SpielFeld[Spalte,Zeile+1]:='B';
                                SpielSteine:=succ(SpielSteine);
                              end;
                      end;
                    end;
             end;
             BewegeSpieler(AltX,AltY,NeuX,NeuY);
             if (SpielFeld[Spalte,Zeile-1]='C') then KistenPlatz(AltX,AltY);
           end;
     'G' : begin
             write(^G);
             repeat
               SpielWaehlen;
               PIClesen(DateiOk);
             until (DateiOk=1);
             if ((BildNr<>0) and (DateiOk=1)) then PICdekodieren;
           end;
    end;
    AltX:=NeuX;
    AltY:=NeuY;
    if (AktuellesZeichen<>'G') then
    begin
      gotoxy(35,24);
      write(SchubNr:3);
      gotoxy(64,24);
      write(ZugNr:3);
    end;
    if (SpielSteine=0) then
    begin
      BildNr:=succ(BildNr);
      Eingabe1:=succ(Eingabe1);
      if (Eingabe1>9) then
      begin
        Eingabe2:=succ(Eingabe2);
        Eingabe1:=0;
      end;
      if ((Eingabe1=1) or (Eingabe1=6)) then
      begin
        PIClesen(DateiOk);
        Eingabe1:=1;
      end;
      if (DateiOk=1) then PICdekodieren;
    end;
  until ((BildNr=0) or (DateiOk=0));
  clrscr;
  CursorEin;
END.

