program ostern(input, output);

(* Wann ist Ostern ? *)
(* Nach einem Artikel der Physikalisch-Technischen Bundesanstalt *)

(* Ausfuehrung in Turbo Pascal, Werner Cirsovius, Februar 1999 *)

type
  strg      = string(.80.);
var
  x         : integer;

procedure datum(msg:strg; val:integer);
var
  mo, da      : integer;
Begin
  writeln;
  write(msg,' ist am ');
  mo := 3;
  da := val;
  if (da > 31) then
  begin
    da := da - 31;
    mo := mo + 1;
    if (da > 30) then
    begin
      da := da - 30;
      mo := mo + 1;
      if (da > 31) then
      begin
        da := da - 31;
        mo := mo + 1;
      end;
    end;
  end;
  write(da:2, '.', mo:2, '.', x:4);
End;

var
  k, l, m, s, a, d, r : integer;
  og, sz, oe, os      : integer;
  ps, ch,fl           : integer;

BEGIN
  writeln;
  write('Das Jahr eingeben bitte ... ');
  readln(x);

  if ( x < 1583 )    (* julianischer Kalender *)
  then
  begin
    writeln;
    writeln(' Julianischer Kalender kann nicht berechnet werden!');
    halt;
  end else
  begin              (* gregorianischer Kalender *)
    k := x div 100;
    l := (3*(k + 1)) div 4;
    m := 15 + l - ((8 * k + 13) div 25);
    s := 2 - l;
    a := x mod 19;
    d := ((19 * a)  + m) mod 30;
    r := (d div 29) + ((d div 28) - (d div 29)) * (a div 11);
    og := 21 + d - r;
    sz := 7 - ((x + (x div 4) + s) mod 7);
    oe := 7 - ((og - sz) mod 7);
    os := og + oe;
    ps := os + 49;
    ch := os + 39;
    fl := os + 60;
    datum('      Ostern', os);
    datum('   Pfingsten', ps);
    datum(' Himmelfahrt', ch);
    datum('Fronleichnam', fl);
  end;
END.
                                                                                                                    