(* ------------------------- CONVERT.INC ------------------------------------- *)
(* Version 1.0  22.12.2021                                                     *)
(*                                                                             *)
(*  Include-File mit Konvertierungsprozeduren.                                 *)
(*  Es sind enthalten:                                                         *)
(*     procedure CharPtrToString    -> ^Char -> String                         *)
(*     procedure StringToCharPtr    -> String -> ^Char                         *)
(*     procedure StringToInteger    -> String -> Integer                       *)
(*     procedure StringToReal       -> String -> Real                          *)
(*     procedure CharPtrToInteger   -> ^Char -> Integer                        *)
(*     procedure CharPtrToReal      -> ^Char -> Real                           *)
(* --------------------------------------------------------------------------- *)

type
  CharPtr = ^Char;
  WorkString = string(.255.);

var
  cvt_error: Boolean;

(* Converts a character pointer into a String.
   cp  the Char pointer input
   s   the String result
*)
procedure CharPtrToString(cp: CharPtr; var s: WorkString);
var i, len: Byte;
begin
  s := '';
  len := ord(cp^);
  for i := 1 to len do begin
    cp := ptr(succ(ord(cp))); (* move pointer to next address *)
    s := s + cp^;
  end;
  cvt_error := false;
end; (* CharPtrToString *)

(* Converts a String into a character pointer.
   s   the String input
   cp  the Char pointer result
*)
procedure StringToCharPtr(var s: WorkString; cp: CharPtr);
var i: Byte;
begin
  cp^ := chr(Length(s));
  for i := 1 to Length(s) do begin
    cp := ptr(succ(ord(cp))); (* move pointer to next address *)
    cp^ := s(.i.);
  end;
  cvt_error := false;
end; (* StringToCharPtr *)


(* Converts a WorkString into an integer number. *)
function StringToInteger(s: WorkString): Integer;
var valResult: Integer;
    value: Integer;
begin
  Val(s, value, valResult);
  if valResult <> 0 then begin
    value := 0;
    cvt_error := true;
  end else begin
    cvt_error := false;
  end;
  
  StringToInteger := value;
end; (* StringToInteger *)


(* Converts a WorkString into a real number. *)
function StringToReal(s: WorkString; decimalChar: Char): Real;
var p: Integer;
    valResult: Integer;
    value: Real;
begin
  (* we need a point as decimal character for the conversion. *)
  if decimalChar <> '.' then begin
    p := Pos(decimalChar, s);
    s(.p.) := '.';
  end;
  Val(s, value, valResult);
  if valResult <> 0 then begin
    value := 0;
    cvt_error := true;
  end else begin
    cvt_error := false;
  end;
  
  StringToReal := value;
end; (* StringToReal *)


(* Converts a character pointer into an Integer. *)
function CharPtrToInteger(cp: CharPtr): Integer;
var s: WorkString;
begin
  CharPtrToString(cp, s);
  CharPtrToInteger := StringToInteger(s);
end; (* CharPtrToInteger *)


(* Converts a character pointer into a Real. *)
function CharPtrToReal(cp: CharPtr; decimalChar: Char): Real;
var s: WorkString;
begin
  CharPtrToString(cp, s);
  CharPtrToReal := StringToReal(s, decimalChar);
end; (* CharPtrToReal *)

(* ------------------ Ende von CONVERT.INC --------------------- *)
