(* ------------------------- BOX.INC --------------------------------- *)
(*  Include-File zum Zeichnen von Rahmen auf der JOYCE unter           *)
(*  Turbo Pascal.                                                      *)
(*  Enthaltene Funktionen und Prozeduren:                              *)
(*                                                                     *)
(*     procedure DrawBox         -> Zeichnen eines Rahmens             *)
(* ------------------------------------------------------------------- *)

(* Draws a box at position (x, y) with width w and height h. *)
procedure DrawBox(x, y, w, h: Integer);
var i: Integer;
begin
  GotoXY(x, y);
  Write(chr(150));
  for i := 1 to w - 2 do Write(chr(154));
  Write(chr(156));
  for i := y + 1 to y + h - 2 do begin
    GotoXY(x, i);         Write(chr(149));
    GotoXY(x + w - 1, i); Write(chr(149));
  end;
  GotoXY(x, y + h - 1);
  Write(chr(147));
  for i := 1 to w - 2 do Write(chr(154));
  Write(chr(153));
end;

(* ------------------ Ende von BOX.INC ------------------------- *)
