/* ------------------- vecin2.c ------------------------

  Load a vector graphic from a VEC or VE2 file.

  ---------------------------------------------------- */

#ifndef __VECIN2_H__
#define __VECIN2_H__

#include <stdint.h>

typedef struct {
    int minX;
    int maxX;
    int minY;
    int maxY;
    int targetResolutionX;
    int targetResolutionY;
    uint8_t bytesXCoord;
    uint8_t bytesYCoord;
    int profileFlags;
} VE2Header;

typedef enum {ErrOk, ErrFileNotFound, ErrFormatNotSupported} errorCode_t;


// Opens a VEC file.
errorCode_t openVecFile(const char *filename);

// Closes the VEC/VE2 file previously opened.
void closeVecFile();

/* Reads and verifies the vector graphics file ident (should be "VEC" or "VE2").
   Returns the vector file type: 0=unknown, 1=VEC, 2=VE2 */
uint8_t readFileType();

// Reads a VE2 header.
VE2Header * readVe2Header();

// Reads the vector graphics operation code.
uint8_t readOpCode();

// Reads the vector graphics operation's dot count.
uint8_t readDotCount();

// Reads a value (coordinate, width, radius, etc.).
int readValue();

// Reads an X coordinate; input size depends on bytesXCoord.
int readX();

// Reads a Y coordinate; input size depends on bytesYCoord.
int readY();

/* Reads a value; input size depends on the maximum of bytesXCoord
   and bytesYCoord. */
int readMax();

#endif
