/* ------------------------- input2.h ---------------------------------------- *
 * Version 2.3  31.12.2021, C port: 17.01.2023                                 *
 *                                                                             *
 *  Include-File fuer Eingabebefehle auf der JOYCE unter C.                    *
 *                                                                             *
 * Abhaengigkeiten: convert.h                                                  *
 *                                                                             *
 *  Es sind enthalten:                                                         *
 *     void setDecimalChar       -> Setzt das Dezimalzeichen ('.' oder ',')    *
 *     void writeKeyMessage      -> Schreibt eine Tastendruck-Meldung          *
 *     void waitForKey           -> Wartet auf einen Tastendruck               *
 *     void getKey               -> Liest Zeichen per Tastendruck              *
 *     void beep                 -> Erzeugt einen Ton                          *
 *     void isFieldInputFinished -> Ende-Taste gedrueckt?                      *
 *     void inputString          -> Eingabe einer Textzeile                    *
 *     void home                 -> Setzt den Cursor in die linke obere Ecke   *
 *     void clearScreen          -> Loescht den Bildschirm                     *
 *     void gotoXY               -> Setzt den Cursor an Position X,Y           *
 *     void clearEol             -> Loescht vom Cursor bis zum Zeilenende      *
 *     void inverseVideo         -> Schaltet auf inverse Darstellung um        *
 *     void normalVideo          -> Schaltet inverse Darstellung aus           *
 *     void hideCursor           -> Macht den Cursor unsichtbar                *
 *     void showCursor           -> Macht den Cursor sichtbar                  *
 *     void statusBarOff         -> Schaltet die Statuszeile aus               *
 *     void statusBarOn          -> Schaltet die Statuszeile an                *
 * --------------------------------------------------------------------------- */

#ifndef __INPUT2_H__
#define __INPUT2_H__

#include "mytypes.h"

#define FileNameString char[12]
#define DateString     char[10]
typedef enum {FTText, FTNumNatural, FTInteger, FTReal, FTDate, FTFileName} FieldType;

#define CH_DEL_LEFT  127
#define CH_DEL_RIGHT   7
#define CH_LEFT        1
#define CH_RIGHT       6
#define CH_UP         31
#define CH_DOWN       30
#define CH_BACKSPACE   8
#define CH_TAB         9
#define CH_RETURN     10
#define CH_BEEP        7
#define CH_CAN         8
#define CH_SZ        126
#define CH_UC_AUML    91
#define CH_UC_OUML    92
#define CH_UC_UUML    93
#define CH_LC_AUML   123
#define CH_LC_OUML   124
#define CH_LC_UUML   125
#define PLACEHOLDER  '_'

extern char input_lastChar;

// Sets the decimal character.
void setDecimalChar(char ch);

// Writes a 'Press a key' message to the screen.
void writeKeyMessage();

// Waits for a key to be pressed.
void waitForKey();

// Waits for a key to be pressed and returns the character typed.
char getKey();

// Emits a beep through the loudspeaker.
void beep();

// Checks if the input of a field was finished.
bool isFieldInputFinished(char ch);

// Checks if the character is a digit ('0' - '9').
bool isDigit(char ch);

// Gets the position of the character ch in the string s.
// Returns -1 if ch was not found in s.
int strpos(char ch, char *s);

/* Checks if the character is valid for the field type.
   ch     the character to check
   p      ch's position in the work string (0-based)
   ftype  field type
   s      work string
*/
bool isValid(char ch, int p, FieldType ftype, char *s);

// Writes a String starting at the position.
void writeFromPos(char *s, int position);

/* Inputs a String in a dynamically allocated character array.
   cp      character pointer to the pre-allocated input memory
   maxlen  maximum length allowed for input
   x       x position on screen (zero-based)
   y       y position on screen (zero-based)
   ftype   field type
*/
void inputString(char *cp, int maxlen, int x, int y, FieldType ftype);

// Moves the cursor to the upper left corner.
void home();

// Clears the screen.
void clearScreen();

// Places the text cursor at position x (= column) and y (= row).
// x and y are zero-based, i.e. the upper left corner is x = 0, y = 0.
void gotoXY(unsigned int x, unsigned int y);

// Clears from the cursor until the end of the line.
void clearEol();

// Switches to inverse display, i.e. exchanges font and background colour.
void inverseVideo();

// Switches inverse display off.
void normalVideo();

// Hides the cursor.
void hideCursor();

// Shows the cursor.
void showCursor();

// Switches the status bar off.
void statusBarOff();

// Switches the status bar on.
void statusBarOn();

#endif
