/* ------------------------- convert.h --------------------------------------- *
 * Version 1.0  22.12.2021, C port: 19.01.2023                                 *
 *                                                                             *
 *  Konvertierungsprozeduren                                                   *
 *                                                                             *
 *  Es sind enthalten:                                                         *
 *     int   stringToInteger    -> string -> int                               *
 *     float stringToFloat      -> string -> float                             *
 * --------------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Converts a string into an integer number.
int stringToInteger(char *s) {
  return atoi(s);
}

// Converts a string into a float number.
float stringToFloat(char *s, char decimalChar) {
    char *p;
    float value;
    char *scopy;

    if (s != NULL) {
        // we need a point as decimal character for the conversion.
        if (decimalChar != '.') {
            scopy = malloc(strlen(s) + 1);
            strcpy(scopy, s);
            p = strchr(scopy, decimalChar);
            if (p != NULL) {
                *p = '.';
            }
            sscanf(scopy, "%f", &value);
            free(scopy);
        }
        else {
            sscanf(s, "%f", &value);
        }
    }
    else {
        value = 0.0;
    }
    
    return value;
}
