/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.writer;

import de.berndbock.tinysvg.graphelem.Circle;
import de.berndbock.tinysvg.graphelem.GraphicElement;
import de.berndbock.tinysvg.graphelem.GraphicElements;
import de.berndbock.tinysvg.graphelem.Line;
import de.berndbock.tinysvg.graphelem.Rect;
import de.berndbock.tinysvg.helper.LineSegmentCreator;
import de.berndbock.tinysvg.helper.Point;
import de.berndbock.tinysvg.util.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ZxCncWriter {
    private static final Logger LOGGER = Logger.getLogger("global");
    private static final byte[] IDENT = new byte[]{63, 61, 40, 51, 40};
    private static final byte S = 56;
    private static final byte H = 45;
    private OutputStream outputStream = null;
    private double x = 0.0;
    private double y = 0.0;
    private double lastX = 0.0;
    private double lastY = 0.0;
    private int lineCount = 0;
    private int maxX = Integer.MIN_VALUE;
    private int minX = Integer.MAX_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private int minY = Integer.MAX_VALUE;
    private boolean usePenProtector = false;

    public void write(GraphicElements elements, File outputFile) {
        try (FileOutputStream os = new FileOutputStream(outputFile);){
            this.outputStream = os;
            this.gatherStatistics(elements);
            this.writeInt(this.lineCount);
            this.writeInt(this.maxX);
            this.writeInt(this.maxY);
            this.writeInt(this.minX);
            this.writeInt(this.minY);
            this.outputStream.write(IDENT);
            for (int i = 0; i < elements.size(); ++i) {
                boolean updateLastCoords;
                GraphicElement element = elements.get(i);
                switch (element.getType()) {
                    case 1: {
                        Rect rect = (Rect)element;
                        this.x = rect.getX();
                        this.y = rect.getY();
                        this.moveTo(this.x, this.y);
                        this.x += rect.getWidth();
                        this.lineTo(this.x, this.y);
                        this.y += rect.getHeight();
                        this.lineTo(this.x, this.y);
                        this.x = rect.getX();
                        this.lineTo(this.x, this.y);
                        this.y = rect.getY();
                        this.lineTo(this.x, this.y);
                        updateLastCoords = true;
                        break;
                    }
                    case 2: {
                        Circle circle = (Circle)element;
                        this.x = circle.getCx();
                        this.y = circle.getCy();
                        LineSegmentCreator creator = new LineSegmentCreator();
                        List<Line> lines = creator.buildLines(circle, element.getParent());
                        if (!lines.isEmpty()) {
                            Line line = lines.get(0);
                            this.moveTo(line.getX1(), line.getY1());
                            this.lineTo(line.getX2(), line.getY2());
                            for (int idx = 1; idx < lines.size(); ++idx) {
                                line = lines.get(idx);
                                this.moveTo(line.getX2(), line.getY2());
                            }
                        }
                        updateLastCoords = true;
                        break;
                    }
                    case 3: {
                        Line line = (Line)element;
                        if (this.x != line.getX1() || this.y != line.getY1()) {
                            this.moveTo(line.getX1(), line.getY1());
                        }
                        if (this.x != line.getX2() || this.y != line.getY2()) {
                            this.x = line.getX2();
                            this.y = line.getY2();
                            this.lineTo(this.x, this.y);
                        }
                        updateLastCoords = true;
                        break;
                    }
                    case 5: 
                    case 9: 
                    case 13: {
                        updateLastCoords = false;
                        break;
                    }
                    default: {
                        LOGGER.log(Level.WARNING, "Unknown graphic element type: {0}", element.getType());
                        updateLastCoords = false;
                    }
                }
                if (!updateLastCoords) continue;
                this.lastX = this.x;
                this.lastY = this.y;
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "An IOException occurred: {0}", ex.getMessage());
        }
    }

    private void moveTo(double x, double y) {
        if (this.usePenProtector && this.getDistance(this.lastX, this.lastY, x, y) < 5.0) {
            this.writeByte((byte)56);
        } else {
            this.writeByte((byte)45);
        }
        this.writeInt((int)x);
        this.writeInt((int)y);
    }

    private void lineTo(double x, double y) {
        this.writeByte((byte)56);
        this.writeInt((int)x);
        this.writeInt((int)y);
    }

    private void writeByte(byte value) {
        try {
            this.outputStream.write(value);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "IOException: {0}", e.getMessage());
            System.exit(-1);
        }
    }

    private void writeInt(int value) {
        try {
            this.outputStream.write((byte)(value & 0xFF));
            this.outputStream.write((byte)(value >> 8 & 0xFF));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "IOException: {0}", e.getMessage());
            System.exit(-1);
        }
    }

    private void gatherStatistics(GraphicElements elements) {
        block6: for (int i = 0; i < elements.size(); ++i) {
            GraphicElement element = elements.get(i);
            switch (element.getType()) {
                case 1: {
                    Rect rect = (Rect)element;
                    this.x = rect.getX();
                    this.y = rect.getY();
                    this.lineCount += 5;
                    this.registerX(this.x);
                    this.registerX(this.x + rect.getWidth());
                    this.registerY(this.y);
                    this.registerY(this.y + rect.getHeight());
                    continue block6;
                }
                case 2: {
                    Circle circle = (Circle)element;
                    this.x = circle.getCx();
                    this.y = circle.getCy();
                    LineSegmentCreator creator = new LineSegmentCreator();
                    List<Line> lines = creator.buildLines(circle, element.getParent());
                    if (lines.isEmpty()) continue block6;
                    for (int idx = 0; idx < lines.size(); ++idx) {
                        ++this.lineCount;
                        Line line = lines.get(idx);
                        this.registerX(line.getX2());
                        this.registerY(line.getY2());
                    }
                    continue block6;
                }
                case 3: {
                    Line line = (Line)element;
                    if (this.x != line.getX1() || this.y != line.getY1()) {
                        ++this.lineCount;
                        this.registerX(line.getX1());
                        this.registerY(line.getY1());
                    }
                    if (this.x == line.getX2() && this.y == line.getY2()) continue block6;
                    this.x = line.getX2();
                    this.y = line.getY2();
                    ++this.lineCount;
                    this.registerX(this.x);
                    this.registerY(this.y);
                    continue block6;
                }
                case 5: 
                case 9: 
                case 13: {
                    continue block6;
                }
                default: {
                    LOGGER.log(Level.WARNING, "Unknown graphic element type: {0}", element.getType());
                }
            }
        }
    }

    private void registerX(double x) {
        int ix = (int)x;
        if (ix > this.maxX) {
            this.maxX = ix;
        }
        if (ix < this.minX) {
            this.minX = ix;
        }
    }

    private void registerY(double y) {
        int iy = (int)y;
        if (iy > this.maxY) {
            this.maxY = iy;
        }
        if (iy < this.minY) {
            this.minY = iy;
        }
    }

    private double getDistance(double x1, double y1, double x2, double y2) {
        return Util.distance(new Point(x1, y1), new Point(x2, y2));
    }
}

