/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.writer;

import de.berndbock.tinysvg.graphelem.Circle;
import de.berndbock.tinysvg.graphelem.GraphicElement;
import de.berndbock.tinysvg.graphelem.GraphicElements;
import de.berndbock.tinysvg.graphelem.Line;
import de.berndbock.tinysvg.graphelem.Rect;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ZXSpectrumWriter {
    private static final Logger LOGGER = Logger.getLogger("global");
    private static final byte PIX = 1;
    private static final byte LINE = 2;
    private static final byte LINETO = 3;
    private static final byte BOX = 4;
    private static final byte CIRCLE = 5;
    private static final byte END = 99;
    private static final int MAX_DATA = 65536;
    private final byte[] data = new byte[65536];
    private int byteCount = 0;

    public void write(GraphicElements elements, File outputFile) {
        GraphicElement prevElement = null;
        this.byteCount = 0;
        for (int i = 0; i < elements.size(); ++i) {
            GraphicElement element = elements.get(i);
            switch (element.getType()) {
                case 1: {
                    Rect rect = (Rect)element;
                    this.addByte((byte)4);
                    this.addByte(rect.getX());
                    this.addByte(rect.getY());
                    this.addByte(rect.getX() + rect.getWidth() - 1.0);
                    this.addByte(rect.getY() + rect.getHeight() - 1.0);
                    break;
                }
                case 2: {
                    Circle circle = (Circle)element;
                    this.addByte((byte)5);
                    this.addByte(circle.getCx());
                    this.addByte(circle.getCy());
                    this.addByte(circle.getR());
                    break;
                }
                case 3: {
                    Line prevLine;
                    boolean useLineTo = false;
                    Line line = (Line)element;
                    if (prevElement != null && prevElement.getType() == 3 && (prevLine = (Line)prevElement).getX2Int() == line.getX1Int() && prevLine.getY2Int() == line.getY1Int()) {
                        useLineTo = true;
                    }
                    if (useLineTo) {
                        this.addByte((byte)3);
                        this.addByte(line.getX2());
                        this.addByte(line.getY2());
                        break;
                    }
                    this.addByte((byte)2);
                    this.addByte(line.getX1());
                    this.addByte(line.getY1());
                    this.addByte(line.getX2());
                    this.addByte(line.getY2());
                    break;
                }
                case 5: 
                case 9: 
                case 13: {
                    break;
                }
                default: {
                    LOGGER.log(Level.WARNING, "Unknown graphic element type: {0}", element.getType());
                }
            }
            prevElement = element;
        }
        this.addByte((byte)99);
        try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
            ((OutputStream)outputStream).write(this.data, 0, this.byteCount);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "{0}: {1}", new Object[]{ex.getClass().getName(), ex.getMessage()});
        }
    }

    private void addByte(byte b) {
        if (this.byteCount < 65536) {
            this.data[this.byteCount++] = b;
        }
    }

    private void addByte(double d) {
        if (this.byteCount < 65536) {
            int i = (int)d;
            byte b = (byte)i;
            this.data[this.byteCount++] = b;
        }
    }
}

