/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.writer;

import de.berndbock.tinysvg.graphelem.Circle;
import de.berndbock.tinysvg.graphelem.Ellipse;
import de.berndbock.tinysvg.graphelem.GraphicElement;
import de.berndbock.tinysvg.graphelem.GraphicElements;
import de.berndbock.tinysvg.graphelem.Line;
import de.berndbock.tinysvg.graphelem.Rect;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ZXSpectrumSpeedplotExtWriter {
    private static final Logger LOGGER = Logger.getLogger("global");
    private static final byte MOVE = 77;
    private static final byte DRAW = 68;
    private static final byte CIRCLE = 67;
    private static final byte ELLIPSE = 69;
    private static final byte END = -1;
    private static final int MAX_DATA = 34800;
    private static final int MAX_Y = 191;
    private final byte[] data = new byte[34800];
    private int byteCount = 0;

    public void write(GraphicElements elements, File outputFile) {
        GraphicElement prevElement = null;
        this.byteCount = 0;
        for (int i = 0; i < elements.size(); ++i) {
            GraphicElement element = elements.get(i);
            switch (element.getType()) {
                case 1: {
                    Rect rect = (Rect)element;
                    double x2 = rect.getX() + rect.getWidth() - 1.0;
                    double y2 = rect.getY() + rect.getHeight() - 1.0;
                    this.addByte((byte)77);
                    this.addByte(rect.getX());
                    this.addByte(rect.getY());
                    this.addByte((byte)68);
                    this.addByte(x2);
                    this.addByte(rect.getY());
                    this.addByte((byte)68);
                    this.addByte(x2);
                    this.addByte(y2);
                    this.addByte((byte)68);
                    this.addByte(rect.getX());
                    this.addByte(y2);
                    this.addByte((byte)68);
                    this.addByte(rect.getX());
                    this.addByte(rect.getY());
                    break;
                }
                case 2: {
                    Circle circle = (Circle)element;
                    this.addByte((byte)67);
                    this.addByte(circle.getCx());
                    this.addByte(circle.getCy());
                    this.addByte(circle.getR());
                    break;
                }
                case 3: {
                    Line prevLine;
                    boolean useLineTo = false;
                    Line line = (Line)element;
                    if (prevElement != null && prevElement.getType() == 3 && (prevLine = (Line)prevElement).getX2Int() == line.getX1Int() && prevLine.getY2Int() == line.getY1Int()) {
                        useLineTo = true;
                    }
                    if (useLineTo) {
                        this.addByte((byte)68);
                        this.addByte(line.getX2());
                        this.addByte(line.getY2());
                        break;
                    }
                    this.addByte((byte)77);
                    this.addByte(line.getX1());
                    this.addByte(line.getY1());
                    this.addByte((byte)68);
                    this.addByte(line.getX2());
                    this.addByte(line.getY2());
                    break;
                }
                case 5: {
                    Ellipse ellipse = (Ellipse)element;
                    this.addByte((byte)69);
                    this.addByte(ellipse.getCx());
                    this.addByte(ellipse.getCy());
                    this.addByte(ellipse.getRy());
                    this.addByte(ellipse.getRx());
                    break;
                }
                case 9: 
                case 13: {
                    break;
                }
                default: {
                    LOGGER.log(Level.WARNING, "Unknown graphic element type: {0}", element.getType());
                }
            }
            prevElement = element;
        }
        this.addByte((byte)-1);
        try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
            ((OutputStream)outputStream).write(this.data, 0, this.byteCount);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "{0}: {1}", new Object[]{ex.getClass().getName(), ex.getMessage()});
        }
    }

    private void addByte(byte b) {
        if (this.byteCount < 34800) {
            this.data[this.byteCount++] = b;
        }
    }

    private void addByte(double d) {
        if (this.byteCount < 34800) {
            int i = (int)d;
            byte b = (byte)i;
            this.data[this.byteCount++] = b;
        }
    }
}

