/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.writer;

import de.berndbock.tinysvg.graphelem.Circle;
import de.berndbock.tinysvg.graphelem.GraphicElement;
import de.berndbock.tinysvg.graphelem.GraphicElements;
import de.berndbock.tinysvg.graphelem.Line;
import de.berndbock.tinysvg.graphelem.Rect;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ZX81Writer {
    private static final Logger LOGGER = Logger.getLogger("global");
    private static final byte[] BASIC_PRG_AFTER_REM = new byte[]{118, 0, 10, 15, 0, -15, 45, 20, 31, 30, 35, 31, 34, 126, -113, 127, -64, 0, 0, 118, 0, 12, 15, 0, -15, 59, 20, 29, 34, 33, 29, 32, 126, -113, 1, 4, 0, 0, 118, 0, 20, 8, 0, -11, -44, 45, 26, 40, 49, 56, 118, 0, 30, 7, 0, -11, -44, 45, 26, 52, 51, 118, 0, 40, 6, 0, -15, 39, 20, -45, 59, 118, 0, 45, 13, 0, -15, 59, 20, 59, 21, 29, 126, -127, 0, 0, 0, 0, 118, 0, 50, 34, 0, -6, 39, -36, 28, 126, 0, 0, 0, 0, 0, -38, 39, -37, 33, 126, -125, 32, 0, 0, 0, -34, -20, 39, 23, 29, 28, 28, 126, -121, 72, 0, 0, 0, 118, 0, 60, 23, 0, -6, 39, -35, 37, 37, 126, -121, 70, 0, 0, 0, -34, -20, 37, 28, 28, 126, -118, 97, 0, 0, 0, 118, 0, 70, 10, 0, -20, 35, 28, 126, -121, 12, 0, 0, 0, 118, 0, 100, 24, 0, -11, -44, 45, 26, 53, 46, 61, 26, -45, 59, 26, -45, 16, 59, 21, 29, 126, -127, 0, 0, 0, 0, 17, 118, 0, 110, 13, 0, -15, 59, 20, 59, 21, 30, 126, -126, 0, 0, 0, 0, 118, 0, 120, 10, 0, -20, 32, 28, 126, -122, 32, 0, 0, 0, 118, 0, -56, 51, 0, -11, -44, 45, 26, 49, 46, 51, 42, 26, -45, 59, 26, -45, 16, 59, 21, 29, 126, -127, 0, 0, 0, 0, 17, 26, -45, 16, 59, 21, 30, 126, -126, 0, 0, 0, 0, 17, 26, -45, 16, 59, 21, 31, 126, -126, 64, 0, 0, 0, 17, 118, 0, -46, 13, 0, -15, 59, 20, 59, 21, 32, 126, -125, 0, 0, 0, 0, 118, 0, -36, 10, 0, -20, 32, 28, 126, -122, 32, 0, 0, 0, 118, 1, 44, 27, 0, -11, -44, 45, 26, 49, 46, 51, 42, 57, 52, 26, -45, 59, 26, -45, 16, 59, 21, 29, 126, -127, 0, 0, 0, 0, 17, 118, 1, 54, 13, 0, -15, 59, 20, 59, 21, 30, 126, -126, 0, 0, 0, 0, 118, 1, 64, 10, 0, -20, 32, 28, 126, -122, 32, 0, 0, 0, 118, 1, -112, 50, 0, -11, -44, 45, 26, 39, 52, 61, 26, -45, 59, 26, -45, 16, 59, 21, 29, 126, -127, 0, 0, 0, 0, 17, 26, -45, 16, 59, 21, 30, 126, -126, 0, 0, 0, 0, 17, 26, -45, 16, 59, 21, 31, 126, -126, 64, 0, 0, 0, 17, 118, 1, -102, 13, 0, -15, 59, 20, 59, 21, 32, 126, -125, 0, 0, 0, 0, 118, 1, -92, 10, 0, -20, 32, 28, 126, -122, 32, 0, 0, 0, 118, 1, -12, 40, 0, -11, -44, 45, 26, 40, 46, 55, 40, 49, 42, 26, -45, 59, 26, -45, 16, 59, 21, 29, 126, -127, 0, 0, 0, 0, 17, 26, -45, 16, 59, 21, 30, 126, -126, 0, 0, 0, 0, 17, 118, 1, -2, 13, 0, -15, 59, 20, 59, 21, 31, 126, -126, 64, 0, 0, 0, 118, 2, 8, 10, 0, -20, 32, 28, 126, -122, 32, 0, 0, 0, 118, 3, -124, 10, 0, -11, 11, 43, 42, 45, 49, 42, 55, 11, 118, 3, -114, 11, 0, -20, 37, 29, 28, 126, -118, 99, -128, 0, 0};
    private static final byte[] VARS = new byte[]{-128};
    private static final byte PIX = 1;
    private static final byte LINE = 2;
    private static final byte LINETO = 3;
    private static final byte BOX = 4;
    private static final byte CIRCLE = 5;
    private static final byte END = 99;
    private static final int MAX_DATA = 65536;
    private final byte[] data = new byte[65536];
    private int byteCount = 0;
    private int remByteCount = 0;

    public void write(GraphicElements elements, File outputFile) {
        GraphicElement prevElement = null;
        this.byteCount = 121;
        for (int i = 0; i < elements.size(); ++i) {
            GraphicElement element = elements.get(i);
            switch (element.getType()) {
                case 1: {
                    Rect rect = (Rect)element;
                    this.addByte((byte)4);
                    this.addByte(rect.getX());
                    this.addByte(rect.getY());
                    this.addByte(rect.getX() + rect.getWidth() - 1.0);
                    this.addByte(rect.getY() - rect.getHeight() + 1.0);
                    break;
                }
                case 2: {
                    Circle circle = (Circle)element;
                    this.addByte((byte)5);
                    this.addByte(circle.getCx());
                    this.addByte(circle.getCy());
                    this.addByte(circle.getR());
                    break;
                }
                case 3: {
                    Line prevLine;
                    boolean useLineTo = false;
                    Line line = (Line)element;
                    if (prevElement != null && prevElement.getType() == 3 && (prevLine = (Line)prevElement).getX2Int() == line.getX1Int() && prevLine.getY2Int() == line.getY1Int()) {
                        useLineTo = true;
                    }
                    if (useLineTo) {
                        this.addByte((byte)3);
                        this.addByte(line.getX2());
                        this.addByte(line.getY2());
                        break;
                    }
                    this.addByte((byte)2);
                    this.addByte(line.getX1());
                    this.addByte(line.getY1());
                    this.addByte(line.getX2());
                    this.addByte(line.getY2());
                    break;
                }
                case 5: 
                case 9: 
                case 13: {
                    break;
                }
                default: {
                    LOGGER.log(Level.WARNING, "Unknown graphic element type: {0}", element.getType());
                }
            }
            prevElement = element;
        }
        this.addByte((byte)99);
        this.addBytes(BASIC_PRG_AFTER_REM);
        this.addScreen();
        this.addBytes(VARS);
        this.setSysVars();
        this.setRemLineBeginning();
        try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
            ((OutputStream)outputStream).write(this.data, 0, this.byteCount);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "{0}: {1}", new Object[]{ex.getClass().getName(), ex.getMessage()});
        }
    }

    private void addByte(byte b) {
        if (this.byteCount < 65536) {
            ++this.remByteCount;
            this.data[this.byteCount++] = b;
        }
    }

    private void addByte(double d) {
        if (this.byteCount < 65536) {
            ++this.remByteCount;
            int i = (int)d;
            byte b = (byte)i;
            this.data[this.byteCount++] = b;
        }
    }

    private void addBytes(byte[] b) {
        System.arraycopy(b, 0, this.data, this.byteCount, b.length);
        this.byteCount += b.length;
    }

    private void setIntLittleEndian(int index, int value) {
        this.data[index++] = (byte)(value & 0xFF);
        this.data[index] = (byte)(value >> 8 & 0xFF);
    }

    private void setIntBigEndian(int index, int value) {
        this.data[index++] = (byte)(value >> 8 & 0xFF);
        this.data[index] = (byte)(value & 0xFF);
    }

    private void setByte(int index, byte value) {
        this.data[index++] = value;
    }

    private byte newline() {
        return 118;
    }

    private void setSysVars() {
        int addr;
        this.setIntLittleEndian(1, 10);
        int dFile = addr = 16514 + this.remByteCount + BASIC_PRG_AFTER_REM.length + 1;
        this.setIntLittleEndian(3, addr++);
        this.setIntLittleEndian(5, addr);
        addr += 792;
        this.setIntLittleEndian(7, addr++);
        this.setIntLittleEndian(11, addr);
        int n = ++addr;
        this.setIntLittleEndian(13, n);
        this.setIntLittleEndian(17, ++addr);
        this.setIntLittleEndian(19, addr);
        this.setIntLittleEndian(22, 16477);
        this.setByte(25, (byte)2);
        this.setIntLittleEndian(28, 65535);
        this.setByte(30, (byte)15);
        this.setByte(31, (byte)55);
        this.setIntLittleEndian(32, dFile);
        this.setIntLittleEndian(39, 3179);
        this.setIntLittleEndian(43, 64893);
        this.setByte(47, (byte)-68);
        this.setByte(48, (byte)33);
        this.setByte(49, (byte)24);
        this.setByte(50, (byte)64);
        this.setByte(83, (byte)118);
    }

    private void setRemLineBeginning() {
        this.setIntBigEndian(116, 1);
        this.setIntLittleEndian(118, this.remByteCount + 2);
        this.setByte(120, (byte)-22);
    }

    private void addScreen() {
        this.data[this.byteCount++] = this.newline();
        for (int line = 0; line < 24; ++line) {
            this.data[this.byteCount++] = this.newline();
            for (int col = 0; col < 32; ++col) {
                this.data[this.byteCount++] = 0;
            }
        }
        this.data[this.byteCount++] = this.newline();
    }
}

