/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.writer;

import de.berndbock.tinysvg.graphelem.Circle;
import de.berndbock.tinysvg.graphelem.Ellipse;
import de.berndbock.tinysvg.graphelem.GraphicElement;
import de.berndbock.tinysvg.graphelem.GraphicElements;
import de.berndbock.tinysvg.graphelem.Line;
import de.berndbock.tinysvg.graphelem.PolyLine;
import de.berndbock.tinysvg.graphelem.Rect;
import de.berndbock.tinysvg.helper.Point;
import de.berndbock.tinysvg.writer.LineCoords;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VecWriter {
    private static final Logger LOGGER = Logger.getLogger("global");
    private static final byte[] HEADER = new byte[]{86, 69, 67};
    private final boolean divideHeightBy2;

    public VecWriter(boolean divideHeightBy2) {
        this.divideHeightBy2 = divideHeightBy2;
    }

    public void write(GraphicElements elements, File outputFile) {
        try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
            ((OutputStream)outputStream).write(HEADER);
            GraphicElement prevElement = null;
            LineCoords lineCoords = new LineCoords();
            for (int i = 0; i < elements.size(); ++i) {
                GraphicElement element = elements.get(i);
                switch (element.getType()) {
                    case 1: {
                        Rect rect = (Rect)element;
                        if (rect.getWidth() == rect.getHeight()) {
                            this.writeSquare(outputStream, rect);
                            break;
                        }
                        this.writeRect(outputStream, rect);
                        break;
                    }
                    case 2: {
                        Circle circle = (Circle)element;
                        ((OutputStream)outputStream).write(5);
                        this.writeInt1(outputStream, (int)circle.getCx());
                        this.writeInt2(outputStream, (int)circle.getCy());
                        this.writeInt1(outputStream, (int)circle.getR());
                        break;
                    }
                    case 3: {
                        Line line = (Line)element;
                        if (prevElement != null && prevElement.getType() == 3) {
                            Line prevLine = (Line)prevElement;
                            if (prevLine.getX2Int() != line.getX1Int() || prevLine.getY2Int() != line.getY1Int()) {
                                if (lineCoords.numberOfDots() > 0) {
                                    this.writeMultiLine(outputStream, lineCoords);
                                    lineCoords.reset();
                                }
                                lineCoords.add(line.getX1Int(), line.getY1Int());
                            }
                            lineCoords.add(line.getX2Int(), line.getY2Int());
                            break;
                        }
                        lineCoords.reset();
                        lineCoords.add(line.getX1Int(), line.getY1Int());
                        lineCoords.add(line.getX2Int(), line.getY2Int());
                        break;
                    }
                    case 5: {
                        Ellipse ellipse = (Ellipse)element;
                        ((OutputStream)outputStream).write(4);
                        this.writeInt1(outputStream, (int)ellipse.getCx());
                        this.writeInt2(outputStream, (int)ellipse.getCy());
                        this.writeInt1(outputStream, (int)ellipse.getRx());
                        this.writeInt2(outputStream, (int)ellipse.getRy());
                        break;
                    }
                    case 6: 
                    case 7: {
                        PolyLine polyLine = (PolyLine)element;
                        ((OutputStream)outputStream).write(11);
                        List<Point> points = polyLine.getPointsList();
                        ((OutputStream)outputStream).write(points.size());
                        for (Point p : points) {
                            this.writeInt1(outputStream, (int)p.x);
                            this.writeInt2(outputStream, (int)p.y);
                        }
                        break;
                    }
                    case 9: 
                    case 13: {
                        break;
                    }
                    default: {
                        LOGGER.log(Level.WARNING, "Unknown graphic element type: {0}", element.getType());
                    }
                }
                if (lineCoords.hasData()) {
                    if (lineCoords.numberOfDots() >= 255) {
                        this.writeMultiLine(outputStream, lineCoords);
                        lineCoords.reset();
                    } else if (element.getType() != 3) {
                        if (lineCoords.numberOfDots() == 2) {
                            this.writeLine(outputStream, lineCoords);
                        } else {
                            this.writeMultiLine(outputStream, lineCoords);
                        }
                        lineCoords.reset();
                    }
                }
                prevElement = element;
            }
            if (lineCoords.hasData()) {
                if (lineCoords.numberOfDots() == 2) {
                    this.writeLine(outputStream, lineCoords);
                } else {
                    this.writeMultiLine(outputStream, lineCoords);
                }
            }
            ((OutputStream)outputStream).write(99);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "IOException: {0}", ex.getMessage());
        }
    }

    private void writeLine(OutputStream outputStream, LineCoords lineCoords) throws IOException {
        outputStream.write(1);
        this.writeInt1(outputStream, lineCoords.getX(0));
        this.writeInt2(outputStream, lineCoords.getY(0));
        this.writeInt1(outputStream, lineCoords.getX(1));
        this.writeInt2(outputStream, lineCoords.getY(1));
    }

    private void writeMultiLine(OutputStream outputStream, LineCoords lineCoords) throws IOException {
        outputStream.write(11);
        outputStream.write(lineCoords.numberOfDots());
        for (int i = 0; i < lineCoords.numberOfDots(); ++i) {
            this.writeInt1(outputStream, lineCoords.getX(i));
            this.writeInt2(outputStream, lineCoords.getY(i));
        }
    }

    private void writeSquare(OutputStream outputStream, Rect rect) throws IOException {
        outputStream.write(3);
        this.writeInt1(outputStream, (int)rect.getX());
        this.writeInt2(outputStream, (int)rect.getY());
        this.writeInt1(outputStream, (int)(rect.getX() + rect.getWidth() - 1.0));
    }

    private void writeRect(OutputStream outputStream, Rect rect) throws IOException {
        outputStream.write(2);
        this.writeInt1(outputStream, (int)rect.getX());
        this.writeInt2(outputStream, (int)rect.getY());
        this.writeInt1(outputStream, (int)(rect.getX() + rect.getWidth() - 1.0));
        this.writeInt2(outputStream, (int)(rect.getY() + rect.getHeight() - 1.0));
    }

    private void writeInt1(OutputStream outputStream, int value) throws IOException {
        outputStream.write((byte)(value & 0xFF));
        outputStream.write((byte)(value >> 8 & 0xFF));
    }

    private void writeInt2(OutputStream outputStream, int value) throws IOException {
        if (this.divideHeightBy2) {
            value >>= 1;
        }
        this.writeInt1(outputStream, value);
    }
}

