/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.writer;

import de.berndbock.tinysvg.graphelem.Circle;
import de.berndbock.tinysvg.graphelem.Ellipse;
import de.berndbock.tinysvg.graphelem.GraphicElement;
import de.berndbock.tinysvg.graphelem.GraphicElements;
import de.berndbock.tinysvg.graphelem.Line;
import de.berndbock.tinysvg.graphelem.PolyLine;
import de.berndbock.tinysvg.graphelem.Rect;
import de.berndbock.tinysvg.helper.Point;
import de.berndbock.tinysvg.writer.LineCoords;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Ve2Writer {
    private static final Logger LOGGER = Logger.getLogger("global");
    private static final byte[] HEADER = new byte[]{86, 69, 50};
    private final boolean divideHeightBy2;
    private final int minX;
    private final int maxX;
    private final int minY;
    private final int maxY;
    private final int targetResolutionX;
    private final int targetResolutionY;
    private final byte bytesXCoord;
    private final byte bytesYCoord;
    private final int profileFlags;

    public Ve2Writer(boolean divideHeightBy2, int minX, int maxX, int minY, int maxY, int targetResolutionX, int targetResolutionY, byte bytesXCoord, byte bytesYCoord, int profileFlags) {
        this.divideHeightBy2 = divideHeightBy2;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.targetResolutionX = targetResolutionX;
        this.targetResolutionY = targetResolutionY;
        this.bytesXCoord = bytesXCoord;
        this.bytesYCoord = bytesYCoord;
        this.profileFlags = profileFlags;
    }

    public void write(GraphicElements elements, File outputFile) {
        try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
            boolean inProfile;
            ((OutputStream)outputStream).write(HEADER);
            this.writeInt(outputStream, this.minX);
            this.writeInt(outputStream, this.maxX);
            this.writeInt(outputStream, this.minY);
            this.writeInt(outputStream, this.maxY);
            this.writeInt(outputStream, this.targetResolutionX);
            this.writeInt(outputStream, this.targetResolutionY);
            this.writeByte(outputStream, this.bytesXCoord);
            this.writeByte(outputStream, this.bytesYCoord);
            this.writeInt(outputStream, this.profileFlags);
            GraphicElement prevElement = null;
            LineCoords lineCoords = new LineCoords();
            for (int i = 0; i < elements.size(); ++i) {
                inProfile = true;
                GraphicElement element = elements.get(i);
                switch (element.getType()) {
                    case 1: {
                        Rect rect = (Rect)element;
                        if (rect.getWidth() == rect.getHeight()) {
                            inProfile = this.writeSquare(outputStream, rect);
                            break;
                        }
                        inProfile = this.writeRect(outputStream, rect);
                        break;
                    }
                    case 2: {
                        Circle circle = (Circle)element;
                        inProfile = this.writeCircle(outputStream, circle);
                        break;
                    }
                    case 3: {
                        Line line = (Line)element;
                        if (prevElement != null && prevElement.getType() == 3) {
                            Line prevLine = (Line)prevElement;
                            if (prevLine.getX2Int() != line.getX1Int() || prevLine.getY2Int() != line.getY1Int()) {
                                if (lineCoords.numberOfDots() > 0) {
                                    inProfile = this.writeMultiLine(outputStream, lineCoords);
                                    lineCoords.reset();
                                }
                                lineCoords.add(line.getX1Int(), line.getY1Int());
                            }
                            lineCoords.add(line.getX2Int(), line.getY2Int());
                            break;
                        }
                        lineCoords.reset();
                        lineCoords.add(line.getX1Int(), line.getY1Int());
                        lineCoords.add(line.getX2Int(), line.getY2Int());
                        break;
                    }
                    case 5: {
                        Ellipse ellipse = (Ellipse)element;
                        inProfile = this.writeEllipse(outputStream, ellipse);
                        break;
                    }
                    case 6: 
                    case 7: {
                        PolyLine polyLine = (PolyLine)element;
                        ((OutputStream)outputStream).write(11);
                        List<Point> points = polyLine.getPointsList();
                        ((OutputStream)outputStream).write(points.size());
                        for (Point p : points) {
                            this.writeX(outputStream, (int)p.x);
                            this.writeY(outputStream, (int)p.y);
                        }
                        break;
                    }
                    case 9: 
                    case 13: {
                        break;
                    }
                    default: {
                        LOGGER.log(Level.WARNING, "Unknown graphic element type: {0}", element.getType());
                    }
                }
                if (lineCoords.hasData()) {
                    if (lineCoords.numberOfDots() >= 255) {
                        inProfile = this.writeMultiLine(outputStream, lineCoords);
                        lineCoords.reset();
                    } else if (element.getType() != 3) {
                        inProfile = lineCoords.numberOfDots() == 2 ? this.writeLine(outputStream, lineCoords) : this.writeMultiLine(outputStream, lineCoords);
                        lineCoords.reset();
                    }
                }
                if (!inProfile) {
                    LOGGER.log(Level.WARNING, "Not in profile: {0}", element.getType());
                }
                prevElement = element;
            }
            if (lineCoords.hasData() && !(inProfile = lineCoords.numberOfDots() == 2 ? this.writeLine(outputStream, lineCoords) : this.writeMultiLine(outputStream, lineCoords))) {
                LOGGER.log(Level.WARNING, "Not in profile: {0}", 3);
            }
            ((OutputStream)outputStream).write(99);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "IOException: {0}", ex.getMessage());
        }
    }

    private boolean writeSquare(OutputStream outputStream, Rect rect) throws IOException {
        boolean inProfile;
        boolean bl = inProfile = (this.profileFlags & 8) != 0;
        if (inProfile) {
            outputStream.write(3);
            this.writeX(outputStream, (int)rect.getX());
            this.writeY(outputStream, (int)rect.getY());
            if (this.bytesXCoord >= this.bytesYCoord) {
                this.writeX(outputStream, (int)rect.getWidth());
            } else {
                this.writeY(outputStream, (int)rect.getWidth());
            }
        } else {
            boolean bl2 = inProfile = (this.profileFlags & 2) != 0;
            if (inProfile) {
                this.writeRectAsLines(outputStream, rect);
            } else {
                boolean bl3 = inProfile = (this.profileFlags & 0x80) != 0;
                if (inProfile) {
                    this.writeRectAsMultiLine(outputStream, rect);
                }
            }
        }
        return inProfile;
    }

    private boolean writeRect(OutputStream outputStream, Rect rect) throws IOException {
        boolean inProfile;
        boolean bl = inProfile = (this.profileFlags & 8) != 0;
        if (inProfile) {
            outputStream.write(2);
            this.writeX(outputStream, (int)rect.getX());
            this.writeY(outputStream, (int)rect.getY());
            this.writeX(outputStream, (int)(rect.getX() + rect.getWidth() - 1.0));
            this.writeY(outputStream, (int)(rect.getY() + rect.getHeight() - 1.0));
        } else {
            boolean bl2 = inProfile = (this.profileFlags & 0x80) != 0;
            if (inProfile) {
                this.writeRectAsMultiLine(outputStream, rect);
            } else {
                boolean bl3 = inProfile = (this.profileFlags & 2) != 0;
                if (inProfile) {
                    this.writeRectAsLines(outputStream, rect);
                }
            }
        }
        return inProfile;
    }

    private void writeRectAsMultiLine(OutputStream outputStream, Rect rect) throws IOException {
        int x1 = (int)rect.getX();
        int y1 = (int)rect.getY();
        int x2 = (int)(rect.getX() + rect.getWidth() - 1.0);
        int y2 = (int)(rect.getY() + rect.getHeight() - 1.0);
        outputStream.write(11);
        this.writeByte(outputStream, (byte)5);
        this.writeX(outputStream, x1);
        this.writeY(outputStream, y1);
        this.writeX(outputStream, x2);
        this.writeY(outputStream, y1);
        this.writeX(outputStream, x2);
        this.writeY(outputStream, y2);
        this.writeX(outputStream, x1);
        this.writeY(outputStream, y1);
        this.writeX(outputStream, x1);
        this.writeY(outputStream, y1);
    }

    private void writeRectAsLines(OutputStream outputStream, Rect rect) throws IOException {
        int x1 = (int)rect.getX();
        int y1 = (int)rect.getY();
        int x2 = (int)(rect.getX() + rect.getWidth() - 1.0);
        int y2 = (int)(rect.getY() + rect.getHeight() - 1.0);
        outputStream.write(1);
        this.writeX(outputStream, x1);
        this.writeY(outputStream, y1);
        this.writeX(outputStream, x2);
        this.writeY(outputStream, y1);
        outputStream.write(1);
        this.writeX(outputStream, x2);
        this.writeY(outputStream, y1);
        this.writeX(outputStream, x2);
        this.writeY(outputStream, y2);
        outputStream.write(1);
        this.writeX(outputStream, x2);
        this.writeY(outputStream, y2);
        this.writeX(outputStream, x1);
        this.writeY(outputStream, y1);
        outputStream.write(1);
        this.writeX(outputStream, x1);
        this.writeY(outputStream, y2);
        this.writeX(outputStream, x1);
        this.writeY(outputStream, y1);
    }

    private boolean writeCircle(OutputStream outputStream, Circle circle) throws IOException {
        boolean inProfile;
        boolean bl = inProfile = (this.profileFlags & 0x20) != 0;
        if (inProfile) {
            outputStream.write(5);
            this.writeX(outputStream, (int)circle.getCx());
            this.writeY(outputStream, (int)circle.getCy());
            if (this.bytesXCoord >= this.bytesYCoord) {
                this.writeX(outputStream, (int)circle.getR());
            } else {
                this.writeY(outputStream, (int)circle.getR());
            }
        }
        return inProfile;
    }

    private boolean writeLine(OutputStream outputStream, LineCoords lineCoords) throws IOException {
        boolean inProfile;
        boolean bl = inProfile = (this.profileFlags & 2) != 0;
        if (inProfile) {
            outputStream.write(1);
            this.writeX(outputStream, lineCoords.getX(0));
            this.writeY(outputStream, lineCoords.getY(0));
            this.writeX(outputStream, lineCoords.getX(1));
            this.writeY(outputStream, lineCoords.getY(1));
        }
        return inProfile;
    }

    private boolean writeMultiLine(OutputStream outputStream, LineCoords lineCoords) throws IOException {
        boolean inProfile;
        boolean bl = inProfile = (this.profileFlags & 2) != 0;
        if (inProfile) {
            outputStream.write(11);
            this.writeByte(outputStream, (byte)lineCoords.numberOfDots());
            for (int i = 0; i < lineCoords.numberOfDots(); ++i) {
                this.writeX(outputStream, lineCoords.getX(i));
                this.writeY(outputStream, lineCoords.getY(i));
            }
        }
        return inProfile;
    }

    private boolean writeEllipse(OutputStream outputStream, Ellipse ellipse) throws IOException {
        boolean inProfile;
        boolean bl = inProfile = (this.profileFlags & 0x10) != 0;
        if (inProfile) {
            outputStream.write(4);
            this.writeX(outputStream, (int)ellipse.getCx());
            this.writeY(outputStream, (int)ellipse.getCy());
            this.writeX(outputStream, (int)ellipse.getRx());
            this.writeY(outputStream, (int)ellipse.getRy());
        }
        return inProfile;
    }

    private void writeX(OutputStream outputStream, int x) throws IOException {
        if (this.bytesXCoord == 1) {
            this.writeByte(outputStream, (byte)(x & 0xFF));
        } else {
            this.writeInt(outputStream, x);
        }
    }

    private void writeY(OutputStream outputStream, int y) throws IOException {
        if (this.divideHeightBy2) {
            y >>= 1;
        }
        if (this.bytesYCoord == 1) {
            this.writeByte(outputStream, (byte)(y & 0xFF));
        } else {
            this.writeInt(outputStream, y);
        }
    }

    private void writeByte(OutputStream outputStream, byte value) throws IOException {
        outputStream.write(value);
    }

    private void writeInt(OutputStream outputStream, int value) throws IOException {
        outputStream.write((byte)(value & 0xFF));
        outputStream.write((byte)(value >> 8 & 0xFF));
    }
}

