/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.writer;

import de.berndbock.tinysvg.graphelem.Circle;
import de.berndbock.tinysvg.graphelem.Ellipse;
import de.berndbock.tinysvg.graphelem.GraphicElement;
import de.berndbock.tinysvg.graphelem.GraphicElements;
import de.berndbock.tinysvg.graphelem.Line;
import de.berndbock.tinysvg.graphelem.PolyLine;
import de.berndbock.tinysvg.graphelem.Polygon;
import de.berndbock.tinysvg.graphelem.Rect;
import de.berndbock.tinysvg.helper.Point;
import de.berndbock.tinysvg.util.Util;
import de.berndbock.tinysvg.writer.LineCoords;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SvgWriter {
    private static final Logger LOGGER = Logger.getLogger("global");

    public void write(GraphicElements elements, File outputFile, int viewboxWidth, int viewboxHeight) {
        try (PrintWriter printWriter = new PrintWriter(new FileWriter(outputFile));){
            printWriter.printf("%s%d %d%s\n", "<svg viewbox=\"0 0 ", viewboxWidth, viewboxHeight, "\" xmlns=\"http://www.w3.org/2000/svg\">");
            GraphicElement prevElement = null;
            LineCoords lineCoords = new LineCoords();
            for (int i = 0; i < elements.size(); ++i) {
                GraphicElement element = elements.get(i);
                switch (element.getType()) {
                    case 1: {
                        Rect rect = (Rect)element;
                        printWriter.print("<rect x=\"");
                        printWriter.print(Util.prettyPrint(rect.getX()));
                        printWriter.print("\" y=\"");
                        printWriter.print(Util.prettyPrint(rect.getY()));
                        printWriter.print("\" width=\"");
                        printWriter.print(Util.prettyPrint(rect.getWidth()));
                        printWriter.print("\" height=\"");
                        printWriter.print(Util.prettyPrint(rect.getHeight()));
                        printWriter.print("\" stroke=\"black\" fill=\"none\" />\n");
                        break;
                    }
                    case 2: {
                        Circle circle = (Circle)element;
                        printWriter.print("<circle cx=\"");
                        printWriter.print(Util.prettyPrint(circle.getCx()));
                        printWriter.print("\" cy=\"");
                        printWriter.print(Util.prettyPrint(circle.getCy()));
                        printWriter.print("\" r=\"");
                        printWriter.print(Util.prettyPrint(circle.getR()));
                        printWriter.print("\" stroke=\"black\" fill=\"none\" />\n");
                        break;
                    }
                    case 3: {
                        Line line = (Line)element;
                        printWriter.print("<line x1=\"");
                        printWriter.print(Util.prettyPrint(line.getX1()));
                        printWriter.print("\" y1=\"");
                        printWriter.print(Util.prettyPrint(line.getY1()));
                        printWriter.print("\" x2=\"");
                        printWriter.print(Util.prettyPrint(line.getX2()));
                        printWriter.print("\" y2=\"");
                        printWriter.print(Util.prettyPrint(line.getY2()));
                        printWriter.print("\" stroke=\"black\" />\n");
                        break;
                    }
                    case 5: {
                        Ellipse ellipse = (Ellipse)element;
                        printWriter.print("<ellipse cx=\"");
                        printWriter.print(Util.prettyPrint(ellipse.getCx()));
                        printWriter.print("\" cy=\"");
                        printWriter.print(Util.prettyPrint(ellipse.getCy()));
                        printWriter.print("\" rx=\"");
                        printWriter.print(Util.prettyPrint(ellipse.getRx()));
                        printWriter.print("\" ry=\"");
                        printWriter.print(Util.prettyPrint(ellipse.getRy()));
                        printWriter.print("\" stroke=\"black\" fill=\"none\" />\n");
                        break;
                    }
                    case 6: {
                        PolyLine polyLine = (PolyLine)element;
                        printWriter.print("<polyline points=\"");
                        printWriter.print(this.getPoints(polyLine));
                        printWriter.print("\" stroke=\"black\" />\n");
                        break;
                    }
                    case 7: {
                        Polygon polygon = (Polygon)element;
                        printWriter.print("<polygon points=\"");
                        printWriter.print(this.getPoints(polygon));
                        printWriter.print("\" stroke=\"black\" />\n");
                        break;
                    }
                    case 9: 
                    case 13: {
                        break;
                    }
                    default: {
                        LOGGER.log(Level.WARNING, "Unknown graphic element type: {0}", element.getType());
                    }
                }
                prevElement = element;
            }
            printWriter.print("</svg>\n");
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "IOException: {0}", ex.getMessage());
        }
    }

    private String getPoints(PolyLine polyLine) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        List<Point> points = polyLine.getPointsList();
        for (Point p : points) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(p.x).append(',').append(p.y);
        }
        return sb.toString();
    }
}

