/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.writer;

import de.berndbock.tinysvg.graphelem.Circle;
import de.berndbock.tinysvg.graphelem.GraphicElement;
import de.berndbock.tinysvg.graphelem.GraphicElements;
import de.berndbock.tinysvg.graphelem.Line;
import de.berndbock.tinysvg.graphelem.Rect;
import de.berndbock.tinysvg.helper.LineSegmentCreator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EggPainter {
    private static final Logger LOGGER = Logger.getLogger("global");
    private PrintWriter writer = null;
    private double x = 0.0;
    private double y = 0.0;

    public void write(GraphicElements elements, File outputFile) {
        try (PrintWriter printWriter = new PrintWriter(new FileWriter(outputFile));){
            this.writer = printWriter;
            this.writer.println("gosub @nullpos");
            block17: for (int i = 0; i < elements.size(); ++i) {
                GraphicElement element = elements.get(i);
                switch (element.getType()) {
                    case 1: {
                        Rect rect = (Rect)element;
                        this.x = rect.getX();
                        this.y = rect.getY();
                        this.moveTo(this.x, this.y);
                        this.x += rect.getWidth();
                        this.lineTo(this.x, this.y);
                        this.y += rect.getHeight();
                        this.lineTo(this.x, this.y);
                        this.x = rect.getX();
                        this.lineTo(this.x, this.y);
                        this.y = rect.getY();
                        this.lineTo(this.x, this.y);
                        continue block17;
                    }
                    case 2: {
                        Circle circle = (Circle)element;
                        LineSegmentCreator creator = new LineSegmentCreator();
                        List<Line> lines = creator.buildLines(circle, element.getParent());
                        if (lines.isEmpty()) continue block17;
                        Line line = lines.get(0);
                        this.moveTo(line.getX1(), line.getY1());
                        this.lineTo(line.getX2(), line.getY2());
                        for (int idx = 1; idx < lines.size(); ++idx) {
                            line = lines.get(idx);
                            this.moveTo(line.getX2(), line.getY2());
                        }
                        continue block17;
                    }
                    case 3: {
                        Line line = (Line)element;
                        if (this.x != line.getX1() || this.y != line.getY1()) {
                            this.moveTo(line.getX1(), line.getY1());
                        }
                        if (this.x == line.getX2() && this.y == line.getY2()) continue block17;
                        this.x = line.getX2();
                        this.y = line.getY2();
                        this.lineTo(this.x, this.y);
                        continue block17;
                    }
                    case 5: 
                    case 9: 
                    case 13: {
                        continue block17;
                    }
                    default: {
                        LOGGER.log(Level.WARNING, "Unknown graphic element type: {0}", element.getType());
                    }
                }
            }
            this.writer.println("gosub @nullpos");
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "IOException: {0}", ex.getMessage());
        }
    }

    private void moveTo(double x, double y) {
        this.writer.println("gosub @heben");
        this.writer.printf("let x=%d", (int)x);
        this.writer.println();
        this.writer.printf("let y=%d", (int)y);
        this.writer.println();
        this.writer.println("gosub @line");
    }

    private void lineTo(double x, double y) {
        this.writer.printf("let x=%d", (int)x);
        this.writer.println();
        this.writer.printf("let y=%d", (int)y);
        this.writer.println();
        this.writer.println("gosub @sline");
    }
}

