/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.util;

import de.berndbock.tinysvg.helper.Point;
import java.text.NumberFormat;

public class Util {
    private static final NumberFormat numberFormat = NumberFormat.getInstance();

    private Util() {
    }

    public static int toInt(String value) {
        int i;
        if (value == null) {
            return 0;
        }
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException e1) {
            try {
                float f = Float.parseFloat(value);
                i = (int)f;
            }
            catch (NumberFormatException e2) {
                i = 0;
            }
        }
        return i;
    }

    public static double toDouble(String value) {
        double d;
        try {
            d = Double.parseDouble(value);
        }
        catch (NumberFormatException e2) {
            d = 0.0;
        }
        return d;
    }

    public static String format(double number, int digits) {
        numberFormat.setMaximumFractionDigits(digits);
        return numberFormat.format(number);
    }

    public static double distance(Point p1, Point p2) {
        double dy = p2.y - p1.y;
        double dx = p2.x - p1.x;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static byte bytesNeeded(int number) {
        return (byte)Math.ceil(Math.log(number) / Math.log(2.0) / 8.0);
    }

    public static double computeScaleFactor(double resolutionX, double resolutionY, double w, double h) {
        double d1 = (resolutionX - 1.0) / w;
        double d2 = (resolutionY - 1.0) / h;
        return Math.min(d1, d2);
    }

    public static String prettyPrint(double d) {
        int i = (int)d;
        return d == (double)i ? String.valueOf(i) : String.valueOf(d);
    }
}

