/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.helper;

import de.berndbock.tinysvg.graphelem.GraphicElement;
import de.berndbock.tinysvg.graphelem.GraphicElements;
import de.berndbock.tinysvg.helper.CoordMinMax;
import de.berndbock.tinysvg.helper.Point;
import de.berndbock.tinysvg.helper.Rotator;
import java.util.logging.Logger;

public class TreeRotator {
    private static final Logger LOGGER = Logger.getLogger(GraphicElements.class.getName());
    private final double angle;
    private CoordMinMax coordMinMax;
    private Rotator rot;
    private double offsetX;
    private double offsetY;

    public TreeRotator(double angle, CoordMinMax coordMinMax) {
        this.angle = angle;
        this.coordMinMax = coordMinMax;
    }

    public void setCoordMinMax(CoordMinMax coordMinMax) {
        this.coordMinMax = coordMinMax;
    }

    public boolean rotateClockwise(GraphicElement element) {
        boolean performRotation;
        boolean bl = performRotation = this.angle != 0.0;
        if (performRotation) {
            Point minimum = this.coordMinMax.getMinimum();
            Point maximum = this.coordMinMax.getMaximum();
            double centerX = (minimum.x + maximum.x) / 2.0;
            double centerY = (minimum.y + maximum.y) / 2.0;
            Point center = new Point(centerX, centerY);
            this.rot = new Rotator(center, this.angle);
            this.rotateGraphicElement(element);
        }
        return performRotation;
    }

    private void rotateGraphicElement(GraphicElement element) {
        element.rotate(this.rot);
        for (GraphicElement child : element.getChildren()) {
            this.rotateGraphicElement(child);
        }
    }

    public void adjustCoordinates(GraphicElement element) {
        Point minimum = this.coordMinMax.getMinimum();
        Point maximum = this.coordMinMax.getMaximum();
        this.offsetX = minimum.x;
        this.offsetY = minimum.y;
        this.adjustCoordinatesGraphicElement(element);
        minimum.x -= this.offsetX;
        minimum.y -= this.offsetY;
        maximum.x -= this.offsetX;
        maximum.y -= this.offsetY;
        this.coordMinMax.setMinimum(minimum);
        this.coordMinMax.setMaximum(maximum);
    }

    private void adjustCoordinatesGraphicElement(GraphicElement element) {
        element.translate(this.offsetX, this.offsetY);
        for (GraphicElement child : element.getChildren()) {
            this.adjustCoordinatesGraphicElement(child);
        }
    }
}

