/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.helper;

import de.berndbock.tinysvg.helper.Point;

public class Rotator {
    private final Point center;
    private final double sinAngle;
    private final double cosAngle;

    public Rotator(Point center, double angle) {
        this.center = center;
        angle = angle * Math.PI / 180.0;
        this.sinAngle = Math.sin(angle);
        this.cosAngle = Math.cos(angle);
    }

    public void rotate(Point p) {
        p.x -= this.center.x;
        p.y -= this.center.y;
        double x = this.cosAngle * p.x - this.sinAngle * p.y;
        double y = this.sinAngle * p.x + this.cosAngle * p.y;
        p.x = x + this.center.x;
        p.y = y + this.center.y;
    }
}

