/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.helper;

import de.berndbock.tinysvg.graphelem.Circle;
import de.berndbock.tinysvg.graphelem.Ellipse;
import de.berndbock.tinysvg.graphelem.GraphicElement;
import de.berndbock.tinysvg.graphelem.Line;
import de.berndbock.tinysvg.helper.Point;
import java.util.ArrayList;
import java.util.List;

public class LineSegmentCreator {
    public List<Line> buildLines(Circle c, GraphicElement parent) {
        ArrayList<Line> lines = new ArrayList<Line>();
        double wEnd = 6.283185317179586;
        double wDelta = 0.08726646259971647;
        Point pOld = null;
        for (double w = 0.0; w < wEnd; w += wDelta) {
            Point p = new Point();
            p.x = c.getCx() + c.getR() * Math.cos(w);
            p.y = c.getCy() + c.getR() * Math.sin(w);
            if (pOld != null) {
                Line l = new Line(null, parent, pOld.x, pOld.y, p.x, p.y);
                lines.add(l);
            }
            pOld = p;
        }
        return lines;
    }

    public List<Line> buildLines(Ellipse e, GraphicElement parent) {
        ArrayList<Line> lines = new ArrayList<Line>();
        double wEnd = 6.283185317179586;
        double wDelta = 0.08726646259971647;
        Point pOld = null;
        for (double w = 0.0; w < wEnd; w += wDelta) {
            Point p = new Point();
            p.x = e.getCx() + e.getRx() * Math.cos(w);
            p.y = e.getCy() + e.getRy() * Math.sin(w);
            if (pOld != null) {
                Line l = new Line(null, parent, pOld.x, pOld.y, p.x, p.y);
                lines.add(l);
            }
            pOld = p;
        }
        return lines;
    }
}

