/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.helper;

import de.berndbock.tinysvg.graphelem.GraphicElement;
import de.berndbock.tinysvg.graphelem.Use;
import java.util.HashMap;
import java.util.Map;

public class DefsUseResolver {
    private final Map<String, GraphicElement> definitions = new HashMap<String, GraphicElement>();
    private final Map<String, GraphicElement> symbols = new HashMap<String, GraphicElement>();
    private boolean defsFound = false;
    private boolean symbolsFound = false;

    public GraphicElement resolve(GraphicElement root) {
        GraphicElement root2 = root;
        this.defsFound = false;
        this.symbolsFound = false;
        this.collectDefs(root);
        this.collectSymbols(root);
        if (this.defsFound || this.symbolsFound) {
            root2 = root.getCopy(root.getParent());
            for (GraphicElement child : root.getChildren()) {
                this.resolveUse(child, root2);
            }
        }
        return root2;
    }

    private void collectDefs(GraphicElement element) {
        if (element.getType() == 10) {
            this.defsFound = true;
            for (GraphicElement child : element.getChildren()) {
                this.definitions.put(child.getId(), child);
            }
        } else {
            for (GraphicElement child : element.getChildren()) {
                this.collectDefs(child);
            }
        }
    }

    private void collectSymbols(GraphicElement element) {
        if (element.getType() == 12) {
            this.symbolsFound = true;
            for (GraphicElement child : element.getChildren()) {
                this.symbols.put(child.getId(), child);
            }
        } else {
            for (GraphicElement child : element.getChildren()) {
                this.collectSymbols(child);
            }
        }
    }

    private void resolveUse(GraphicElement source, GraphicElement target) {
        switch (source.getType()) {
            case 11: {
                Use use = (Use)source;
                GraphicElement replacementNode = this.definitions.get(use.getHrefShort());
                if (replacementNode == null) {
                    replacementNode = this.symbols.get(use.getHrefShort());
                }
                if (replacementNode == null) break;
                GraphicElement replacementCopy = replacementNode.getCopy(target.getParent());
                replacementCopy.setTransformation(use.getTransformation());
                this.deepCopy(replacementNode, replacementCopy);
                target.appendChild(replacementCopy);
                break;
            }
            case 12: {
                break;
            }
            case 10: {
                break;
            }
            default: {
                GraphicElement copy = source.getCopy(target);
                target.appendChild(copy);
                for (GraphicElement child : source.getChildren()) {
                    this.resolveUse(child, copy);
                }
            }
        }
    }

    private void deepCopy(GraphicElement source, GraphicElement target) {
        for (GraphicElement child : source.getChildren()) {
            GraphicElement childCopy = child.getCopy(target);
            target.appendChild(childCopy);
            this.deepCopy(child, childCopy);
        }
    }
}

