/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.helper;

import de.berndbock.tinysvg.helper.Point;

public class ArcSegmenter {
    private static final double PI2 = Math.PI * 2;
    private static final double ACC_ZERO_ANG = 1.7453292519943295E-8;
    private final double x0;
    private final double y0;
    private final double x1;
    private final double y1;
    private final double a;
    private final double b;
    private final double alfa;
    private final boolean sweep;
    private final boolean larc;
    private double sx;
    private double sy;
    private double a0;
    private double a1;
    private double da;
    private double ang;

    public ArcSegmenter(double x0, double y0, double x1, double y1, double a, double b, double alfa, int sweep, int larc) {
        this.x0 = x0;
        this.y0 = y0;
        this.x1 = x1;
        this.y1 = y1;
        this.a = a;
        this.b = b;
        this.alfa = alfa;
        this.sweep = sweep != 0;
        this.larc = larc != 0;
        this.compute();
    }

    private void compute() {
        this.ang = Math.PI - this.alfa;
        boolean _sweep = this.sweep;
        if (this.larc) {
            _sweep = !_sweep;
        }
        double e = this.a / this.b;
        double c = Math.cos(this.ang);
        double s = Math.sin(this.ang);
        double ax = this.x0 * c - this.y0 * s;
        double ay = this.x0 * s + this.y0 * c;
        double bx = this.x1 * c - this.y1 * s;
        double by = this.x1 * s + this.y1 * c;
        this.sx = 0.5 * (ax + bx);
        this.sy = 0.5 * ((ay *= e) + (by *= e));
        double vx = ay - by;
        double vy = bx - ax;
        double l = this.a * this.a / (vx * vx + vy * vy) - 0.25;
        if (l < 0.0) {
            l = 0.0;
        }
        l = Math.sqrt(l);
        vx *= l;
        vy *= l;
        if (_sweep) {
            this.sx += vx;
            this.sy += vy;
        } else {
            this.sx -= vx;
            this.sy -= vy;
        }
        this.a0 = Math.atan2(ay - this.sy, ax - this.sx);
        this.a1 = Math.atan2(by - this.sy, bx - this.sx);
        this.sy /= e;
        this.da = this.a1 - this.a0;
        if (Math.abs(Math.abs(this.da) - Math.PI) <= 1.7453292519943295E-8) {
            double db;
            for (db = 0.5 * (this.a0 + this.a1) - Math.atan2(by - ay, bx - ax); db < -Math.PI; db += Math.PI * 2) {
            }
            while (db > Math.PI) {
                db -= Math.PI * 2;
            }
            _sweep = false;
            if (db < 0.0 && !this.sweep) {
                _sweep = true;
            }
            if (db > 0.0 && this.sweep) {
                _sweep = true;
            }
            if (_sweep) {
                if (this.da >= 0.0) {
                    this.a1 -= Math.PI * 2;
                }
                if (this.da < 0.0) {
                    this.a0 -= Math.PI * 2;
                }
            }
        } else if (this.larc) {
            if (this.da < Math.PI && this.da >= 0.0) {
                this.a1 -= Math.PI * 2;
            }
            if (this.da > -Math.PI && this.da < 0.0) {
                this.a0 -= Math.PI * 2;
            }
        } else {
            if (this.da > Math.PI) {
                this.a1 -= Math.PI * 2;
            }
            if (this.da < -Math.PI) {
                this.a0 -= Math.PI * 2;
            }
        }
        this.da = this.a1 - this.a0;
    }

    public Point getpnt(double t) {
        Point result = new Point();
        t = this.a0 + this.da * t;
        double x = this.sx + this.a * Math.cos(t);
        double y = this.sy + this.b * Math.sin(t);
        double c = Math.cos(-this.ang);
        double s = Math.sin(-this.ang);
        result.x = x * c - y * s;
        result.y = x * s + y * c;
        return result;
    }
}

