/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.graphelem.parser;

import de.berndbock.tinysvg.graphelem.Transformation;
import de.berndbock.tinysvg.graphelem.parser.TransformCommand;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransformParser {
    private static final Logger LOGGER = Logger.getLogger("global");

    public Transformation parse(String transform) {
        String[] tokens;
        ArrayList<TransformCommand> commands = new ArrayList<TransformCommand>();
        TransformCommand command = null;
        boolean unknown = false;
        block20: for (String token : tokens = transform.split("\\s|,|\\(|\\)")) {
            String tok = token.trim();
            if (tok.isEmpty()) continue;
            switch (tok) {
                case "translate": {
                    command = new TransformCommand(TransformCommand.COMMAND.TRANSLATE);
                    commands.add(command);
                    continue block20;
                }
                case "rotate": {
                    command = new TransformCommand(TransformCommand.COMMAND.ROTATE);
                    commands.add(command);
                    continue block20;
                }
                case "scale": {
                    command = new TransformCommand(TransformCommand.COMMAND.SCALE);
                    commands.add(command);
                    continue block20;
                }
                case "skewX": {
                    command = new TransformCommand(TransformCommand.COMMAND.SKEW_X);
                    commands.add(command);
                    continue block20;
                }
                case "skewY": {
                    command = new TransformCommand(TransformCommand.COMMAND.SKEW_X);
                    commands.add(command);
                    continue block20;
                }
                case "matrix": {
                    command = new TransformCommand(TransformCommand.COMMAND.MATRIX);
                    commands.add(command);
                    continue block20;
                }
                default: {
                    if (command == null) {
                        unknown = true;
                    } else {
                        try {
                            double parameter = Double.parseDouble(tok);
                            try {
                                command.addParameter(parameter);
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.WARNING, ex.getMessage() + ": {0}", tok);
                            }
                        }
                        catch (NumberFormatException e) {
                            unknown = true;
                        }
                    }
                    if (!unknown) continue block20;
                    LOGGER.log(Level.SEVERE, "unknown transform command: {0}", tok);
                }
            }
        }
        Transformation trans = new Transformation();
        for (int i = commands.size() - 1; i >= 0; --i) {
            command = (TransformCommand)commands.get(i);
            trans.addCommand(command);
        }
        return trans;
    }
}

