/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.graphelem.parser;

import de.berndbock.tinysvg.util.Util;
import java.util.Arrays;

public class TransformCommand {
    private COMMAND command;
    private final double[] parameters;
    private final int maxParams;
    private int paramCount;

    public TransformCommand(COMMAND command) {
        this.command = command;
        switch (command) {
            case TRANSLATE: 
            case SCALE: {
                this.maxParams = 2;
                break;
            }
            case ROTATE: {
                this.maxParams = 3;
                break;
            }
            case SKEW_X: 
            case SKEW_Y: {
                this.maxParams = 1;
                break;
            }
            default: {
                this.maxParams = 6;
            }
        }
        this.parameters = new double[this.maxParams];
        this.paramCount = 0;
    }

    public TransformCommand(TransformCommand tc) {
        this.command = tc.command;
        this.parameters = Arrays.copyOf(tc.parameters, tc.parameters.length);
        this.maxParams = tc.maxParams;
        this.paramCount = tc.paramCount;
    }

    public void addParameter(double param) throws Exception {
        if (this.paramCount >= this.maxParams) {
            throw new Exception("too many parameters for transform command " + (Object)((Object)this.command));
        }
        this.parameters[this.paramCount++] = param;
    }

    public COMMAND getCommand() {
        return this.command;
    }

    public double getParameter(int index) {
        return this.parameters[index];
    }

    public int getParameterCount() {
        return this.paramCount;
    }

    public double getA() {
        return this.parameters[0];
    }

    public double getB() {
        return this.parameters[1];
    }

    public double getC() {
        return this.parameters[2];
    }

    public double getD() {
        return this.parameters[3];
    }

    public double getE() {
        return this.parameters[4];
    }

    public double getF() {
        return this.parameters[5];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.command).append('(');
        for (int i = 0; i < this.paramCount; ++i) {
            sb.append(Util.format(this.parameters[i], 2));
            if (i >= this.paramCount - 1) continue;
            sb.append(", ");
        }
        sb.append(')');
        return sb.toString();
    }

    public static enum COMMAND {
        TRANSLATE,
        ROTATE,
        SCALE,
        SKEW_X,
        SKEW_Y,
        MATRIX;

    }
}

