/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.graphelem.parser;

import de.berndbock.tinysvg.Config;
import de.berndbock.tinysvg.LineReducer;
import de.berndbock.tinysvg.PrimitiveCreator;
import de.berndbock.tinysvg.graphelem.Circle;
import de.berndbock.tinysvg.graphelem.Defs;
import de.berndbock.tinysvg.graphelem.Ellipse;
import de.berndbock.tinysvg.graphelem.GraphicElement;
import de.berndbock.tinysvg.graphelem.GraphicElements;
import de.berndbock.tinysvg.graphelem.Group;
import de.berndbock.tinysvg.graphelem.Line;
import de.berndbock.tinysvg.graphelem.Path;
import de.berndbock.tinysvg.graphelem.PolyLine;
import de.berndbock.tinysvg.graphelem.Polygon;
import de.berndbock.tinysvg.graphelem.Rect;
import de.berndbock.tinysvg.graphelem.Svg;
import de.berndbock.tinysvg.graphelem.Symbol;
import de.berndbock.tinysvg.graphelem.Transformation;
import de.berndbock.tinysvg.graphelem.Use;
import de.berndbock.tinysvg.graphelem.parser.TransformCommand;
import de.berndbock.tinysvg.graphelem.parser.TransformParser;
import de.berndbock.tinysvg.helper.CoordMinMax;
import de.berndbock.tinysvg.helper.DefsUseResolver;
import de.berndbock.tinysvg.helper.Point;
import de.berndbock.tinysvg.helper.TreeRotator;
import de.berndbock.tinysvg.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SvgParser {
    private static final Logger LOGGER = Logger.getLogger("global");
    private final Config config;
    private GraphicElement root;
    private double width;
    private double height;
    private final CoordMinMax coordMinMax;

    public SvgParser(Config config) {
        this.config = config;
        this.root = null;
        this.width = 0.0;
        this.height = 0.0;
        this.coordMinMax = new CoordMinMax();
    }

    public GraphicElement getRoot() {
        return this.root;
    }

    public CoordMinMax getCoordMinMax() {
        return this.coordMinMax;
    }

    public GraphicElements parse(File svgFile) throws Exception {
        TreeRotator rotator;
        Document document;
        LOGGER.log(Level.INFO, "parse: {0}", svgFile);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(svgFile);
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            LOGGER.severe(ex.getMessage());
            String msg = "Cannot parse the file " + svgFile.getName();
            Exception e = new Exception(msg);
            throw e;
        }
        Element documentElement = document.getDocumentElement();
        documentElement.normalize();
        LOGGER.log(Level.FINE, "document element: {0}", documentElement.getTagName());
        if (!"svg".equals(documentElement.getTagName())) {
            String msg = "The file " + svgFile.getName() + " is not an SVG file!";
            Exception e = new Exception(msg);
            throw e;
        }
        this.width = this.config.getResolutionX();
        this.height = this.config.getResolutionYAdjusted();
        LOGGER.log(Level.FINE, "width: {0}, height: {1}", new Object[]{this.width, this.height});
        this.root = null;
        this.parseNode(documentElement, this.root);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("After parseNode:");
            this.root.dump();
        }
        DefsUseResolver defsUseResolver = new DefsUseResolver();
        this.root = defsUseResolver.resolve(this.root);
        PrimitiveCreator primCreator = new PrimitiveCreator(this.config, this.root);
        primCreator.prepare();
        this.coordMinMax.reset();
        this.collectStatistics(this.root);
        Point minimum = this.coordMinMax.getMinimum();
        Point maximum = this.coordMinMax.getMaximum();
        double w = maximum.x - minimum.x;
        double h = maximum.y - minimum.y;
        double interimScaleFactor = this.computeScaleFactor(w, h);
        this.config.setInterimScaleFactor(interimScaleFactor);
        this.root = primCreator.toPrimitives();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(this.coordMinMax.toString());
            LOGGER.fine("After conversion to primitives:");
            this.root.dump();
        }
        this.transform(this.root);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("After transformation:");
            this.root.dump();
        }
        this.coordMinMax.reset();
        this.collectStatistics(this.root);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(this.coordMinMax.toString());
        }
        if ((rotator = new TreeRotator(this.config.getRotateClockwise(), this.coordMinMax)).rotateClockwise(this.root)) {
            this.coordMinMax.reset();
            this.collectStatistics(this.root);
            rotator.adjustCoordinates(this.root);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finest("Transformations before final:");
            this.root.dumpTransformations();
        }
        Transformation finalTrans = new Transformation();
        if (this.config.isCenter() || this.config.isResize()) {
            double yoffs;
            double xoffs;
            double scaleFactor;
            minimum = this.coordMinMax.getMinimum();
            maximum = this.coordMinMax.getMaximum();
            if (this.config.isResize()) {
                w = maximum.x - minimum.x;
                h = maximum.y - minimum.y;
                scaleFactor = this.computeScaleFactor(w, h);
                xoffs = minimum.x * scaleFactor;
                yoffs = minimum.y * scaleFactor;
                if (this.config.isCenter()) {
                    if (this.width / w < this.height / h) {
                        double h2 = h * scaleFactor;
                        yoffs -= (this.height - h2) / 2.0;
                    } else {
                        double w2 = w * scaleFactor;
                        xoffs -= (this.width - w2) / 2.0;
                    }
                } else {
                    xoffs -= this.config.getOffsetX();
                    yoffs -= this.config.getOffsetY();
                }
                this.addTranslate(finalTrans, -xoffs, -yoffs);
                this.addScale(finalTrans, scaleFactor);
            } else {
                scaleFactor = this.config.getScaleFactor();
                xoffs = (this.width - (maximum.x + minimum.x) * scaleFactor) / 2.0;
                yoffs = (this.height - (maximum.y + minimum.y) * scaleFactor) / 2.0;
                this.addTranslate(finalTrans, xoffs, yoffs);
                this.addScale(finalTrans, this.config.getScaleFactor());
            }
            LOGGER.log(Level.FINE, "finalTrans: {0}", finalTrans);
            this.root.setTransformationSubtree(null);
            this.root.setTransformation(finalTrans);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finest("Transformations after setTransformation:");
                this.root.dumpTransformations();
            }
            this.transform(this.root);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("After final transformation:");
                this.root.dump();
            }
        } else {
            this.addTranslate(finalTrans, this.config.getOffsetX(), this.config.getOffsetY());
            this.addScale(finalTrans, this.config.getScaleFactor());
            if (finalTrans.getCommandCount() > 0) {
                this.root.setTransformationSubtree(null);
                this.root.setTransformation(finalTrans);
                this.transform(this.root);
            }
        }
        GraphicElements result = new GraphicElements();
        this.treeToList(result, this.root);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("After treeToList:");
            for (int i = 0; i < result.size(); ++i) {
                GraphicElement element = result.get(i);
                LOGGER.log(Level.FINE, "  {0}", element);
            }
        }
        if (this.config.isLineReducerActivated() && this.config.isResize()) {
            LineReducer reducer = new LineReducer(this.config, result);
            result = reducer.reduce();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("After LineReducer:");
                for (int i = 0; i < result.size(); ++i) {
                    GraphicElement element = result.get(i);
                    element.dump();
                }
            }
        }
        return result;
    }

    private void addTranslate(Transformation trans, double xoffs, double yoffs) throws Exception {
        if (xoffs != 0.0 || yoffs != 0.0) {
            TransformCommand cmd = new TransformCommand(TransformCommand.COMMAND.TRANSLATE);
            cmd.addParameter(xoffs);
            cmd.addParameter(yoffs);
            trans.addCommand(cmd);
        }
    }

    private void addScale(Transformation trans, double scaleFactor) throws Exception {
        if (scaleFactor != 1.0) {
            TransformCommand cmd = new TransformCommand(TransformCommand.COMMAND.SCALE);
            cmd.addParameter(scaleFactor);
            cmd.addParameter(scaleFactor);
            trans.addCommand(cmd);
        }
    }

    private void parseNode(Node node, GraphicElement element) {
        if (node.getNodeType() == 1) {
            String nodeName = node.getNodeName();
            NamedNodeMap attributes = node.getAttributes();
            switch (nodeName) {
                case "svg": {
                    element = this.addSvg(attributes, element);
                    break;
                }
                case "rect": {
                    element = this.addRect(attributes, element);
                    break;
                }
                case "ellipse": {
                    element = this.addEllipse(attributes, element);
                    break;
                }
                case "path": {
                    element = this.addPath(attributes, element);
                    break;
                }
                case "circle": {
                    element = this.addCircle(attributes, element);
                    break;
                }
                case "line": {
                    element = this.addLine(attributes, element);
                    break;
                }
                case "polyline": {
                    element = this.addPolyline(attributes, element);
                    break;
                }
                case "polygon": {
                    element = this.addPolygon(attributes, element);
                    break;
                }
                case "g": {
                    element = this.addGroup(attributes, node, element);
                    break;
                }
                case "defs": {
                    element = this.addDefs(attributes, node, element);
                    break;
                }
                case "use": {
                    element = this.addUse(attributes, node, element);
                    break;
                }
                case "symbol": {
                    element = this.addSymbol(attributes, node, element);
                    break;
                }
                default: {
                    LOGGER.log(Level.INFO, "Unsupported node name: {0}", nodeName);
                }
            }
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (node.getNodeType() != 1) continue;
            Node n = list.item(i);
            this.parseNode(n, element);
        }
    }

    private String getStringValue(NamedNodeMap attributes, String attributeName) {
        Node n = attributes.getNamedItem(attributeName);
        return n == null ? "" : n.getTextContent();
    }

    private double getDoubleValue(NamedNodeMap attributes, String attributeName) {
        String value = this.getStringValue(attributes, attributeName);
        return Util.toDouble(value);
    }

    private String getId(NamedNodeMap attributes) {
        return this.getAttributeValue(attributes, "id");
    }

    private String getAttributeValue(NamedNodeMap attributes, String attributeName) {
        Node n = attributes.getNamedItem(attributeName);
        return n == null ? null : n.getTextContent();
    }

    private double computeScaleFactor(double w, double h) {
        double scaleFactor = Util.computeScaleFactor(this.width, this.height, w, h);
        LOGGER.log(Level.FINE, "scaleFactor: {0}", scaleFactor);
        return scaleFactor;
    }

    private Transformation getTransformation(NamedNodeMap attributes) {
        String transformAttr = this.getStringValue(attributes, "transform");
        Transformation t = !transformAttr.isEmpty() ? this.parseTransformAttribute(transformAttr) : null;
        return t;
    }

    private GraphicElement addSvg(NamedNodeMap attributes, GraphicElement element) {
        String id = this.getId(attributes);
        this.root = new Svg(id);
        this.root.setTransformation(new Transformation());
        return this.root;
    }

    private GraphicElement addRect(NamedNodeMap attributes, GraphicElement element) {
        Point p = new Point();
        p.x = this.getDoubleValue(attributes, "x");
        p.y = this.getDoubleValue(attributes, "y");
        double w = this.getDoubleValue(attributes, "width");
        double h = this.getDoubleValue(attributes, "height");
        String id = this.getId(attributes);
        Transformation t = this.getTransformation(attributes);
        Rect r = new Rect(id, element, p.x, p.y, w, h);
        r.setTransformation(t);
        element.appendChild(r);
        return r;
    }

    private GraphicElement addCircle(NamedNodeMap attributes, GraphicElement element) {
        Point p = new Point();
        p.x = this.getDoubleValue(attributes, "cx");
        p.y = this.getDoubleValue(attributes, "cy");
        double r = this.getDoubleValue(attributes, "r");
        String id = this.getId(attributes);
        Transformation t = this.getTransformation(attributes);
        Circle c = new Circle(id, element, p.x, p.y, r);
        c.setTransformation(t);
        element.appendChild(c);
        return c;
    }

    private GraphicElement addLine(NamedNodeMap attributes, GraphicElement element) {
        Point p1 = new Point();
        Point p2 = new Point();
        p1.x = this.getDoubleValue(attributes, "x1");
        p1.y = this.getDoubleValue(attributes, "y1");
        p2.x = this.getDoubleValue(attributes, "x2");
        p2.y = this.getDoubleValue(attributes, "y2");
        String id = this.getId(attributes);
        Transformation t = this.getTransformation(attributes);
        Line l = new Line(id, element, p1.x, p1.y, p2.x, p2.y);
        l.setTransformation(t);
        element.appendChild(l);
        return l;
    }

    private GraphicElement addPath(NamedNodeMap attributes, GraphicElement element) {
        String d = this.getStringValue(attributes, "d");
        String id = this.getId(attributes);
        Transformation t = this.getTransformation(attributes);
        Path p = new Path(id, element, d);
        p.setTransformation(t);
        element.appendChild(p);
        return p;
    }

    private GraphicElement addEllipse(NamedNodeMap attributes, GraphicElement element) {
        Point p = new Point();
        p.x = this.getDoubleValue(attributes, "cx");
        p.y = this.getDoubleValue(attributes, "cy");
        double rx = this.getDoubleValue(attributes, "rx");
        double ry = this.getDoubleValue(attributes, "ry");
        String id = this.getId(attributes);
        Transformation t = this.getTransformation(attributes);
        Ellipse e = new Ellipse(id, element, p.x, p.y, rx, ry);
        e.setTransformation(t);
        element.appendChild(e);
        return e;
    }

    private GraphicElement addPolyline(NamedNodeMap attributes, GraphicElement element) {
        String points = this.getStringValue(attributes, "points");
        String id = this.getId(attributes);
        Transformation t = this.getTransformation(attributes);
        PolyLine p = new PolyLine(id, element, points);
        p.setTransformation(t);
        element.appendChild(p);
        return p;
    }

    private GraphicElement addPolygon(NamedNodeMap attributes, GraphicElement element) {
        String points = this.getStringValue(attributes, "points");
        String id = this.getId(attributes);
        Transformation t = this.getTransformation(attributes);
        Polygon p = new Polygon(id, element, points);
        p.setTransformation(t);
        element.appendChild(p);
        return p;
    }

    private GraphicElement addGroup(NamedNodeMap attributes, Node node, GraphicElement element) {
        Transformation t = this.getTransformation(attributes);
        String id = this.getId(attributes);
        Group g = new Group(id, element);
        g.setTransformation(t);
        element.appendChild(g);
        return g;
    }

    private GraphicElement addDefs(NamedNodeMap attributes, Node node, GraphicElement element) {
        Transformation t = this.getTransformation(attributes);
        String id = this.getId(attributes);
        Defs d = new Defs(id, element);
        d.setTransformation(t);
        element.appendChild(d);
        return d;
    }

    private GraphicElement addUse(NamedNodeMap attributes, Node node, GraphicElement element) {
        Transformation t = this.getTransformation(attributes);
        String id = this.getId(attributes);
        String href = this.getAttributeValue(attributes, "href");
        Use u = new Use(id, href, element);
        u.setTransformation(t);
        element.appendChild(u);
        return u;
    }

    private GraphicElement addSymbol(NamedNodeMap attributes, Node node, GraphicElement element) {
        Transformation t = this.getTransformation(attributes);
        String id = this.getId(attributes);
        Symbol s = new Symbol(id, element);
        s.setTransformation(t);
        element.appendChild(s);
        return s;
    }

    private Transformation parseTransformAttribute(String transform) {
        TransformParser parser = new TransformParser();
        return parser.parse(transform);
    }

    private void transform(GraphicElement element) {
        element.transform();
        for (GraphicElement child : element.getChildren()) {
            this.transform(child);
        }
    }

    private void treeToList(GraphicElements list, GraphicElement element) {
        list.add(element);
        for (GraphicElement child : element.getChildren()) {
            this.treeToList(list, child);
        }
    }

    private void collectStatistics(GraphicElement element) {
        element.collectStatistics(this.coordMinMax);
        for (GraphicElement child : element.getChildren()) {
            this.collectStatistics(child);
        }
    }
}

