/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.graphelem.parser;

import de.berndbock.tinysvg.graphelem.GraphicElement;
import de.berndbock.tinysvg.graphelem.GraphicElements;
import de.berndbock.tinysvg.graphelem.Line;
import de.berndbock.tinysvg.graphelem.PolyLine;
import de.berndbock.tinysvg.helper.Point;
import de.berndbock.tinysvg.util.Util;

public class PointsParser {
    private final PolyLine polyLine;

    public PointsParser(PolyLine polyLine) {
        this.polyLine = polyLine;
    }

    public GraphicElements convertToPrimitives() {
        GraphicElements elements = null;
        String points = this.polyLine.getPoints();
        if (points != null) {
            elements = new GraphicElements();
            String[] coordArray = points.split("\\s|,");
            Point p1 = null;
            GraphicElement parent = this.polyLine.getParent();
            int i = 0;
            while (i < coordArray.length) {
                if (coordArray[i].isEmpty()) {
                    ++i;
                    continue;
                }
                if (p1 == null) {
                    p1 = new Point();
                    p1.x = Util.toInt(coordArray[i++]);
                    p1.y = Util.toInt(coordArray[i++]);
                    continue;
                }
                Point p2 = new Point();
                p2.x = Util.toInt(coordArray[i++]);
                p2.y = Util.toInt(coordArray[i++]);
                Line l = new Line(null, parent, p1.x, p1.y, p2.x, p2.y);
                elements.add(l);
                p1 = p2;
            }
            elements.setTransformation(this.polyLine.getTransformation());
        }
        return elements;
    }

    public void parsePoints() {
        String points = this.polyLine.getPoints();
        if (points != null) {
            String[] coordArray = points.split("\\s|,");
            int i = 0;
            while (i < coordArray.length) {
                if (coordArray[i].isEmpty()) {
                    ++i;
                    continue;
                }
                Point p = new Point();
                p.x = Util.toInt(coordArray[i++]);
                p.y = Util.toInt(coordArray[i++]);
                this.polyLine.addPoint(p);
            }
        }
    }
}

