/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.graphelem.parser;

import de.berndbock.tinysvg.Config;
import de.berndbock.tinysvg.graphelem.GraphicElement;
import de.berndbock.tinysvg.graphelem.GraphicElements;
import de.berndbock.tinysvg.graphelem.Line;
import de.berndbock.tinysvg.graphelem.Path;
import de.berndbock.tinysvg.graphelem.PathCommand;
import de.berndbock.tinysvg.helper.ArcSegmenter;
import de.berndbock.tinysvg.helper.Point;
import de.berndbock.tinysvg.util.Util;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PathParser {
    private static final Logger LOGGER = Logger.getLogger("global");
    private static final String COMMANDS = "MLHVZACSQTRB";
    private final Path path;
    private Config config;
    private Point startPoint = null;
    private Point prevControlPoint = null;

    public PathParser(Path path) {
        this.path = path;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void parseD() throws Exception {
        PathCommand faultyPathCommand;
        LOGGER.fine("parseD START");
        int prevCh = 32;
        boolean dotFound = false;
        StringBuilder buf = null;
        PathCommand pcmd = null;
        String d = this.path.getD();
        for (int i = 0; i < d.length(); ++i) {
            char ch = d.charAt(i);
            if (this.isCommand(ch)) {
                if (buf != null) {
                    pcmd.addParameter(buf.toString());
                    buf = null;
                }
                pcmd = new PathCommand(ch);
                this.path.addPathCommand(pcmd);
                dotFound = false;
            } else if (this.isCoordChar(ch)) {
                if (ch == '-' && prevCh != 101 && prevCh != 69) {
                    if (buf != null) {
                        pcmd.addParameter(buf.toString());
                        buf = null;
                    }
                    dotFound = false;
                } else if (ch == '.') {
                    if (dotFound) {
                        if (prevCh != 45 && buf != null) {
                            pcmd.addParameter(buf.toString());
                            buf = null;
                        }
                    } else {
                        dotFound = true;
                    }
                }
                if (buf == null) {
                    buf = new StringBuilder();
                }
                buf.append(ch);
            } else {
                if (buf != null) {
                    pcmd.addParameter(buf.toString());
                    buf = null;
                }
                dotFound = false;
            }
            prevCh = ch;
        }
        if (pcmd != null && buf != null) {
            pcmd.addParameter(buf.toString());
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            for (PathCommand pathCommand : this.path.getCommandList()) {
                LOGGER.finer(pathCommand.toString());
            }
        }
        if ((faultyPathCommand = this.checkPathCommands()) != null) {
            throw new Exception("invalid path command: " + faultyPathCommand);
        }
        this.extractPointsFromPathCommands();
        LOGGER.fine("parseD END");
    }

    private PathCommand checkPathCommands() {
        LOGGER.fine("checkPathCommands START");
        PathCommand result = null;
        for (PathCommand pcmd : this.path.getCommandList()) {
            char command = Character.toUpperCase(pcmd.getCommand());
            switch (command) {
                case 'L': 
                case 'M': {
                    if (pcmd.parameterCount() >= 2 && pcmd.parameterCount() % 2 == 0) break;
                    result = pcmd;
                    break;
                }
                case 'H': 
                case 'V': {
                    if (pcmd.parameterCount() >= 1) break;
                    result = pcmd;
                    break;
                }
                case 'Z': {
                    if (pcmd.parameterCount() == 0) break;
                    result = pcmd;
                    break;
                }
                case 'A': {
                    if (pcmd.parameterCount() >= 7) break;
                    result = pcmd;
                    break;
                }
                case 'C': {
                    if (pcmd.parameterCount() % 6 == 0) break;
                    result = pcmd;
                    break;
                }
                case 'S': {
                    if (pcmd.parameterCount() % 4 == 0) break;
                    result = pcmd;
                    break;
                }
                case 'Q': {
                    if (pcmd.parameterCount() == 4) break;
                    result = pcmd;
                    break;
                }
                case 'T': {
                    if (pcmd.parameterCount() == 2) break;
                    result = pcmd;
                    break;
                }
                case 'R': {
                    if (pcmd.parameterCount() >= 6 && pcmd.parameterCount() % 2 == 0) break;
                    result = pcmd;
                    break;
                }
                case 'B': {
                    if (pcmd.parameterCount() == 1) break;
                    result = pcmd;
                    break;
                }
                default: {
                    result = pcmd;
                }
            }
            if (result == null) continue;
            break;
        }
        LOGGER.fine("checkPathCommands END");
        return result;
    }

    public GraphicElements convertToPrimitives() {
        LOGGER.log(Level.FINE, "convertToPrimitives START path id: {0}", this.path.getId());
        if (this.path.getCommandList() == null) {
            return null;
        }
        GraphicElements result = new GraphicElements();
        Point currentPoint = new Point(0.0, 0.0);
        PathCommand prevPcmd = null;
        int commandCount = 0;
        for (PathCommand pcmd : this.path.getCommandList()) {
            ++commandCount;
            pcmd.resetParamIdx();
            pcmd.resetPointIdx();
            try {
                switch (pcmd.getCommandUpperCase()) {
                    case 'M': {
                        Point p;
                        currentPoint = p = pcmd.getNextPointFromParameterAbsolute(currentPoint);
                        this.startPoint = new Point(currentPoint);
                        if (pcmd.pointCount() > 1) {
                            currentPoint = this.createLineSegments(pcmd, currentPoint, result, this.path.getParent(), 0);
                        }
                        break;
                    }
                    case 'L': {
                        currentPoint = this.createLineSegments(pcmd, currentPoint, result, this.path.getParent(), 0);
                        break;
                    }
                    case 'H': {
                        Line l;
                        int i;
                        double x;
                        if (pcmd.isRelative()) {
                            x = 0.0;
                            for (i = 0; i < pcmd.parameterCount(); ++i) {
                                x += pcmd.getParameter(i).doubleValue();
                            }
                            l = new Line(null, this.path.getParent(), currentPoint.x, currentPoint.y, currentPoint.x + x, currentPoint.y);
                            currentPoint.x += x;
                        } else {
                            x = pcmd.getLastParameter();
                            l = new Line(null, this.path.getParent(), currentPoint.x, currentPoint.y, x, currentPoint.y);
                            currentPoint.x = x;
                        }
                        result.add(l);
                        break;
                    }
                    case 'V': {
                        Line l;
                        double y;
                        int i;
                        if (pcmd.isRelative()) {
                            y = 0.0;
                            for (i = 0; i < pcmd.parameterCount(); ++i) {
                                y += pcmd.getParameter(i).doubleValue();
                            }
                            l = new Line(null, this.path.getParent(), currentPoint.x, currentPoint.y, currentPoint.x, currentPoint.y + y);
                            currentPoint.y += y;
                        } else {
                            y = pcmd.getLastParameter();
                            l = new Line(null, this.path.getParent(), currentPoint.x, currentPoint.y, currentPoint.x, y);
                            currentPoint.y = y;
                        }
                        result.add(l);
                        break;
                    }
                    case 'Z': {
                        Line l = new Line(null, this.path.getParent(), currentPoint.x, currentPoint.y, this.startPoint.x, this.startPoint.y);
                        result.add(l);
                        currentPoint = this.startPoint;
                        this.startPoint = null;
                        break;
                    }
                    case 'C': {
                        if (this.config.useBezierCurveApproximation()) {
                            currentPoint = this.createLineSegmentsCubicBezier(pcmd, prevPcmd, currentPoint, result, this.path.getParent());
                            break;
                        }
                        currentPoint = this.createLineSegments(pcmd, currentPoint, result, this.path.getParent(), 4);
                        break;
                    }
                    case 'S': {
                        if (this.config.useBezierCurveApproximation()) {
                            currentPoint = this.createLineSegmentsCubicBezierShortcut(pcmd, prevPcmd, currentPoint, result, this.path.getParent());
                            break;
                        }
                        currentPoint = this.createLineSegments(pcmd, currentPoint, result, this.path.getParent(), 2);
                        break;
                    }
                    case 'A': {
                        if (this.config.useArcApproximation()) {
                            currentPoint = this.createLineSegmentsArc(pcmd, currentPoint, result, this.path.getParent());
                            break;
                        }
                        currentPoint = this.createLineSegments(pcmd, currentPoint, result, this.path.getParent(), 5);
                        break;
                    }
                    case 'Q': {
                        if (this.config.useBezierCurveApproximation()) {
                            currentPoint = this.createLineSegmentsQuadraticBezier(pcmd, prevPcmd, currentPoint, result, this.path.getParent());
                            break;
                        }
                        currentPoint = this.createLineSegments(pcmd, currentPoint, result, this.path.getParent(), 2);
                        break;
                    }
                    case 'T': {
                        if (this.config.useBezierCurveApproximation()) {
                            currentPoint = this.createLineSegmentsQuadraticBezier(pcmd, prevPcmd, currentPoint, result, this.path.getParent());
                            break;
                        }
                        currentPoint = this.createLineSegments(pcmd, currentPoint, result, this.path.getParent(), 0);
                        break;
                    }
                    case 'R': {
                        double x = pcmd.getPenultimateParameter();
                        double y = pcmd.getLastParameter();
                        Line l = new Line(null, this.path.getParent(), currentPoint.x, currentPoint.y, x, y);
                        result.add(l);
                        currentPoint.x = x;
                        currentPoint.y = y;
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "{0} at pcmd {1} #{2}: {3}", new Object[]{e.getClass().getName(), Character.valueOf(pcmd.getCommand()), commandCount, e.getMessage()});
            }
            prevPcmd = pcmd;
        }
        result.setTransformation(this.path.getTransformation());
        LOGGER.fine("convertToPrimitives END");
        return result;
    }

    private void extractPointsFromPathCommands() {
        LOGGER.log(Level.FINE, "extractPointsFromPathCommands START");
        if (this.path.getCommandList() == null) {
            return;
        }
        Point currentPoint = new Point(0.0, 0.0);
        int commandCount = 0;
        block15: for (PathCommand pcmd : this.path.getCommandList()) {
            ++commandCount;
            pcmd.resetParamIdx();
            pcmd.resetPointIdx();
            try {
                switch (pcmd.getCommandUpperCase()) {
                    case 'M': {
                        Point p = pcmd.getNextPointFromParameterAbsolute(currentPoint);
                        currentPoint = new Point(p);
                        this.startPoint = new Point(currentPoint);
                        pcmd.addPoint(p);
                        if (pcmd.parameterCount() <= 2) continue block15;
                        currentPoint = this.addPoints(pcmd, currentPoint, 0);
                        break;
                    }
                    case 'L': {
                        currentPoint = this.addPoints(pcmd, currentPoint, 0);
                        break;
                    }
                    case 'H': {
                        double x = pcmd.getParameter(0);
                        currentPoint.x = pcmd.isRelative() ? (currentPoint.x += x) : x;
                        Point p = new Point(currentPoint);
                        pcmd.addPoint(p);
                        break;
                    }
                    case 'V': {
                        double y = pcmd.getParameter(0);
                        currentPoint.y = pcmd.isRelative() ? (currentPoint.y += y) : y;
                        Point p = new Point(currentPoint);
                        pcmd.addPoint(p);
                        break;
                    }
                    case 'Z': {
                        currentPoint = this.startPoint;
                        this.startPoint = null;
                        Point p = new Point(currentPoint);
                        pcmd.addPoint(p);
                        break;
                    }
                    case 'C': {
                        currentPoint = this.addPoints(pcmd, currentPoint, 4);
                        break;
                    }
                    case 'S': {
                        currentPoint = this.addPoints(pcmd, currentPoint, 2);
                        break;
                    }
                    case 'A': {
                        currentPoint = this.addPoints(pcmd, currentPoint, 5);
                        break;
                    }
                    case 'Q': {
                        currentPoint = this.addPoints(pcmd, currentPoint, 2);
                        break;
                    }
                    case 'T': {
                        currentPoint = this.addPoints(pcmd, currentPoint, 0);
                        break;
                    }
                    case 'R': {
                        double x = pcmd.getPenultimateParameter();
                        double y = pcmd.getLastParameter();
                        if (pcmd.isRelative()) {
                            currentPoint.x += x;
                            currentPoint.y += y;
                        } else {
                            currentPoint.x = x;
                            currentPoint.y = y;
                        }
                        Point p = new Point(currentPoint);
                        pcmd.addPoint(p);
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "{0} at pcmd {1} #{2}: {3}", new Object[]{e.getClass().getName(), Character.valueOf(pcmd.getCommand()), commandCount, e.getMessage()});
            }
        }
        LOGGER.fine("extractPointsFromPathCommands END");
    }

    private Point addPoints(PathCommand pcmd, Point currentPoint, int skipParameters) {
        pcmd.skipParameters(skipParameters);
        Point lastP = null;
        Point p = pcmd.getNextPointFromParameterAbsolute(currentPoint);
        while (p != null) {
            pcmd.addPoint(p);
            lastP = p;
            pcmd.skipParameters(skipParameters);
            p = pcmd.getNextPointFromParameterAbsolute(currentPoint);
        }
        if (lastP != null) {
            currentPoint.set(lastP);
        }
        return currentPoint;
    }

    private Point createLineSegments(PathCommand pcmd, Point currentPoint, GraphicElements elements, GraphicElement parent, int skipParameters) {
        pcmd.skipParameters(skipParameters);
        Point p = pcmd.getNextPointFromParameterAbsolute(currentPoint);
        while (p != null) {
            Line l = new Line(null, parent, currentPoint.x, currentPoint.y, p.x, p.y);
            elements.add(l);
            currentPoint = p;
            pcmd.skipParameters(skipParameters);
            p = pcmd.getNextPointFromParameterAbsolute(currentPoint);
        }
        return currentPoint;
    }

    private Point createLineSegmentsCubicBezier(PathCommand pcmd, PathCommand prevPcmd, Point currentPoint, GraphicElements elements, GraphicElement parent) {
        Point firstPoint;
        Point[] bezier = new Point[4];
        bezier[0] = currentPoint;
        Point lastPoint = currentPoint;
        int idx = 1;
        if (pcmd.getCommandUpperCase() == 'S') {
            switch (prevPcmd.getCommand()) {
                case 'C': {
                    Point controlPoint2 = new Point(prevPcmd.getParameter(2), prevPcmd.getParameter(3));
                    firstPoint = controlPoint2.mirror(currentPoint);
                    break;
                }
                case 'c': {
                    Point controlPoint2 = new Point(currentPoint.x + prevPcmd.getParameter(2), currentPoint.y + prevPcmd.getParameter(3));
                    firstPoint = controlPoint2.mirror(currentPoint);
                    break;
                }
                case 'S': {
                    Point controlPoint2 = new Point(prevPcmd.getParameter(0), prevPcmd.getParameter(1));
                    firstPoint = controlPoint2.mirror(currentPoint);
                    break;
                }
                case 's': {
                    Point controlPoint2 = new Point(currentPoint.x + prevPcmd.getParameter(0), currentPoint.y + prevPcmd.getParameter(1));
                    firstPoint = controlPoint2.mirror(currentPoint);
                    break;
                }
                default: {
                    firstPoint = new Point(currentPoint);
                }
            }
            if (pcmd.isRelative()) {
                firstPoint.x -= currentPoint.x;
                firstPoint.y -= currentPoint.y;
            }
        } else {
            firstPoint = pcmd.getNextPointFromParameter();
        }
        Point p = firstPoint;
        while (p != null) {
            if (pcmd.isRelative()) {
                p.x += currentPoint.x;
                p.y += currentPoint.y;
            }
            bezier[idx++] = p;
            if (idx > 3) {
                int segmentCount = this.getBezierSegmentCount(currentPoint, p);
                this.bezierLineSegments(segmentCount, bezier, currentPoint, elements, parent);
                currentPoint = p;
                bezier[0] = p;
                idx = 1;
            }
            lastPoint = p;
            p = pcmd.getNextPointFromParameter();
        }
        return lastPoint;
    }

    private Point createLineSegmentsCubicBezierShortcut(PathCommand pcmd, PathCommand prevPcmd, Point currentPoint, GraphicElements elements, GraphicElement parent) {
        Point[] bezier = new Point[4];
        Point prevControlPoint2 = new Point(currentPoint);
        Point lastPoint = currentPoint;
        bezier[0] = currentPoint;
        bezier[1] = this.getFirstPointBezier(pcmd, prevPcmd, currentPoint);
        int idx = 2;
        Point p = pcmd.getNextPointFromParameter();
        while (p != null) {
            if (pcmd.isRelative()) {
                p.x += currentPoint.x;
                p.y += currentPoint.y;
            }
            if (idx == 2) {
                prevControlPoint2 = p;
            }
            bezier[idx++] = p;
            if (idx > 3) {
                int segmentCount = this.getBezierSegmentCount(currentPoint, p);
                this.bezierLineSegments(segmentCount, bezier, currentPoint, elements, parent);
                currentPoint = p;
                bezier[0] = p;
                bezier[1] = prevControlPoint2.mirror(p);
                idx = 2;
            }
            lastPoint = p;
            p = pcmd.getNextPointFromParameter();
        }
        return lastPoint;
    }

    private Point getFirstPointBezier(PathCommand pcmd, PathCommand prevPcmd, Point currentPoint) {
        Point firstPoint;
        switch (prevPcmd.getCommand()) {
            case 'C': {
                Point controlPoint2 = new Point(prevPcmd.getParameter(2), prevPcmd.getParameter(3));
                firstPoint = controlPoint2.mirror(currentPoint);
                break;
            }
            case 'c': {
                Point controlPoint2 = new Point(currentPoint.x + prevPcmd.getParameter(2), currentPoint.y + prevPcmd.getParameter(3));
                firstPoint = controlPoint2.mirror(currentPoint);
                break;
            }
            case 'S': {
                Point controlPoint2 = new Point(prevPcmd.getParameter(0), prevPcmd.getParameter(1));
                firstPoint = controlPoint2.mirror(currentPoint);
                break;
            }
            case 's': {
                Point controlPoint2 = new Point(currentPoint.x + prevPcmd.getParameter(0), currentPoint.y + prevPcmd.getParameter(1));
                firstPoint = controlPoint2.mirror(currentPoint);
                break;
            }
            default: {
                firstPoint = new Point(currentPoint);
            }
        }
        return firstPoint;
    }

    private void bezierLineSegments(int numberOfSegments, Point[] b, Point currentPoint, GraphicElements elements, GraphicElement parent) {
        Point startPoint;
        double increment;
        Point[] hpoint = new Point[6];
        for (int i = 0; i < 6; ++i) {
            hpoint[i] = new Point();
        }
        Point lastPoint = new Point(currentPoint);
        for (double d = increment = (double)(1.0f / (float)numberOfSegments); d < 1.0; d += increment) {
            int i;
            for (i = 0; i < 3; ++i) {
                hpoint[i + 3].x = (1.0 - d) * b[i].x + d * b[i + 1].x;
                hpoint[i + 3].y = (1.0 - d) * b[i].y + d * b[i + 1].y;
            }
            for (i = 0; i < 2; ++i) {
                hpoint[i + 1].x = (1.0 - d) * hpoint[i + 3].x + d * hpoint[i + 4].x;
                hpoint[i + 1].y = (1.0 - d) * hpoint[i + 3].y + d * hpoint[i + 4].y;
            }
            hpoint[0].x = (1.0 - d) * hpoint[1].x + d * hpoint[2].x;
            hpoint[0].y = (1.0 - d) * hpoint[1].y + d * hpoint[2].y;
            startPoint = lastPoint;
            Point endPoint = hpoint[0];
            Line l = new Line(null, parent, startPoint.x, startPoint.y, endPoint.x, endPoint.y);
            elements.add(l);
            lastPoint.set(hpoint[0]);
        }
        startPoint = lastPoint;
        Line l = new Line(null, parent, startPoint.x, startPoint.y, b[3].x, b[3].y);
        elements.add(l);
    }

    private int getBezierSegmentCount(Point p1, Point p2) {
        double distance = Util.distance(p1, p2);
        int count = (int)((distance *= this.config.getInterimScaleFactor()) / (double)this.config.getBezierFactor());
        if (count < 1) {
            count = 1;
        }
        return count;
    }

    private Point createLineSegmentsQuadraticBezier(PathCommand pcmd, PathCommand prevPcmd, Point currentPoint, GraphicElements elements, GraphicElement parent) {
        Point p1;
        Point p0 = currentPoint;
        if (pcmd.getCommandUpperCase() == 'T') {
            if (this.prevControlPoint == null) {
                this.prevControlPoint = currentPoint;
            }
            switch (prevPcmd.getCommand()) {
                case 'Q': 
                case 'T': 
                case 'q': 
                case 't': {
                    p1 = this.prevControlPoint.mirror(currentPoint);
                    break;
                }
                default: {
                    p1 = currentPoint;
                    break;
                }
            }
        } else {
            p1 = pcmd.getNextPointFromParameterAbsolute(currentPoint);
        }
        this.prevControlPoint = p1;
        Point p2 = pcmd.getNextPointFromParameterAbsolute(currentPoint);
        int segmentCount = this.getBezierSegmentCount(p0, p2);
        double increment = 1.0f / (float)segmentCount;
        Point oldB = currentPoint;
        for (double t = increment; t < 1.0; t += increment) {
            double t1 = 1.0 - t;
            double fact1 = t1 * t1;
            double fact2 = 2.0 * t1 * t;
            double fact3 = t * t;
            Point b = new Point();
            b.x = fact1 * p0.x + fact2 * p1.x + fact3 * p2.x;
            b.y = fact1 * p0.y + fact2 * p1.y + fact3 * p2.y;
            Line l = new Line(null, parent, oldB.x, oldB.y, b.x, b.y);
            elements.add(l);
            oldB = b;
        }
        return p2;
    }

    private Point createLineSegmentsArc(PathCommand pcmd, Point currentPoint, GraphicElements elements, GraphicElement parent) {
        Point endPoint;
        double rx = Math.abs(pcmd.getParameter(0));
        double ry = Math.abs(pcmd.getParameter(1));
        double phi = pcmd.getParameter(2);
        int lf = pcmd.getParameter(3).intValue();
        int sf = pcmd.getParameter(4).intValue();
        double x = pcmd.getParameter(5);
        double y = pcmd.getParameter(6);
        if (pcmd.isRelative()) {
            x += currentPoint.x;
            y += currentPoint.y;
        }
        if (!currentPoint.equals(endPoint = new Point(x, y))) {
            if (rx == 0.0 || ry == 0.0) {
                Line line = new Line(null, parent, currentPoint.x, currentPoint.y, endPoint.x, endPoint.y);
                elements.add(line);
            } else {
                int segmentCount = this.getBezierSegmentCount(currentPoint, endPoint);
                if (segmentCount < 4) {
                    segmentCount = 4;
                }
                double increment = 1.0f / (float)segmentCount;
                ArcSegmenter segmenter = new ArcSegmenter(currentPoint.x, currentPoint.y, endPoint.x, endPoint.y, rx, ry, phi, sf, lf);
                Point p1 = segmenter.getpnt(0.0);
                for (double t = increment; t < (double)1.000001f; t += increment) {
                    Point p2 = segmenter.getpnt(t);
                    Line line = new Line(null, parent, p1.x, p1.y, p2.x, p2.y);
                    elements.add(line);
                    p1 = p2;
                }
            }
        }
        return new Point(endPoint);
    }

    private boolean isCommand(char ch) {
        return COMMANDS.indexOf(ch = Character.toUpperCase(ch)) != -1;
    }

    private boolean isCoordChar(char ch) {
        return ch >= '0' && ch <= '9' || ch == 'e' || ch == 'E' || ch == '.' || ch == '-';
    }

    private static enum MODES {
        COMMAND,
        NUMBER;

    }
}

