/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.graphelem;

import de.berndbock.tinysvg.graphelem.parser.TransformCommand;
import de.berndbock.tinysvg.helper.Point;
import java.util.ArrayList;
import java.util.List;

public class Transformation {
    private List<TransformCommand> commands;
    private TransformCommand cumulatedCommand;
    private Point transformOrigin;

    public Transformation() {
        this.commands = null;
        this.cumulatedCommand = null;
        this.transformOrigin = null;
    }

    public Transformation(Transformation t) {
        this.commands = t.getCommands();
        this.cumulatedCommand = t.getCumulatedCommand() == null ? null : new TransformCommand(t.getCumulatedCommand());
        this.transformOrigin = t.getTransformOrigin();
    }

    public List<TransformCommand> getCommands() {
        return this.commands;
    }

    public Point getTransformOrigin() {
        return this.transformOrigin;
    }

    public void setTransformOrigin(Point transformOrigin) {
        this.transformOrigin = transformOrigin;
    }

    public int getCommandCount() {
        int result = 0;
        if (this.commands != null) {
            result = this.commands.size();
        }
        return result;
    }

    public void addCommand(TransformCommand cmd) {
        if (this.commands == null) {
            this.commands = new ArrayList<TransformCommand>();
        }
        this.commands.add(cmd);
        this.cumulateCommand(cmd, false);
    }

    public TransformCommand getCumulatedCommand() {
        return this.cumulatedCommand;
    }

    public double getScaleX() {
        double result;
        if (null == this.cumulatedCommand) {
            result = 1.0;
        } else {
            switch (this.cumulatedCommand.getCommand()) {
                case SCALE: {
                    result = this.cumulatedCommand.getParameter(0);
                    break;
                }
                case MATRIX: {
                    result = Math.sqrt(this.cumulatedCommand.getA() * this.cumulatedCommand.getA() + this.cumulatedCommand.getB() * this.cumulatedCommand.getB());
                    break;
                }
                default: {
                    result = 1.0;
                }
            }
        }
        return result;
    }

    public double getScaleY() {
        double result;
        if (null == this.cumulatedCommand) {
            result = this.getScaleX();
        } else {
            switch (this.cumulatedCommand.getCommand()) {
                case SCALE: {
                    if (this.cumulatedCommand.getParameterCount() > 1) {
                        result = this.cumulatedCommand.getParameter(1);
                        break;
                    }
                    result = this.cumulatedCommand.getParameter(0);
                    break;
                }
                case MATRIX: {
                    result = Math.sqrt(this.cumulatedCommand.getC() * this.cumulatedCommand.getC() + this.cumulatedCommand.getD() * this.cumulatedCommand.getD());
                    break;
                }
                default: {
                    result = this.getScaleX();
                }
            }
        }
        return result;
    }

    public double getScaleFactor() {
        return Math.min(this.getScaleX(), this.getScaleY());
    }

    public void cumulateCommand(TransformCommand cmd, boolean reverse) {
        if (cmd != null) {
            if (this.cumulatedCommand == null) {
                this.cumulatedCommand = cmd;
            } else {
                this.cumulatedCommand = this.toMatrix(this.cumulatedCommand);
                cmd = this.toMatrix(cmd);
                this.cumulatedCommand = this.multiply(cmd, reverse);
            }
        }
    }

    private TransformCommand toMatrix(TransformCommand cmd) {
        TransformCommand result;
        try {
            switch (cmd.getCommand()) {
                case TRANSLATE: {
                    result = new TransformCommand(TransformCommand.COMMAND.MATRIX);
                    result.addParameter(1.0);
                    result.addParameter(0.0);
                    result.addParameter(0.0);
                    result.addParameter(1.0);
                    result.addParameter(cmd.getA());
                    result.addParameter(cmd.getB());
                    break;
                }
                case ROTATE: {
                    result = new TransformCommand(TransformCommand.COMMAND.MATRIX);
                    double sin_a = Math.sin(this.gradToRad(cmd.getA()));
                    double cos_a = Math.cos(this.gradToRad(cmd.getA()));
                    if (cmd.getParameterCount() == 1) {
                        result.addParameter(cos_a);
                        result.addParameter(sin_a);
                        result.addParameter(-sin_a);
                        result.addParameter(cos_a);
                        result.addParameter(0.0);
                        result.addParameter(0.0);
                        break;
                    }
                    result.addParameter(cos_a);
                    result.addParameter(sin_a);
                    result.addParameter(-sin_a);
                    result.addParameter(cos_a);
                    result.addParameter((1.0 - cos_a) * cmd.getB() + sin_a * cmd.getC());
                    result.addParameter((1.0 - cos_a) * cmd.getC() - sin_a * cmd.getB());
                    break;
                }
                case SCALE: {
                    result = new TransformCommand(TransformCommand.COMMAND.MATRIX);
                    result.addParameter(cmd.getA());
                    result.addParameter(0.0);
                    result.addParameter(0.0);
                    result.addParameter(cmd.getB());
                    result.addParameter(0.0);
                    result.addParameter(0.0);
                    break;
                }
                case SKEW_X: {
                    result = new TransformCommand(TransformCommand.COMMAND.MATRIX);
                    result.addParameter(1.0);
                    result.addParameter(0.0);
                    result.addParameter(Math.tan(cmd.getA()));
                    result.addParameter(1.0);
                    result.addParameter(0.0);
                    result.addParameter(0.0);
                    break;
                }
                case SKEW_Y: {
                    result = new TransformCommand(TransformCommand.COMMAND.MATRIX);
                    result.addParameter(1.0);
                    result.addParameter(Math.tan(cmd.getA()));
                    result.addParameter(0.0);
                    result.addParameter(1.0);
                    result.addParameter(0.0);
                    result.addParameter(0.0);
                    break;
                }
                case MATRIX: {
                    result = cmd;
                    break;
                }
                default: {
                    result = null;
                    break;
                }
            }
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    private double gradToRad(double grad) {
        return grad * Math.PI / 180.0;
    }

    private TransformCommand multiply(TransformCommand cmd, boolean reverse) {
        TransformCommand result = new TransformCommand(TransformCommand.COMMAND.MATRIX);
        try {
            if (reverse) {
                result.addParameter(cmd.getA() * this.cumulatedCommand.getA() + cmd.getC() * this.cumulatedCommand.getB());
                result.addParameter(cmd.getB() * this.cumulatedCommand.getA() + cmd.getD() * this.cumulatedCommand.getB());
                result.addParameter(cmd.getA() * this.cumulatedCommand.getC() + cmd.getC() * this.cumulatedCommand.getD());
                result.addParameter(cmd.getB() * this.cumulatedCommand.getC() + cmd.getD() * this.cumulatedCommand.getD());
                result.addParameter(cmd.getA() * this.cumulatedCommand.getE() + cmd.getC() * this.cumulatedCommand.getF() + cmd.getE());
                result.addParameter(cmd.getB() * this.cumulatedCommand.getE() + cmd.getD() * this.cumulatedCommand.getF() + cmd.getF());
            } else {
                result.addParameter(this.cumulatedCommand.getA() * cmd.getA() + this.cumulatedCommand.getC() * cmd.getB());
                result.addParameter(this.cumulatedCommand.getB() * cmd.getA() + this.cumulatedCommand.getD() * cmd.getB());
                result.addParameter(this.cumulatedCommand.getA() * cmd.getC() + this.cumulatedCommand.getC() * cmd.getD());
                result.addParameter(this.cumulatedCommand.getB() * cmd.getC() + this.cumulatedCommand.getD() * cmd.getD());
                result.addParameter(this.cumulatedCommand.getA() * cmd.getE() + this.cumulatedCommand.getC() * cmd.getF() + this.cumulatedCommand.getE());
                result.addParameter(this.cumulatedCommand.getB() * cmd.getE() + this.cumulatedCommand.getD() * cmd.getF() + this.cumulatedCommand.getF());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void apply(Point p) {
        this.applyTransformCommand(p, this.cumulatedCommand);
    }

    private void applyTransformCommand(Point p, TransformCommand cmd) {
        if (cmd != null) {
            switch (cmd.getCommand()) {
                case TRANSLATE: {
                    p.x += cmd.getA();
                    p.y += cmd.getB();
                    break;
                }
                case ROTATE: {
                    double alpha = cmd.getA();
                    double sin = Math.sin(this.gradToRad(alpha));
                    double cos = Math.cos(this.gradToRad(alpha));
                    if (cmd.getParameterCount() == 1) {
                        if (this.transformOrigin != null) {
                            p.x -= this.transformOrigin.x;
                            p.y -= this.transformOrigin.y;
                        }
                        double x = p.x;
                        double y = p.y;
                        p.x = cos * x - sin * y;
                        p.y = sin * x + cos * y;
                        if (this.transformOrigin == null) break;
                        p.x += this.transformOrigin.x;
                        p.y += this.transformOrigin.y;
                        break;
                    }
                    double cx = cmd.getB();
                    double cy = cmd.getC();
                    p.x -= cx;
                    p.y -= cy;
                    double x = p.x;
                    double y = p.y;
                    p.x = cos * x - sin * y;
                    p.y = sin * x + cos * y;
                    p.x += cx;
                    p.y += cy;
                    break;
                }
                case SCALE: {
                    p.x *= cmd.getA();
                    p.y *= cmd.getB();
                    break;
                }
                case SKEW_X: {
                    double tan = Math.tan(cmd.getA());
                    p.x += tan * p.y;
                    break;
                }
                case SKEW_Y: {
                    double tan = Math.tan(cmd.getA());
                    p.y += tan * p.x;
                    break;
                }
                case MATRIX: {
                    double x = cmd.getA() * p.x + cmd.getC() * p.y + cmd.getE();
                    double y = cmd.getB() * p.x + cmd.getD() * p.y + cmd.getF();
                    p.x = x;
                    p.y = y;
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Transformation");
        if (this.cumulatedCommand != null) {
            sb.append(' ');
            sb.append(this.cumulatedCommand);
        }
        return sb.toString();
    }

    public String getObjectId() {
        return super.toString();
    }
}

