/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.graphelem;

import de.berndbock.tinysvg.graphelem.GraphicElement;
import de.berndbock.tinysvg.graphelem.Transformation;
import de.berndbock.tinysvg.helper.CoordMinMax;
import de.berndbock.tinysvg.helper.Point;
import de.berndbock.tinysvg.helper.Rotator;

public class Rect
extends GraphicElement {
    private final Point p = new Point(0.0, 0.0);
    private double width = 0.0;
    private double height = 0.0;

    public Rect(String id, GraphicElement parent, double x, double y, double width, double height) {
        super(1, id, parent);
        this.p.x = x;
        this.p.y = y;
        this.width = width;
        this.height = height;
    }

    public double getX() {
        return this.p.x;
    }

    public void setX(double x) {
        this.p.x = x;
    }

    public double getY() {
        return this.p.y;
    }

    public void setY(double y) {
        this.p.y = y;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public Point getP1() {
        return this.p;
    }

    public void setP1(Point p1) {
        this.p.x = p1.x;
        this.p.y = p1.y;
    }

    public Point getP2() {
        return new Point(this.p.x + this.width, this.p.y + this.height);
    }

    public void setP2(Point p2) {
        this.width = p2.x - this.p.x;
        this.height = p2.y - this.p.y;
    }

    @Override
    public String toString() {
        return "Rect(x=" + Rect.formatValue(this.p.x) + ", y=" + Rect.formatValue(this.p.y) + ", width=" + Rect.formatValue(this.width) + ", height=" + Rect.formatValue(this.height) + ")" + super.toString();
    }

    @Override
    public void transform() {
        Transformation t = this.getEffectiveTransformation();
        t.apply(this.p);
        this.width *= t.getScaleX();
        this.height *= t.getScaleY();
    }

    @Override
    public void collectStatistics(CoordMinMax coordMinMax) {
        Point p2 = new Point(this.p.x + this.width, this.p.y + this.height);
        coordMinMax.register(this.p);
        coordMinMax.register(p2);
    }

    @Override
    public GraphicElement getCopy(GraphicElement parent) {
        Rect copy = new Rect(this.id, parent, this.p.x, this.p.y, this.width, this.height);
        if (this.transformation != null) {
            copy.setTransformation(new Transformation(this.transformation));
        }
        return copy;
    }

    @Override
    public void mirrorVertically(double maxY) {
        this.p.y = maxY - this.p.y - this.height;
    }

    @Override
    public void mirrorHorizontally(double maxX) {
        this.p.x = maxX - this.p.x - this.width;
    }

    @Override
    public void rotate(Rotator rotator) {
        Point p1 = this.getP1();
        Point p2 = this.getP2();
        rotator.rotate(p1);
        rotator.rotate(p2);
        this.setP1(p1);
        this.setP2(p2);
    }

    @Override
    public void translate(double offsetX, double offsetY) {
        this.p.x -= offsetX;
        this.p.y -= offsetY;
    }
}

