/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.graphelem;

import de.berndbock.tinysvg.graphelem.GraphicElement;
import de.berndbock.tinysvg.graphelem.GraphicElements;
import de.berndbock.tinysvg.graphelem.Transformation;
import de.berndbock.tinysvg.graphelem.parser.PointsParser;
import de.berndbock.tinysvg.helper.CoordMinMax;
import de.berndbock.tinysvg.helper.Point;
import de.berndbock.tinysvg.helper.Rotator;
import java.util.ArrayList;
import java.util.List;

public class PolyLine
extends GraphicElement {
    protected String points;
    protected List<Point> pointsList = new ArrayList<Point>();

    public PolyLine(String id, GraphicElement parent, String points) {
        super(6, id, parent);
        this.points = points;
    }

    protected PolyLine(int type, String id, GraphicElement parent, String points) {
        super(type, id, parent);
        this.points = points;
    }

    public String getPoints() {
        return this.points;
    }

    public void setPoints(String points) {
        this.points = points;
    }

    public List<Point> getPointsList() {
        return this.pointsList;
    }

    public void addPoint(Point point) {
        this.pointsList.add(point);
    }

    public GraphicElements decode() {
        GraphicElements elements = null;
        if (this.points != null) {
            PointsParser parser = new PointsParser(this);
            elements = parser.convertToPrimitives();
        }
        return elements;
    }

    public void parsePoints() {
        if (this.points != null) {
            PointsParser parser = new PointsParser(this);
            parser.parsePoints();
        }
    }

    @Override
    public String toString() {
        return "PolyLine(points=" + this.points + ")" + super.toString();
    }

    @Override
    public void transform() {
        Transformation t = this.getEffectiveTransformation();
        for (Point p : this.pointsList) {
            t.apply(p);
        }
    }

    @Override
    public void collectStatistics(CoordMinMax coordMinMax) {
        for (Point p : this.pointsList) {
            coordMinMax.register(p);
        }
    }

    @Override
    public GraphicElement getCopy(GraphicElement parent) {
        PolyLine copy = new PolyLine(this.id, parent, this.points);
        if (this.transformation != null) {
            copy.setTransformation(new Transformation(this.transformation));
        }
        return copy;
    }

    @Override
    public void mirrorVertically(double maxY) {
        for (Point p : this.pointsList) {
            p.y = maxY - p.y;
        }
    }

    @Override
    public void mirrorHorizontally(double maxX) {
        for (Point p : this.pointsList) {
            p.x = maxX - p.x;
        }
    }

    @Override
    public void rotate(Rotator rotator) {
        for (Point p : this.pointsList) {
            rotator.rotate(p);
        }
    }

    @Override
    public void translate(double offsetX, double offsetY) {
        for (Point p : this.pointsList) {
            p.x -= offsetX;
            p.y -= offsetY;
        }
    }
}

