/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.graphelem;

import de.berndbock.tinysvg.helper.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PathCommand {
    private static final Logger LOGGER = Logger.getLogger("global");
    private final char command;
    private final char commandUpperCase;
    private final boolean relative;
    private final List<Double> parameters;
    private int paramIdx;
    private final List<Point> points;
    private int pointIdx;

    public PathCommand(char command) {
        this.command = command;
        this.commandUpperCase = Character.toUpperCase(command);
        this.relative = command >= 'a' && command <= 'z';
        this.parameters = new ArrayList<Double>();
        this.paramIdx = 0;
        this.points = new ArrayList<Point>();
        this.pointIdx = 0;
    }

    public char getCommand() {
        return this.command;
    }

    public char getCommandUpperCase() {
        return this.commandUpperCase;
    }

    public void addParameter(Double param) {
        this.parameters.add(param);
    }

    public void addParameter(String param) throws Exception {
        try {
            Double d = Double.parseDouble(param);
            this.parameters.add(d);
        }
        catch (NumberFormatException e) {
            throw new Exception("invalid path parameter: " + param);
        }
    }

    public int parameterCount() {
        return this.parameters.size();
    }

    public Double getParameter(int index) {
        return this.parameters.get(index);
    }

    public Double getPenultimateParameter() {
        return this.parameters.get(this.parameters.size() - 2);
    }

    public Double getLastParameter() {
        return this.parameters.get(this.parameters.size() - 1);
    }

    public Point getNextPointFromParameter() {
        Point p = this.getPointFromParameter(this.paramIdx);
        this.paramIdx += 2;
        return p;
    }

    public Point getNextPointFromParameterAbsolute(Point referencePoint) {
        Point p;
        if (referencePoint == null) {
            LOGGER.log(Level.SEVERE, "referencePoint is null");
        }
        if ((p = this.getNextPointFromParameter()) != null && this.relative) {
            p.x += referencePoint.x;
            p.y += referencePoint.y;
        }
        return p;
    }

    private Point getPointFromParameter(int idx) {
        Point p = null;
        if (idx < this.parameterCount() - 1) {
            double x = this.getParameter(idx++);
            double y = this.getParameter(idx);
            p = new Point(x, y);
        }
        return p;
    }

    public void resetParamIdx() {
        this.paramIdx = 0;
    }

    public void skipParameters(int count) {
        this.paramIdx += count;
    }

    public void addPoint(Point p) {
        this.points.add(p);
    }

    public Point getPoint(int index) {
        return this.points.get(index);
    }

    public int pointCount() {
        return this.points.size();
    }

    public void resetPointIdx() {
        this.pointIdx = 0;
    }

    public Point getNextPoint() {
        return this.pointIdx < this.points.size() ? this.points.get(this.pointIdx++) : null;
    }

    public boolean isRelative() {
        return this.relative;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command).append(' ');
        for (Double d : this.parameters) {
            sb.append(d.toString()).append(' ');
        }
        return sb.toString();
    }
}

