/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.graphelem;

import de.berndbock.tinysvg.Config;
import de.berndbock.tinysvg.graphelem.GraphicElement;
import de.berndbock.tinysvg.graphelem.GraphicElements;
import de.berndbock.tinysvg.graphelem.Line;
import de.berndbock.tinysvg.graphelem.PathCommand;
import de.berndbock.tinysvg.graphelem.Transformation;
import de.berndbock.tinysvg.graphelem.parser.PathParser;
import de.berndbock.tinysvg.helper.CoordMinMax;
import de.berndbock.tinysvg.helper.Point;
import de.berndbock.tinysvg.helper.Rotator;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Path
extends GraphicElement {
    private static final Logger LOGGER = Logger.getLogger("global");
    private String d;
    private final List<PathCommand> commandList;
    private final PathParser parser;

    public Path(String id, GraphicElement parent, String d) {
        super(4, id, parent);
        this.d = d;
        this.commandList = new ArrayList<PathCommand>();
        this.parser = new PathParser(this);
    }

    public String getD() {
        return this.d;
    }

    public void setD(String d) {
        this.d = d;
    }

    public List<PathCommand> getCommandList() {
        return this.commandList;
    }

    public void addPathCommand(PathCommand pcmd) {
        this.commandList.add(pcmd);
    }

    public void prepare(Config config) throws Exception {
        if (this.d != null) {
            this.parser.setConfig(config);
            this.parser.parseD();
        }
    }

    public GraphicElements decode(Config config) throws Exception {
        GraphicElements elements = null;
        if (this.d != null) {
            this.parser.setConfig(config);
            elements = this.parser.convertToPrimitives();
            for (int i = 0; i < elements.size(); ++i) {
                Line l = (Line)elements.get(i);
                LOGGER.log(Level.FINER, "decode: {0}", l);
            }
        }
        return elements;
    }

    @Override
    public String toString() {
        return "Path(d=" + this.d + ")" + super.toString();
    }

    @Override
    public void transform() {
    }

    @Override
    public void collectStatistics(CoordMinMax coordMinMax) {
        if (this.commandList != null) {
            for (PathCommand cmd : this.commandList) {
                Point p;
                cmd.resetPointIdx();
                while ((p = cmd.getNextPoint()) != null) {
                    coordMinMax.register(p);
                }
            }
        }
    }

    @Override
    public GraphicElement getCopy(GraphicElement parent) {
        Path copy = new Path(this.id, parent, this.d);
        if (this.transformation != null) {
            copy.setTransformation(new Transformation(this.transformation));
        }
        return copy;
    }

    @Override
    public void mirrorVertically(double maxY) {
    }

    @Override
    public void mirrorHorizontally(double maxX) {
    }

    @Override
    public void rotate(Rotator rotator) {
    }

    @Override
    public void translate(double offsetX, double offsetY) {
    }
}

