/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.graphelem;

import de.berndbock.tinysvg.graphelem.GraphicElement;
import de.berndbock.tinysvg.graphelem.Transformation;
import de.berndbock.tinysvg.helper.CoordMinMax;
import de.berndbock.tinysvg.helper.Point;
import de.berndbock.tinysvg.helper.Rotator;
import de.berndbock.tinysvg.util.Util;

public class Line
extends GraphicElement {
    private final Point p1;
    private final Point p2;

    public Line(String id, GraphicElement parent, double x1, double y1, double x2, double y2) {
        super(3, id, parent);
        this.p1 = new Point(x1, y1);
        this.p2 = new Point(x2, y2);
    }

    public double getX1() {
        return this.p1.x;
    }

    public int getX1Int() {
        return this.doubleToInt(this.p1.x);
    }

    public void setX1(double x1) {
        this.p1.x = x1;
    }

    public double getY1() {
        return this.p1.y;
    }

    public int getY1Int() {
        return this.doubleToInt(this.p1.y);
    }

    public void setY1(double y1) {
        this.p1.y = y1;
    }

    public double getX2() {
        return this.p2.x;
    }

    public int getX2Int() {
        return this.doubleToInt(this.p2.x);
    }

    public void setX2(double x2) {
        this.p2.x = x2;
    }

    public double getY2() {
        return this.p2.y;
    }

    public int getY2Int() {
        return this.doubleToInt(this.p2.y);
    }

    public void setY2(double y2) {
        this.p2.y = y2;
    }

    public Point getPoint1() {
        return this.p1;
    }

    public void setPoint1(Point p1) {
        this.p1.x = p1.x;
        this.p1.y = p1.y;
    }

    public Point getPoint2() {
        return this.p2;
    }

    public void setPoint2(Point p2) {
        this.p2.x = p2.x;
        this.p2.y = p2.y;
    }

    public double getAngle() {
        double dy = this.p2.y - this.p1.y;
        double dx = this.p2.x - this.p1.x;
        return Math.toDegrees(Math.atan2(dy, dx));
    }

    public double getLength() {
        return Util.distance(this.p1, this.p2);
    }

    @Override
    public String toString() {
        return "Line(x1=" + Line.formatValue(this.p1.x) + ", y1=" + Line.formatValue(this.p1.y) + ", x2=" + Line.formatValue(this.p2.x) + ", y2=" + Line.formatValue(this.p2.y) + ") angle: " + Line.formatValue(this.getAngle()) + super.toString();
    }

    @Override
    public void transform() {
        Transformation t = this.getEffectiveTransformation();
        t.apply(this.p1);
        t.apply(this.p2);
    }

    @Override
    public void collectStatistics(CoordMinMax coordMinMax) {
        coordMinMax.register(this.p1);
        coordMinMax.register(this.p2);
    }

    @Override
    public GraphicElement getCopy(GraphicElement parent) {
        Line copy = new Line(this.id, parent, this.p1.x, this.p1.y, this.p2.x, this.p2.y);
        if (this.transformation != null) {
            copy.setTransformation(new Transformation(this.transformation));
        }
        return copy;
    }

    @Override
    public void mirrorVertically(double maxY) {
        this.p1.y = maxY - this.p1.y;
        this.p2.y = maxY - this.p2.y;
    }

    @Override
    public void mirrorHorizontally(double maxX) {
        this.p1.x = maxX - this.p1.x;
        this.p2.x = maxX - this.p2.x;
    }

    @Override
    public void rotate(Rotator rotator) {
        rotator.rotate(this.p1);
        rotator.rotate(this.p2);
    }

    @Override
    public void translate(double offsetX, double offsetY) {
        this.p1.x -= offsetX;
        this.p1.y -= offsetY;
        this.p2.x -= offsetX;
        this.p2.y -= offsetY;
    }
}

