/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.graphelem;

import de.berndbock.tinysvg.graphelem.GraphicElement;
import de.berndbock.tinysvg.graphelem.Transformation;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class GraphicElements {
    private static final Logger LOGGER = Logger.getLogger(GraphicElements.class.getName());
    private final List<GraphicElement> elementList = new ArrayList<GraphicElement>();

    public int size() {
        return this.elementList.size();
    }

    public void add(GraphicElement element) {
        this.elementList.add(element);
    }

    public GraphicElement get(int index) {
        return this.elementList.get(index);
    }

    public void remove(GraphicElement element) {
        this.elementList.remove(element);
    }

    public void setTransformation(Transformation trans) {
        for (GraphicElement element : this.elementList) {
            Transformation tCopy = trans == null ? null : new Transformation(trans);
            element.setTransformation(tCopy);
        }
    }

    public void mirrorVertically(double resolutionY) {
        double maxY = resolutionY - 1.0;
        for (GraphicElement element : this.elementList) {
            element.mirrorVertically(maxY);
        }
    }

    public void mirrorHorizontally(double resolutionX) {
        double maxX = resolutionX - 1.0;
        for (GraphicElement element : this.elementList) {
            element.mirrorHorizontally(maxX);
        }
    }
}

