/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.graphelem;

import de.berndbock.tinysvg.graphelem.GraphicElements;
import de.berndbock.tinysvg.graphelem.Transformation;
import de.berndbock.tinysvg.helper.CoordMinMax;
import de.berndbock.tinysvg.helper.Rotator;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class GraphicElement {
    private static final Logger LOGGER = Logger.getLogger("global");
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_RECT = 1;
    public static final int TYPE_CIRCLE = 2;
    public static final int TYPE_LINE = 3;
    public static final int TYPE_PATH = 4;
    public static final int TYPE_ELLIPSE = 5;
    public static final int TYPE_POLYLINE = 6;
    public static final int TYPE_POLYGON = 7;
    public static final int TYPE_ARC = 8;
    public static final int TYPE_GROUP = 9;
    public static final int TYPE_DEFS = 10;
    public static final int TYPE_USE = 11;
    public static final int TYPE_SYMBOL = 12;
    public static final int TYPE_SVG = 13;
    public static final String[] TYPE_NAME = new String[]{"UNKNOWN", "RECT", "CIRCLE", "LINE", "PATH", "ELLIPSE", "POLYLINE", "POLYGON", "ARC", "GROUP", "DEFS", "USE", "SYMBOL", "SVG"};
    private final int type;
    protected GraphicElement parent;
    protected List<GraphicElement> children;
    protected String id;
    protected Transformation transformation;
    protected boolean marked;

    public GraphicElement(int type, String id, GraphicElement parent) {
        this.type = type;
        this.id = id;
        this.parent = parent;
        this.children = new ArrayList<GraphicElement>();
        this.transformation = null;
        this.marked = false;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return TYPE_NAME[this.type];
    }

    public GraphicElement getParent() {
        return this.parent;
    }

    public void setParent(GraphicElement parent) {
        this.parent = parent;
        parent.appendChild(this);
    }

    public List<GraphicElement> getChildren() {
        return this.children;
    }

    public void appendChild(GraphicElement child) {
        this.children.add(child);
    }

    public void appendChildren(GraphicElements children) {
        for (int i = 0; i < children.size(); ++i) {
            GraphicElement child = children.get(i);
            child.setParent(this);
        }
    }

    public void removeChild(GraphicElement child) {
        this.children.remove(child);
    }

    public String getId() {
        return this.id;
    }

    public Transformation getTransformation() {
        return this.transformation;
    }

    public void setTransformation(Transformation trans) {
        this.transformation = trans;
    }

    public void setTransformationSubtree(Transformation trans) {
        this.transformation = trans;
        for (GraphicElement child : this.children) {
            child.setTransformationSubtree(trans);
        }
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void setMarked(boolean marked) {
        this.marked = marked;
    }

    public Transformation getEffectiveTransformation() {
        Transformation t = this.transformation == null ? new Transformation() : new Transformation(this.transformation);
        for (GraphicElement ancestor = this.parent; ancestor != null; ancestor = ancestor.getParent()) {
            Transformation ancestorTrans = ancestor.getTransformation();
            if (ancestorTrans == null) continue;
            t.cumulateCommand(ancestorTrans.getCumulatedCommand(), true);
        }
        LOGGER.log(Level.FINE, "effective transformation: {0} object id: {1}", new Object[]{t, t.getObjectId()});
        return t;
    }

    public static String formatValue(double value) {
        return Double.toString((double)Math.round(value * 10.0) / 10.0);
    }

    protected int doubleToInt(double d) {
        return (int)d;
    }

    public abstract void transform();

    public abstract void collectStatistics(CoordMinMax var1);

    public abstract GraphicElement getCopy(GraphicElement var1);

    public abstract void mirrorVertically(double var1);

    public abstract void mirrorHorizontally(double var1);

    public abstract void rotate(Rotator var1);

    public abstract void translate(double var1, double var3);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" id: ").append(this.id);
        sb.append(" t: ").append(this.transformation);
        if (this.parent != null) {
            sb.append(" parent: ").append(this.parent.getTypeName());
        }
        return sb.toString();
    }

    public void dump() {
        this.dump(this, 0);
    }

    private void dump(GraphicElement element, int indent) {
        String sIndent = this.getIndentation(indent);
        LOGGER.log(Level.FINE, "{0}{1}", new Object[]{sIndent, element});
        for (GraphicElement child : element.getChildren()) {
            this.dump(child, indent + 1);
        }
    }

    public void dumpTransformations() {
        this.dumpTransformations(this, 0);
    }

    public void dumpTransformations(GraphicElement element, int indent) {
        String sIndent = this.getIndentation(indent);
        LOGGER.log(Level.FINE, "{0}{1}: {2}", new Object[]{sIndent, element.getId(), element.getTransformation()});
        for (GraphicElement ge : element.getChildren()) {
            this.dumpTransformations(ge, indent + 1);
        }
    }

    private String getIndentation(int level) {
        StringBuilder sb = new StringBuilder();
        level <<= 2;
        for (int i = 0; i < level; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }
}

