/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.graphelem;

import de.berndbock.tinysvg.graphelem.GraphicElement;
import de.berndbock.tinysvg.graphelem.GraphicElements;
import de.berndbock.tinysvg.graphelem.Line;
import de.berndbock.tinysvg.graphelem.Transformation;
import de.berndbock.tinysvg.graphelem.parser.TransformCommand;
import de.berndbock.tinysvg.helper.CoordMinMax;
import de.berndbock.tinysvg.helper.LineSegmentCreator;
import de.berndbock.tinysvg.helper.Point;
import de.berndbock.tinysvg.helper.Rotator;
import java.util.List;

public class Ellipse
extends GraphicElement {
    private final Point p;
    private double rx;
    private double ry;

    public Ellipse(String id, GraphicElement parent, double cx, double cy, double rx, double ry) {
        super(5, id, parent);
        this.p = new Point(cx, cy);
        this.rx = rx;
        this.ry = ry;
    }

    public double getCx() {
        return this.p.x;
    }

    public void setCx(double cx) {
        this.p.x = cx;
    }

    public double getCy() {
        return this.p.y;
    }

    public void setCy(double cy) {
        this.p.y = cy;
    }

    public double getRx() {
        return this.rx;
    }

    public void setRx(double rx) {
        this.rx = rx;
    }

    public double getRy() {
        return this.ry;
    }

    public void setRy(double ry) {
        this.ry = ry;
    }

    public Point getCenter() {
        return this.p;
    }

    public void setCenter(Point center) {
        this.p.x = center.x;
        this.p.y = center.y;
    }

    public GraphicElements decode() {
        GraphicElements elements = new GraphicElements();
        LineSegmentCreator creator = new LineSegmentCreator();
        List<Line> lines = creator.buildLines(this, this.parent);
        for (Line line : lines) {
            elements.add(line);
        }
        return elements;
    }

    @Override
    public String toString() {
        return "Ellipse(cx=" + Ellipse.formatValue(this.p.x) + ", cy=" + Ellipse.formatValue(this.p.y) + ", rx=" + Ellipse.formatValue(this.rx) + ", ry=" + Ellipse.formatValue(this.ry) + ")" + super.toString();
    }

    @Override
    public void transform() {
        Transformation t = this.getEffectiveTransformation();
        t.apply(this.p);
        this.rx *= t.getScaleX();
        this.ry *= t.getScaleY();
    }

    @Override
    public void collectStatistics(CoordMinMax coordMinMax) {
        Point p1 = new Point(this.p.x - this.rx, this.p.y - this.ry);
        Point p2 = new Point(this.p.x + this.rx, this.p.y + this.ry);
        coordMinMax.register(p1);
        coordMinMax.register(p2);
    }

    @Override
    public GraphicElement getCopy(GraphicElement parent) {
        Ellipse copy = new Ellipse(this.id, parent, this.p.x, this.p.y, this.rx, this.ry);
        if (this.transformation != null) {
            copy.setTransformation(new Transformation(this.transformation));
        }
        return copy;
    }

    @Override
    public void mirrorVertically(double maxY) {
        this.p.y = maxY - this.p.y;
    }

    @Override
    public void mirrorHorizontally(double maxX) {
        this.p.x = maxX - this.p.x;
    }

    @Override
    public void rotate(Rotator rotator) {
        rotator.rotate(this.p);
    }

    public boolean isRotated() {
        boolean rotated = false;
        Transformation t = this.getTransformation();
        if (t != null) {
            List<TransformCommand> commands = t.getCommands();
            for (TransformCommand tcmd : commands) {
                TransformCommand.COMMAND cmd = tcmd.getCommand();
                if (cmd != TransformCommand.COMMAND.ROTATE && cmd != TransformCommand.COMMAND.MATRIX && cmd != TransformCommand.COMMAND.SKEW_X && cmd != TransformCommand.COMMAND.SKEW_Y) continue;
                rotated = true;
                break;
            }
        }
        return rotated;
    }

    @Override
    public void translate(double offsetX, double offsetY) {
        this.p.x -= offsetX;
        this.p.y -= offsetY;
    }
}

