/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg.graphelem;

import de.berndbock.tinysvg.graphelem.GraphicElement;
import de.berndbock.tinysvg.graphelem.Transformation;
import de.berndbock.tinysvg.helper.CoordMinMax;
import de.berndbock.tinysvg.helper.Point;
import de.berndbock.tinysvg.helper.Rotator;

public class Circle
extends GraphicElement {
    private final Point p;
    private double r;

    public Circle(String id, GraphicElement parent, double cx, double cy, double r) {
        super(2, id, parent);
        this.p = new Point(cx, cy);
        this.r = r;
    }

    public double getCx() {
        return this.p.x;
    }

    public void setCx(double cx) {
        this.p.x = cx;
    }

    public double getCy() {
        return this.p.y;
    }

    public void setCy(double cy) {
        this.p.y = cy;
    }

    public double getR() {
        return this.r;
    }

    public void setR(double r) {
        this.r = r;
    }

    public Point getCenter() {
        return this.p;
    }

    public void setCenter(Point center) {
        this.p.x = center.x;
        this.p.y = center.y;
    }

    @Override
    public String toString() {
        return "Circle(cx=" + Circle.formatValue(this.p.x) + ", cy=" + Circle.formatValue(this.p.y) + ", r=" + Circle.formatValue(this.r) + ")" + super.toString();
    }

    @Override
    public void transform() {
        Transformation t = this.getEffectiveTransformation();
        t.apply(this.p);
        this.r *= t.getScaleX();
    }

    @Override
    public void collectStatistics(CoordMinMax coordMinMax) {
        Point p1 = new Point(this.p.x - this.r, this.p.y - this.r);
        Point p2 = new Point(this.p.x + this.r, this.p.y + this.r);
        coordMinMax.register(p1);
        coordMinMax.register(p2);
    }

    @Override
    public GraphicElement getCopy(GraphicElement parent) {
        Circle copy = new Circle(this.id, parent, this.p.x, this.p.y, this.r);
        if (this.transformation != null) {
            copy.setTransformation(new Transformation(this.transformation));
        }
        return copy;
    }

    @Override
    public void mirrorVertically(double maxY) {
        this.p.y = maxY - this.p.y;
    }

    @Override
    public void mirrorHorizontally(double maxX) {
        this.p.x = maxX - this.p.x;
    }

    @Override
    public void rotate(Rotator rotator) {
        rotator.rotate(this.p);
    }

    @Override
    public void translate(double offsetX, double offsetY) {
        this.p.x -= offsetX;
        this.p.y -= offsetY;
    }
}

