/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg;

import de.berndbock.tinysvg.Config;
import de.berndbock.tinysvg.graphelem.Ellipse;
import de.berndbock.tinysvg.graphelem.GraphicElement;
import de.berndbock.tinysvg.graphelem.GraphicElements;
import de.berndbock.tinysvg.graphelem.Path;
import de.berndbock.tinysvg.graphelem.PolyLine;
import de.berndbock.tinysvg.graphelem.Polygon;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PrimitiveCreator {
    private static final Logger LOGGER = Logger.getLogger("global");
    private final Config config;
    private final GraphicElement root1;
    private final GraphicElement root2;

    public PrimitiveCreator(Config config, GraphicElement root) {
        this.config = config;
        this.root1 = root;
        this.root2 = root.getCopy(null);
    }

    public void prepare() {
        this.prepare(this.root1);
    }

    private void prepare(GraphicElement element) {
        switch (element.getType()) {
            case 4: {
                Path p = (Path)element;
                try {
                    p.prepare(this.config);
                }
                catch (Exception ex) {
                    LOGGER.severe(ex.getMessage());
                }
                break;
            }
        }
        for (GraphicElement child : element.getChildren()) {
            this.prepare(child);
        }
    }

    public GraphicElement toPrimitives() {
        this.toPrimitives(this.root1, this.root2);
        return this.root2;
    }

    private void toPrimitives(GraphicElement element1, GraphicElement element2) {
        switch (element1.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 13: {
                element2 = this.copyElement(element1, element2);
                break;
            }
            case 4: {
                GraphicElements decoded;
                GraphicElement p = (Path)element1;
                try {
                    decoded = ((Path)p).decode(this.config);
                    element2.appendChildren(decoded);
                    element2 = null;
                }
                catch (Exception ex) {
                    LOGGER.severe(ex.getMessage());
                }
                break;
            }
            case 5: {
                GraphicElements decoded;
                Ellipse e = (Ellipse)element1;
                if ((this.config.getProfileFlags() & 0x10) == 0 || e.isRotated()) {
                    decoded = e.decode();
                    element2.appendChildren(decoded);
                    element2 = null;
                    break;
                }
                element2 = this.copyElement(element1, element2);
                break;
            }
            case 6: {
                GraphicElement p = (PolyLine)element1;
                if ((this.config.getProfileFlags() & 0x80) != 0) {
                    ((PolyLine)p).parsePoints();
                    p.setParent(element2);
                    element2 = null;
                    break;
                }
                GraphicElements decoded = ((PolyLine)p).decode();
                element2.appendChildren(decoded);
                element2 = null;
                break;
            }
            case 7: {
                GraphicElement p = (Polygon)element1;
                if ((this.config.getProfileFlags() & 0x80) != 0) {
                    ((Polygon)p).parsePoints();
                    p.setParent(element2);
                    element2 = null;
                    break;
                }
                GraphicElements decoded = ((Polygon)p).decode();
                element2.appendChildren(decoded);
                element2 = null;
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "Unknown graphic element type: {0}", element1.getType());
            }
        }
        for (GraphicElement child : element1.getChildren()) {
            this.toPrimitives(child, element2);
        }
    }

    private GraphicElement copyElement(GraphicElement element1, GraphicElement element2) {
        if (element1 != this.root1) {
            GraphicElement copy = element1.getCopy(element2);
            element2.appendChild(copy);
            element2 = copy;
        }
        return element2;
    }
}

