/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg;

import de.berndbock.tinysvg.Config;
import de.berndbock.tinysvg.TinySVG;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;

public class OutputFileProfileDialog
extends JDialog {
    private final Config config;
    private JButton butCancel;
    private JButton butOk;
    private JCheckBox cbBox;
    private JCheckBox cbCircle;
    private JCheckBox cbDot;
    private JCheckBox cbEllipse;
    private JCheckBox cbLine;
    private JCheckBox cbMultiDot;
    private JCheckBox cbMultiLine;
    private JCheckBox cbPolygonFill;
    private JCheckBox cbSquare;
    private JLabel lblTitle;

    public OutputFileProfileDialog(Frame parent, boolean modal, Config config) {
        super(parent, modal);
        this.config = config;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.butOk);
        this.addEscapeListener();
        int profileFlags = config.getProfileFlags();
        this.cbDot.setSelected((profileFlags & 1) != 0);
        this.cbLine.setSelected((profileFlags & 2) != 0);
        this.cbBox.setSelected((profileFlags & 4) != 0);
        this.cbSquare.setSelected((profileFlags & 8) != 0);
        this.cbEllipse.setSelected((profileFlags & 0x10) != 0);
        this.cbCircle.setSelected((profileFlags & 0x20) != 0);
        this.cbMultiDot.setSelected((profileFlags & 0x40) != 0);
        this.cbMultiLine.setSelected((profileFlags & 0x80) != 0);
        this.cbPolygonFill.setSelected((profileFlags & 0x100) != 0);
    }

    private void initComponents() {
        this.lblTitle = new JLabel();
        this.cbDot = new JCheckBox();
        this.cbLine = new JCheckBox();
        this.cbBox = new JCheckBox();
        this.cbSquare = new JCheckBox();
        this.cbEllipse = new JCheckBox();
        this.cbCircle = new JCheckBox();
        this.cbMultiDot = new JCheckBox();
        this.cbMultiLine = new JCheckBox();
        this.cbPolygonFill = new JCheckBox();
        this.butOk = new JButton();
        this.butCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.lblTitle.setFont(new Font("Tahoma", 0, 18));
        this.lblTitle.setText(TinySVG.getBundle().getString("OUTPUT_FILE_PROFILE_TITLE"));
        this.cbDot.setText("Dot");
        this.cbLine.setText("Line");
        this.cbBox.setText("Box");
        this.cbSquare.setText("Square");
        this.cbEllipse.setText("Ellipse");
        this.cbCircle.setText("Circle");
        this.cbMultiDot.setText("Multi-Dot");
        this.cbMultiLine.setText("Multi-Line");
        this.cbPolygonFill.setText("Polygon-Fill");
        this.butOk.setText("OK");
        this.butOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputFileProfileDialog.this.butOkActionPerformed(evt);
            }
        });
        this.butCancel.setText(TinySVG.getBundle().getString("CANCEL"));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputFileProfileDialog.this.butCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.butOk, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.butCancel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblTitle).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbLine).addComponent(this.cbDot).addComponent(this.cbBox).addComponent(this.cbSquare).addComponent(this.cbEllipse).addComponent(this.cbCircle).addComponent(this.cbMultiDot).addComponent(this.cbMultiLine).addComponent(this.cbPolygonFill)))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblTitle).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbDot).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbLine).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbSquare).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbEllipse).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbCircle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbMultiDot).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbMultiLine).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbPolygonFill).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.butOk).addComponent(this.butCancel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void butOkActionPerformed(ActionEvent evt) {
        int profileFlags = 0;
        if (this.cbDot.isSelected()) {
            profileFlags |= 1;
        }
        if (this.cbLine.isSelected()) {
            profileFlags |= 2;
        }
        if (this.cbBox.isSelected()) {
            profileFlags |= 4;
        }
        if (this.cbSquare.isSelected()) {
            profileFlags |= 8;
        }
        if (this.cbEllipse.isSelected()) {
            profileFlags |= 0x10;
        }
        if (this.cbCircle.isSelected()) {
            profileFlags |= 0x20;
        }
        if (this.cbMultiDot.isSelected()) {
            profileFlags |= 0x40;
        }
        if (this.cbMultiLine.isSelected()) {
            profileFlags |= 0x80;
        }
        if (this.cbPolygonFill.isSelected()) {
            profileFlags |= 0x100;
        }
        this.config.setProfileFlags(profileFlags);
        this.dispose();
    }

    private void addEscapeListener() {
        ActionListener escListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputFileProfileDialog.this.butCancelActionPerformed(null);
            }
        };
        this.getRootPane().registerKeyboardAction(escListener, KeyStroke.getKeyStroke(27, 0), 2);
    }
}

