/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg;

import de.berndbock.tinysvg.Config;
import de.berndbock.tinysvg.ConfigDialog;
import de.berndbock.tinysvg.ConfigurableLogging;
import de.berndbock.tinysvg.DrawPanel;
import de.berndbock.tinysvg.LogDialog;
import de.berndbock.tinysvg.TinySVG;
import de.berndbock.tinysvg.graphelem.GraphicElements;
import de.berndbock.tinysvg.graphelem.parser.SvgParser;
import de.berndbock.tinysvg.helper.CoordMinMax;
import de.berndbock.tinysvg.helper.Point;
import de.berndbock.tinysvg.util.Util;
import de.berndbock.tinysvg.writer.EggPainter;
import de.berndbock.tinysvg.writer.HpglWriter;
import de.berndbock.tinysvg.writer.SvgWriter;
import de.berndbock.tinysvg.writer.Ve2Writer;
import de.berndbock.tinysvg.writer.VecWriter;
import de.berndbock.tinysvg.writer.ZX81Writer;
import de.berndbock.tinysvg.writer.ZXSpectrumSpeedplotExtWriter;
import de.berndbock.tinysvg.writer.ZXSpectrumSpeedplotWriter;
import de.berndbock.tinysvg.writer.ZXSpectrumWriter;
import de.berndbock.tinysvg.writer.ZxCncWriter;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileNameExtensionFilter;

public class MainGUI
extends JFrame
implements ConfigurableLogging {
    private static final Logger LOGGER = Logger.getLogger("global");
    private static final String VERSION = "1.1";
    private static ResourceBundle resbundle = TinySVG.getBundle();
    private final Config config;
    private boolean isDataMirroredVertically;
    private DrawPanel drawPanel;
    private JPopupMenu.Separator jSeparator1;
    private JMenuBar menuBar;
    private JMenu menuFile;
    private JMenu menuHelp;
    private JMenuItem menuItemConfig;
    private JMenuItem menuItemEnglish;
    private JMenuItem menuItemFileExit;
    private JMenuItem menuItemFileOpen;
    private JMenuItem menuItemGerman;
    private JMenuItem menuItemHelpAbout;
    private JMenuItem menuItemLog;
    private JMenuItem menuItemReload;
    private JMenu menuOptions;
    private JFileChooser fileChooser = null;

    public MainGUI() {
        this.initComponents();
        this.config = new Config();
        this.setLogLevel(this.config.getLogLevel());
        this.adaptSize(this.config.getResolutionX(), this.config.getResolutionYAdjusted());
        this.isDataMirroredVertically = false;
    }

    private void initComponents() {
        this.drawPanel = new DrawPanel();
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu();
        this.menuItemFileOpen = new JMenuItem();
        this.menuItemReload = new JMenuItem();
        this.menuItemFileExit = new JMenuItem();
        this.menuOptions = new JMenu();
        this.menuItemLog = new JMenuItem();
        this.menuItemConfig = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.menuItemGerman = new JMenuItem();
        this.menuItemEnglish = new JMenuItem();
        this.menuHelp = new JMenu();
        this.menuItemHelpAbout = new JMenuItem();
        this.setDefaultCloseOperation(3);
        ResourceBundle bundle = ResourceBundle.getBundle("resources/resbundle");
        this.setTitle(bundle.getString("MainGUI.title"));
        this.setMinimumSize(new Dimension(720, 536));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MainGUI.this.formWindowClosing(evt);
            }
        });
        this.drawPanel.setMaximumSize(null);
        this.drawPanel.setMinimumSize(null);
        GroupLayout drawPanelLayout = new GroupLayout(this.drawPanel);
        this.drawPanel.setLayout(drawPanelLayout);
        drawPanelLayout.setHorizontalGroup(drawPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 720, Short.MAX_VALUE));
        drawPanelLayout.setVerticalGroup(drawPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 512, Short.MAX_VALUE));
        this.menuFile.setMnemonic('F');
        this.menuFile.setText(resbundle.getString("FILE"));
        this.menuItemFileOpen.setMnemonic('O');
        this.menuItemFileOpen.setText(resbundle.getString("OPEN"));
        this.menuItemFileOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.menuItemFileOpenActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuItemFileOpen);
        this.menuItemReload.setText(resbundle.getString("RELOAD"));
        this.menuItemReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.menuItemReloadActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuItemReload);
        this.menuItemFileExit.setMnemonic('X');
        this.menuItemFileExit.setText(resbundle.getString("EXIT"));
        this.menuItemFileExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.menuItemFileExitActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuItemFileExit);
        this.menuBar.add(this.menuFile);
        this.menuOptions.setMnemonic('O');
        this.menuOptions.setText(resbundle.getString("OPTIONS"));
        this.menuItemLog.setMnemonic('L');
        this.menuItemLog.setText(resbundle.getString("SET_LOG_LEVEL"));
        this.menuItemLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.menuItemLogActionPerformed(evt);
            }
        });
        this.menuOptions.add(this.menuItemLog);
        this.menuItemConfig.setText(resbundle.getString("CONFIGURATION"));
        this.menuItemConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.menuItemConfigActionPerformed(evt);
            }
        });
        this.menuOptions.add(this.menuItemConfig);
        this.menuOptions.add(this.jSeparator1);
        this.menuItemGerman.setText(TinySVG.getBundle().getString("MainGUI.menuItemGerman.text"));
        this.menuItemGerman.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.menuItemGermanActionPerformed(evt);
            }
        });
        this.menuOptions.add(this.menuItemGerman);
        this.menuItemEnglish.setText(TinySVG.getBundle().getString("MainGUI.menuItemEnglish.text"));
        this.menuItemEnglish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.menuItemEnglishActionPerformed(evt);
            }
        });
        this.menuOptions.add(this.menuItemEnglish);
        this.menuBar.add(this.menuOptions);
        this.menuHelp.setMnemonic('H');
        this.menuHelp.setText(resbundle.getString("HELP"));
        this.menuItemHelpAbout.setMnemonic('A');
        this.menuItemHelpAbout.setText(resbundle.getString("ABOUT"));
        this.menuItemHelpAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.menuItemHelpAboutActionPerformed(evt);
            }
        });
        this.menuHelp.add(this.menuItemHelpAbout);
        this.menuBar.add(this.menuHelp);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.drawPanel, -2, -1, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.drawPanel, -2, -1, -2).addGap(0, 3, Short.MAX_VALUE)));
        this.pack();
    }

    private void menuItemFileExitActionPerformed(ActionEvent evt) {
        this.bye();
        System.exit(0);
    }

    private void menuItemFileOpenActionPerformed(ActionEvent evt) {
        JFileChooser fc = this.getFileChooser();
        int result = fc.showOpenDialog(this);
        if (result == 0) {
            File selectedFile = fc.getSelectedFile();
            LOGGER.fine(selectedFile.toString());
            this.convertSvgFile(selectedFile);
        }
    }

    private void menuItemHelpAboutActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "TinySVG\nVersion 1.1\n\nDipl.-Inform. Bernd Bock", resbundle.getString("ABOUT_TITLE"), 1);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.bye();
    }

    private void menuItemReloadActionPerformed(ActionEvent evt) {
        this.reload();
    }

    private void menuItemConfigActionPerformed(ActionEvent evt) {
        ConfigDialog dialog = new ConfigDialog((Frame)this, true, this.config);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (!this.config.isCancelled()) {
            this.adaptSize(this.config.getResolutionX(), this.config.getResolutionYAdjusted());
            this.reload();
        }
    }

    private void menuItemLogActionPerformed(ActionEvent evt) {
        LogDialog dialog = new LogDialog((Frame)this, true);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void menuItemGermanActionPerformed(ActionEvent evt) {
        TinySVG.setBundle(Locale.GERMAN);
        resbundle = TinySVG.getBundle();
        this.initComponents();
    }

    private void menuItemEnglishActionPerformed(ActionEvent evt) {
        TinySVG.setBundle(Locale.ENGLISH);
        resbundle = TinySVG.getBundle();
        this.initComponents();
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setFileSelectionMode(0);
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Scalable Vector Graphics (*.svg)", "svg");
            this.fileChooser.addChoosableFileFilter(filter);
            this.fileChooser.setFileFilter(filter);
            this.fileChooser.setDialogTitle(resbundle.getString("OPEN_SVG_FILE_TITLE"));
            if (this.config.getSvgPath() != null) {
                this.fileChooser.setCurrentDirectory(new File(this.config.getSvgPath()));
            }
        }
        return this.fileChooser;
    }

    private void convertSvgFile(File svgFile) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        SvgParser parser = new SvgParser(this.config);
        try {
            GraphicElements graphicElements = parser.parse(svgFile);
            if (this.config.isMirrorVertically()) {
                graphicElements.mirrorVertically(this.config.getResolutionYAdjusted());
                this.isDataMirroredVertically = true;
            }
            this.mirrorHorizontally(graphicElements);
            this.drawPanel.setGraphicElements(graphicElements);
            this.drawPanel.repaint();
            String svgFilepath = svgFile.getPath();
            int idxDot = svgFilepath.indexOf(46);
            if (idxDot != -1) {
                svgFilepath = svgFilepath.substring(0, idxDot);
            }
            if (this.config.isWriteVec()) {
                this.mirrorVertically(graphicElements);
                String vecFilepath = svgFilepath + ".vec";
                File vecFile = new File(vecFilepath);
                VecWriter vecWriter = new VecWriter(this.config.isDoubleHeightPreview());
                vecWriter.write(graphicElements, vecFile);
            }
            if (this.config.isWriteVe2()) {
                this.mirrorVertically(graphicElements);
                CoordMinMax coordMinMax = parser.getCoordMinMax();
                Point minimum = coordMinMax.getMinimum();
                Point maximum = coordMinMax.getMaximum();
                String ve2Filepath = svgFilepath + ".ve2";
                File ve2File = new File(ve2Filepath);
                Ve2Writer ve2Writer = new Ve2Writer(this.config.isDoubleHeightPreview(), (int)minimum.x, (int)maximum.x, (int)minimum.y, (int)maximum.y, this.config.getResolutionX(), this.config.getResolutionY(), Util.bytesNeeded(this.config.getResolutionX()), Util.bytesNeeded(this.config.getResolutionY()), this.config.getProfileFlags());
                ve2Writer.write(graphicElements, ve2File);
            }
            if (this.config.isWriteEggPainter()) {
                this.mirrorVertically(graphicElements);
                String eggFilepath = svgFilepath + ".bas";
                File eggFile = new File(eggFilepath);
                EggPainter eggPainter = new EggPainter();
                eggPainter.write(graphicElements, eggFile);
            }
            if (this.config.isWriteZxCnc()) {
                this.mirrorVertically(graphicElements);
                String cncFilepath = svgFilepath + ".cnc";
                File cncFile = new File(cncFilepath);
                ZxCncWriter cncWriter = new ZxCncWriter();
                cncWriter.write(graphicElements, cncFile);
            }
            if (this.config.isWriteHpgl()) {
                this.mirrorVertically(graphicElements);
                String hpglFilepath = svgFilepath + ".plt";
                File hpglFile = new File(hpglFilepath);
                HpglWriter hpglWriter = new HpglWriter();
                hpglWriter.write(graphicElements, hpglFile);
            }
            if (this.config.isWriteZX81()) {
                this.mirrorVertically(graphicElements);
                String zx81Filepath = svgFilepath + ".p";
                File zx81File = new File(zx81Filepath);
                ZX81Writer zx81Writer = new ZX81Writer();
                zx81Writer.write(graphicElements, zx81File);
            }
            if (this.config.isWriteZXSpectrum()) {
                this.mirrorVertically(graphicElements);
                String zxSpectrumFilepath = svgFilepath + ".zxv";
                File zxSpectrumFile = new File(zxSpectrumFilepath);
                ZXSpectrumWriter zxSpectrumWriter = new ZXSpectrumWriter();
                zxSpectrumWriter.write(graphicElements, zxSpectrumFile);
            }
            if (this.config.isWriteZXSpectrumSpeedplot()) {
                this.mirrorVertically(graphicElements);
                String zxSpectrumSpeedplotFilepath = svgFilepath + ".zxs";
                File zxSpectrumSpeedplotFile = new File(zxSpectrumSpeedplotFilepath);
                ZXSpectrumSpeedplotWriter zxSpectrumSpeedplotWriter = new ZXSpectrumSpeedplotWriter();
                zxSpectrumSpeedplotWriter.write(graphicElements, zxSpectrumSpeedplotFile);
            }
            if (this.config.isWriteZXSpectrumSpeedplotExt()) {
                this.mirrorVertically(graphicElements);
                String zxSpectrumSpeedplotExtFilepath = svgFilepath + ".zxx";
                File zxSpectrumSpeedplotExtFile = new File(zxSpectrumSpeedplotExtFilepath);
                ZXSpectrumSpeedplotExtWriter zxSpectrumSpeedplotExtWriter = new ZXSpectrumSpeedplotExtWriter();
                zxSpectrumSpeedplotExtWriter.write(graphicElements, zxSpectrumSpeedplotExtFile);
            }
            if (this.config.isWriteSvg()) {
                this.mirrorVertically(graphicElements);
                String tinySvgFilepath = svgFilepath + "_TinySVG.svg";
                File tinySvgFile = new File(tinySvgFilepath);
                SvgWriter svgWriter = new SvgWriter();
                svgWriter.write(graphicElements, tinySvgFile, this.config.getResolutionX(), this.config.getResolutionYAdjusted());
            }
            if (!this.config.isMirrorVertically() && this.isDataMirroredVertically || this.config.isMirrorVertically() && !this.isDataMirroredVertically) {
                graphicElements.mirrorVertically(this.config.getResolutionY());
                this.isDataMirroredVertically = !this.isDataMirroredVertically;
            }
        }
        catch (Exception ex) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            String msg = "Exception in convertSvgFile";
            if (ex.getMessage() != null) {
                msg = msg + ":\n" + ex.getMessage();
            }
            JOptionPane.showMessageDialog(this, msg, resbundle.getString("ERR_MSG_EXCEPTION_OCCURRED_TITLE"), 0);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void mirrorVertically(GraphicElements graphicElements) {
        boolean executeMirror = this.config.isMirrorVertically() ^ this.isDataMirroredVertically;
        if (this.config.isOriginAtBottomLeft()) {
            boolean bl = executeMirror = !executeMirror;
        }
        if (executeMirror) {
            graphicElements.mirrorVertically(this.config.getResolutionY());
            this.isDataMirroredVertically = !this.isDataMirroredVertically;
        }
    }

    private void mirrorHorizontally(GraphicElements graphicElements) {
        if (this.config.isMirrorHorizontally()) {
            graphicElements.mirrorHorizontally(this.config.getResolutionX());
        }
    }

    private void reload() {
        this.isDataMirroredVertically = false;
        JFileChooser fc = this.getFileChooser();
        File selectedFile = fc.getSelectedFile();
        if (selectedFile != null) {
            LOGGER.fine(selectedFile.toString());
            this.convertSvgFile(selectedFile);
        }
    }

    @Override
    public final void setLogLevel(Level level) {
        Logger logger = Logger.getLogger("global");
        logger.setLevel(level);
    }

    @Override
    public Level getLogLevel() {
        Logger logger = Logger.getLogger("global");
        return logger.getLevel();
    }

    private void bye() {
        this.config.setSvgPath(this.getFileChooser().getCurrentDirectory().getPath());
        this.config.setLogLevel(this.getLogLevel());
        this.config.save();
    }

    private void adaptSize(int width, int height) {
        this.setLayout(null);
        this.setSize(736, height + 62);
        this.drawPanel.setBounds(0, 0, width, height);
        this.drawPanel.initSize(this.config);
    }
}

