/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg;

import de.berndbock.tinysvg.Config;
import de.berndbock.tinysvg.graphelem.GraphicElement;
import de.berndbock.tinysvg.graphelem.GraphicElements;
import de.berndbock.tinysvg.graphelem.Line;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LineReducer {
    private static final Logger LOGGER = Logger.getLogger("global");
    private final Config config;
    private GraphicElements elements;
    private List<Line>[][] start;

    public LineReducer(Config config, GraphicElements elements) {
        this.config = config;
        this.elements = elements;
        this.start = null;
    }

    public GraphicElements reduce() {
        LOGGER.log(Level.INFO, "total number of elements: {0}", this.elements.size());
        this.initArrays();
        this.removeLines();
        LOGGER.log(Level.INFO, "number of elements after reduction: {0}", this.elements.size());
        this.setMarked(this.elements, false);
        this.sortByConnectedLines();
        return this.elements;
    }

    private void initArrays() {
        this.start = new List[this.config.getResolutionX() + 1][this.config.getResolutionYAdjusted() + 1];
        for (int i = 0; i < this.elements.size(); ++i) {
            int y1;
            GraphicElement element = this.elements.get(i);
            if (element.getType() != 3) continue;
            Line l = (Line)element;
            int x1 = l.getX1Int();
            if (this.start[x1][y1 = l.getY1Int()] == null) {
                this.start[x1][y1] = new ArrayList<Line>();
            }
            this.start[x1][y1].add(l);
        }
    }

    private void removeLines() {
        int removedCountIteration;
        int removedCountTotal = 0;
        int iterations = 0;
        do {
            removedCountIteration = 0;
            ++iterations;
            for (int x = 0; x < this.config.getResolutionX() + 1; ++x) {
                for (int y = 0; y < this.config.getResolutionYAdjusted() + 1; ++y) {
                    if (this.start[x][y] == null) continue;
                    removedCountIteration += this.removeUnnecessaryLines(this.start[x][y]);
                }
            }
            removedCountTotal += removedCountIteration;
        } while (removedCountIteration != 0);
        LOGGER.log(Level.FINE, "lines removed: {0}", removedCountTotal);
        LOGGER.log(Level.INFO, "number of iterations: {0}", iterations);
    }

    private int removeUnnecessaryLines(List<Line> lines) {
        int removedCount = 0;
        for (Line l : lines) {
            int l_y2;
            int l_x2;
            List<Line> list2;
            if (l.isMarked() || (list2 = this.start[l_x2 = l.getX2Int()][l_y2 = l.getY2Int()]) == null) continue;
            for (Line l2 : list2) {
                if (l2.isMarked() || l == l2) continue;
                int l2_x1 = l2.getX1Int();
                int l2_y1 = l2.getY1Int();
                int l2_x2 = l2.getX2Int();
                int l2_y2 = l2.getY2Int();
                if (l2_x1 == l2_x2 && l2_y1 == l2_y2) {
                    ++removedCount;
                    this.elements.remove(l2);
                    l2.setMarked(true);
                    continue;
                }
                if (!(Math.abs(l.getAngle() - l2.getAngle()) < 1.0)) continue;
                l.setX2(l2.getX2());
                l.setY2(l2.getY2());
                ++removedCount;
                this.elements.remove(l2);
                l2.setMarked(true);
            }
        }
        return removedCount;
    }

    private void sortByConnectedLines() {
        boolean elementAdded;
        GraphicElements sorted = new GraphicElements();
        do {
            elementAdded = false;
            for (int i = 0; i < this.elements.size(); ++i) {
                GraphicElement element = this.elements.get(i);
                if (element.isMarked()) continue;
                if (element.getType() == 3) {
                    Line connectedLine;
                    List<Line> connectedLines;
                    sorted.add(element);
                    element.setMarked(true);
                    elementAdded = true;
                    Line l = (Line)element;
                    while ((connectedLines = this.start[l.getX1Int()][l.getY2Int()]) != null && (connectedLine = connectedLines.get(0)) != null && !connectedLine.isMarked()) {
                        sorted.add(connectedLine);
                        connectedLine.setMarked(true);
                        elementAdded = true;
                        l = connectedLine;
                    }
                    continue;
                }
                sorted.add(element);
                element.setMarked(true);
                elementAdded = true;
            }
        } while (elementAdded);
        LOGGER.log(Level.INFO, "elements to be sorted: {0}", this.elements.size());
        LOGGER.log(Level.INFO, "elements sorted: {0}", sorted.size());
        this.elements = sorted;
    }

    private void setMarked(GraphicElements elements, boolean marked) {
        for (int i = 0; i < elements.size(); ++i) {
            GraphicElement element = elements.get(i);
            element.setMarked(marked);
        }
    }
}

