/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg;

import de.berndbock.tinysvg.Config;
import de.berndbock.tinysvg.graphelem.Circle;
import de.berndbock.tinysvg.graphelem.Ellipse;
import de.berndbock.tinysvg.graphelem.GraphicElement;
import de.berndbock.tinysvg.graphelem.GraphicElements;
import de.berndbock.tinysvg.graphelem.Line;
import de.berndbock.tinysvg.graphelem.PolyLine;
import de.berndbock.tinysvg.graphelem.Rect;
import de.berndbock.tinysvg.helper.Point;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JPanel;

public class DrawPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(DrawPanel.class.getName());
    private static int maxX = 719;
    private static int maxY = 511;
    private static int midX = 359;
    private static int midY = 255;
    private GraphicElements graphicElements;

    public DrawPanel() {
        this.initComponents();
        this.graphicElements = null;
    }

    public void initSize(Config config) {
        maxX = config.getResolutionX() - 1;
        maxY = config.getResolutionYAdjusted() - 1;
        midX = maxX / 2 - 1;
        midY = maxY / 2 - 1;
    }

    public void setGraphicElements(GraphicElements graphicElements) {
        this.graphicElements = graphicElements;
    }

    private void initComponents() {
        this.setMaximumSize(new Dimension(720, 512));
        this.setMinimumSize(new Dimension(720, 512));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 720, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 512, Short.MAX_VALUE));
    }

    @Override
    public void paintComponent(Graphics g) {
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        if (this.graphicElements != null) {
            this.drawGraphicElements(g, this.graphicElements);
        } else {
            g.drawRect(0, 0, maxX, maxY);
            g.drawOval(midX - 200, midY - 200, 200, 200);
            g.drawOval(midX - 200, midY, 200, 200);
            g.drawOval(midX, midY - 200, 200, 200);
            g.drawOval(midX, midY, 200, 200);
            g.drawLine(0, 0, maxX, maxY);
            g.drawLine(0, maxY, maxX, 0);
            g.drawLine(midX, 0, midX, maxY);
            g.drawLine(0, midY, maxX, midY);
        }
    }

    private void drawGraphicElements(Graphics g, GraphicElements elements) {
        for (int i = 0; i < elements.size(); ++i) {
            GraphicElement element = elements.get(i);
            this.drawGraphicElement(g, element);
        }
    }

    private void drawGraphicElement(Graphics g, GraphicElement element) {
        switch (element.getType()) {
            case 1: {
                Rect r = (Rect)element;
                g.drawRect((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
                break;
            }
            case 2: {
                Circle c = (Circle)element;
                int offset = (int)c.getR();
                int cx = (int)c.getCx();
                int cy = (int)c.getCy();
                int widthHeight = (int)(c.getR() * 2.0);
                g.drawOval(cx - offset, cy - offset, widthHeight, widthHeight);
                break;
            }
            case 5: {
                Ellipse e = (Ellipse)element;
                int offsetX = (int)e.getRx();
                int offsetY = (int)e.getRy();
                int cx = (int)e.getCx();
                int cy = (int)e.getCy();
                int width = (int)(e.getRx() * 2.0);
                int height = (int)(e.getRy() * 2.0);
                g.drawOval(cx - offsetX, cy - offsetY, width, height);
                break;
            }
            case 3: {
                Line l = (Line)element;
                int x1 = l.getX1Int();
                int y1 = l.getY1Int();
                int x2 = l.getX2Int();
                int y2 = l.getY2Int();
                g.drawLine(x1, y1, x2, y2);
                break;
            }
            case 6: 
            case 7: {
                PolyLine p = (PolyLine)element;
                List<Point> points = p.getPointsList();
                if (points.isEmpty()) break;
                Point p1 = null;
                if (points.size() == 1) {
                    p1 = points.get(0);
                    int x1 = (int)p1.x;
                    int y1 = (int)p1.y;
                    int x2 = (int)p1.x;
                    int y2 = (int)p1.y;
                    g.drawLine(x1, y1, x2, y2);
                    break;
                }
                for (Point p2 : points) {
                    if (p1 != null) {
                        int x1 = (int)p1.x;
                        int y1 = (int)p1.y;
                        int x2 = (int)p2.x;
                        int y2 = (int)p2.y;
                        g.drawLine(x1, y1, x2, y2);
                    }
                    p1 = p2;
                }
                break;
            }
            case 9: 
            case 13: {
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "Unsupported graphic element type: {0}", element.getType());
            }
        }
    }
}

