/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg;

import de.berndbock.tinysvg.Config;
import de.berndbock.tinysvg.OutputFileProfileDialog;
import de.berndbock.tinysvg.TinySVG;
import de.berndbock.tinysvg.util.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;

public class ConfigDialog
extends JDialog {
    private final Frame parentFrame;
    private final Config config;
    private JButton butCancel;
    private JButton butOK;
    private JButton butProfile;
    private ButtonGroup buttonGroupScreenResolution;
    private JCheckBox cbArcApproximation;
    private JCheckBox cbBezierCurveApproximation;
    private JCheckBox cbCenter;
    private JCheckBox cbDoubleHeight;
    private JCheckBox cbEggPainter;
    private JCheckBox cbHpgl;
    private JCheckBox cbLineReducer;
    private JCheckBox cbMirrorHorizontally;
    private JCheckBox cbMirrorVertically;
    private JCheckBox cbOriginBottomLeft;
    private JCheckBox cbResize;
    private JCheckBox cbSvg;
    private JCheckBox cbVe2;
    private JCheckBox cbVec;
    private JCheckBox cbZX81;
    private JCheckBox cbZXSpectrumSpeedplot;
    private JCheckBox cbZXSpectrumSpeedplotExt;
    private JCheckBox cbZXSpectrumStandard;
    private JCheckBox cbZxCnc;
    private JComboBox<String> cboPresets;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JLabel lblBezierFactor;
    private JLabel lblDegrees;
    private JLabel lblErrorMsg;
    private JLabel lblOffsetX;
    private JLabel lblOffsetY;
    private JLabel lblOutputFiles;
    private JLabel lblPresets;
    private JLabel lblRotateClockwise;
    private JLabel lblScaleFactor;
    private JLabel lblScreenResolution;
    private JLabel lblTitle;
    private JLabel lblX;
    private JRadioButton rb240x800;
    private JRadioButton rb256x176;
    private JRadioButton rb256x192;
    private JRadioButton rb320x200;
    private JRadioButton rb720x256;
    private JRadioButton rbCustomResolution;
    private JTextField txtBezierFactor;
    private JTextField txtCustomX;
    private JTextField txtCustomY;
    private JTextField txtOffsetX;
    private JTextField txtOffsetY;
    private JTextField txtRotateClockwise;
    private JTextField txtScaleFactor;

    public ConfigDialog(Frame parent, boolean modal, Config config) {
        super(parent, modal);
        this.parentFrame = parent;
        this.config = config;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.butOK);
        this.addEscapeListener();
        this.cbCenter.setSelected(config.isCenter());
        this.cbResize.setSelected(config.isResize());
        this.txtScaleFactor.setText(String.valueOf(config.getScaleFactor()));
        this.txtOffsetX.setText(String.valueOf(config.getOffsetX()));
        this.txtOffsetY.setText(String.valueOf(config.getOffsetY()));
        this.cbMirrorVertically.setSelected(config.isMirrorVertically());
        this.cbMirrorHorizontally.setSelected(config.isMirrorHorizontally());
        this.txtRotateClockwise.setText(String.valueOf(config.getRotateClockwise()));
        this.cbOriginBottomLeft.setSelected(config.isOriginAtBottomLeft());
        this.cbBezierCurveApproximation.setSelected(config.useBezierCurveApproximation());
        int bezierFactor = config.getBezierFactor();
        this.txtBezierFactor.setText(bezierFactor == 0 ? "" : String.valueOf(bezierFactor));
        this.cbArcApproximation.setSelected(config.useArcApproximation());
        this.cbLineReducer.setSelected(config.isLineReducerActivated());
        this.cbVec.setSelected(config.isWriteVec());
        this.cbEggPainter.setSelected(config.isWriteEggPainter());
        this.cbZxCnc.setSelected(config.isWriteZxCnc());
        this.cbHpgl.setSelected(config.isWriteHpgl());
        this.cbZX81.setSelected(config.isWriteZX81());
        this.cbZXSpectrumStandard.setSelected(config.isWriteZXSpectrum());
        this.cbZXSpectrumSpeedplot.setSelected(config.isWriteZXSpectrumSpeedplot());
        this.cbZXSpectrumSpeedplotExt.setSelected(config.isWriteZXSpectrumSpeedplotExt());
        this.cbVe2.setSelected(config.isWriteVe2());
        this.cbSvg.setSelected(config.isWriteSvg());
        if (config.getResolutionX() == 720 && config.getResolutionY() == 256) {
            this.rb720x256.setSelected(true);
        } else if (config.getResolutionX() == 240 && config.getResolutionY() == 800) {
            this.rb240x800.setSelected(true);
        } else if (config.getResolutionX() == 256 && config.getResolutionY() == 192) {
            this.rb256x192.setSelected(true);
        } else if (config.getResolutionX() == 256 && config.getResolutionY() == 176) {
            this.rb256x176.setSelected(true);
        } else if (config.getResolutionX() == 320 && config.getResolutionY() == 200) {
            this.rb320x200.setSelected(true);
        } else {
            this.rbCustomResolution.setSelected(true);
        }
        if (this.rbCustomResolution.isSelected()) {
            if (config.getResolutionX() > 0) {
                this.txtCustomX.setText(String.valueOf(config.getResolutionX()));
            }
            if (config.getResolutionY() > 0) {
                this.txtCustomY.setText(String.valueOf(config.getResolutionY()));
            }
        }
        this.cbDoubleHeight.setSelected(config.isDoubleHeightPreview());
        this.enableControls();
    }

    private void initComponents() {
        this.buttonGroupScreenResolution = new ButtonGroup();
        this.lblTitle = new JLabel();
        this.cbCenter = new JCheckBox();
        this.cbResize = new JCheckBox();
        this.lblScaleFactor = new JLabel();
        this.txtScaleFactor = new JTextField();
        this.lblOffsetX = new JLabel();
        this.txtOffsetX = new JTextField();
        this.cbBezierCurveApproximation = new JCheckBox();
        this.lblBezierFactor = new JLabel();
        this.txtBezierFactor = new JTextField();
        this.lblOffsetY = new JLabel();
        this.txtOffsetY = new JTextField();
        this.cbArcApproximation = new JCheckBox();
        this.cbMirrorVertically = new JCheckBox();
        this.cbMirrorHorizontally = new JCheckBox();
        this.cbLineReducer = new JCheckBox();
        this.lblRotateClockwise = new JLabel();
        this.txtRotateClockwise = new JTextField();
        this.lblDegrees = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.lblOutputFiles = new JLabel();
        this.cbVec = new JCheckBox();
        this.cbZX81 = new JCheckBox();
        this.cbEggPainter = new JCheckBox();
        this.cbZXSpectrumStandard = new JCheckBox();
        this.cbZxCnc = new JCheckBox();
        this.cbZXSpectrumSpeedplot = new JCheckBox();
        this.cbHpgl = new JCheckBox();
        this.jSeparator2 = new JSeparator();
        this.lblScreenResolution = new JLabel();
        this.rb720x256 = new JRadioButton();
        this.rb256x192 = new JRadioButton();
        this.rb240x800 = new JRadioButton();
        this.rb256x176 = new JRadioButton();
        this.rb320x200 = new JRadioButton();
        this.cbDoubleHeight = new JCheckBox();
        this.rbCustomResolution = new JRadioButton();
        this.txtCustomX = new JTextField();
        this.lblX = new JLabel();
        this.txtCustomY = new JTextField();
        this.cbOriginBottomLeft = new JCheckBox();
        this.jSeparator3 = new JSeparator();
        this.lblPresets = new JLabel();
        this.cboPresets = new JComboBox();
        this.lblErrorMsg = new JLabel();
        this.butOK = new JButton();
        this.butCancel = new JButton();
        this.cbVe2 = new JCheckBox();
        this.butProfile = new JButton();
        this.cbSvg = new JCheckBox();
        this.cbZXSpectrumSpeedplotExt = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setName("ConfigDialog");
        this.lblTitle.setFont(new Font("Tahoma", 0, 18));
        this.lblTitle.setText(TinySVG.getBundle().getString("CONFIG_HEADLINE"));
        this.cbCenter.setSelected(true);
        this.cbCenter.setText(TinySVG.getBundle().getString("CENTER"));
        this.cbCenter.setToolTipText(TinySVG.getBundle().getString("CENTER_TOOLTIP"));
        this.cbCenter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.cbCenterActionPerformed(evt);
            }
        });
        this.cbResize.setSelected(true);
        this.cbResize.setText(TinySVG.getBundle().getString("RESIZE"));
        this.cbResize.setToolTipText(TinySVG.getBundle().getString("RESIZE_TOOLTIP"));
        this.cbResize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.cbResizeActionPerformed(evt);
            }
        });
        this.lblScaleFactor.setLabelFor(this.txtScaleFactor);
        this.lblScaleFactor.setText(TinySVG.getBundle().getString("SCALE_FACTOR"));
        this.lblScaleFactor.setEnabled(false);
        this.txtScaleFactor.setHorizontalAlignment(0);
        this.txtScaleFactor.setEnabled(false);
        this.lblOffsetX.setLabelFor(this.txtOffsetX);
        this.lblOffsetX.setText(TinySVG.getBundle().getString("OFFSET_X"));
        this.lblOffsetX.setEnabled(false);
        this.txtOffsetX.setHorizontalAlignment(0);
        this.txtOffsetX.setEnabled(false);
        this.cbBezierCurveApproximation.setSelected(true);
        this.cbBezierCurveApproximation.setText(TinySVG.getBundle().getString("BEZIER"));
        this.cbBezierCurveApproximation.setToolTipText(TinySVG.getBundle().getString("BEZIER_TOOLTIP"));
        this.lblBezierFactor.setLabelFor(this.txtBezierFactor);
        this.lblBezierFactor.setText(TinySVG.getBundle().getString("BEZIER_FACTOR_TOOLTIP"));
        this.txtBezierFactor.setHorizontalAlignment(0);
        this.txtBezierFactor.setText("10");
        this.txtBezierFactor.setToolTipText(TinySVG.getBundle().getString("BEZIER_FACTOR"));
        this.lblOffsetY.setLabelFor(this.txtOffsetY);
        this.lblOffsetY.setText(TinySVG.getBundle().getString("OFFSET_Y"));
        this.lblOffsetY.setEnabled(false);
        this.txtOffsetY.setHorizontalAlignment(0);
        this.txtOffsetY.setEnabled(false);
        this.cbArcApproximation.setSelected(true);
        this.cbArcApproximation.setText(TinySVG.getBundle().getString("ARC"));
        this.cbArcApproximation.setToolTipText(TinySVG.getBundle().getString("ARC_TOOLTIP"));
        this.cbMirrorVertically.setText(TinySVG.getBundle().getString("MIRROR_VERTICALLY"));
        this.cbMirrorHorizontally.setText(TinySVG.getBundle().getString("MIRROR_HORIZONTALLY"));
        this.cbLineReducer.setText(TinySVG.getBundle().getString("LINE_REDUCER"));
        this.cbLineReducer.setToolTipText(TinySVG.getBundle().getString("LINE_REDUCER_TOOLTIP"));
        this.lblRotateClockwise.setText(TinySVG.getBundle().getString("ROTATE_CLOCKWISE"));
        this.txtRotateClockwise.setHorizontalAlignment(0);
        this.txtRotateClockwise.setText("0");
        this.lblDegrees.setText(TinySVG.getBundle().getString("DEGREES"));
        this.lblOutputFiles.setFont(new Font("Tahoma", 1, 12));
        this.lblOutputFiles.setText(TinySVG.getBundle().getString("OUTPUT_FILES"));
        this.cbVec.setText("VEC (.vec)");
        this.cbVec.setToolTipText(TinySVG.getBundle().getString("OUTPUT_JOYCE_TOOLTIP"));
        this.cbZX81.setText("ZX81 (.p)");
        this.cbZX81.setToolTipText(TinySVG.getBundle().getString("OUTPUT_ZX81_TOOLTIP"));
        this.cbEggPainter.setText(TinySVG.getBundle().getString("OUTPUT_ZX_EGG_PAINTER"));
        this.cbEggPainter.setToolTipText(TinySVG.getBundle().getString("OUTPUT_ZX_EGG_PAINTER_TOOLTIP"));
        this.cbZXSpectrumStandard.setText("ZX Spectrum standard (.zxv)");
        this.cbZXSpectrumStandard.setToolTipText(TinySVG.getBundle().getString("OUTPUT_ZX_SPECTRUM_STANDARD_TOOLTIP"));
        this.cbZxCnc.setText("ZXCNC (.cnc)");
        this.cbZxCnc.setToolTipText(TinySVG.getBundle().getString("OUTPUT_ZXCNC_TOOLTIP"));
        this.cbZXSpectrumSpeedplot.setText("ZX Spectrum speedplot (.zxs)");
        this.cbZXSpectrumSpeedplot.setToolTipText(TinySVG.getBundle().getString("OUTPUT_ZX_SPECTRUM_SPEEDPLOT_TOOLTIP"));
        this.cbHpgl.setText("HP-GL (.plt)");
        this.cbHpgl.setToolTipText(TinySVG.getBundle().getString("OUTPUT_HPGL_TOOLTIP"));
        this.lblScreenResolution.setFont(new Font("Tahoma", 1, 12));
        this.lblScreenResolution.setText(TinySVG.getBundle().getString("SCREEN_RESOLUTION"));
        this.buttonGroupScreenResolution.add(this.rb720x256);
        this.rb720x256.setSelected(true);
        this.rb720x256.setText("720x256 (Schneider Joyce)");
        this.buttonGroupScreenResolution.add(this.rb256x192);
        this.rb256x192.setText("256x192 (ZX81, ZX Spectrum)");
        this.buttonGroupScreenResolution.add(this.rb240x800);
        this.rb240x800.setText(TinySVG.getBundle().getString("RES_ZX_EGG_PAINTER"));
        this.buttonGroupScreenResolution.add(this.rb256x176);
        this.rb256x176.setText("256x176 (ZX Spectrum)");
        this.buttonGroupScreenResolution.add(this.rb320x200);
        this.rb320x200.setText("320x200 (C64)");
        this.cbDoubleHeight.setSelected(true);
        this.cbDoubleHeight.setText(TinySVG.getBundle().getString("DOUBLE_HEIGHT_PREVIEW"));
        this.buttonGroupScreenResolution.add(this.rbCustomResolution);
        this.rbCustomResolution.setText(TinySVG.getBundle().getString("CUSTOM_RESOLUTION"));
        this.txtCustomX.setHorizontalAlignment(0);
        this.txtCustomX.setMinimumSize(new Dimension(40, 20));
        this.lblX.setText("x");
        this.txtCustomY.setHorizontalAlignment(0);
        this.txtCustomY.setMinimumSize(new Dimension(40, 20));
        this.cbOriginBottomLeft.setText(TinySVG.getBundle().getString("ORIGIN_BOTTOM_LEFT"));
        this.lblPresets.setFont(new Font("Tahoma", 1, 12));
        this.lblPresets.setText(TinySVG.getBundle().getString("PRESETS"));
        this.cboPresets.setModel(new DefaultComboBoxModel<String>(new String[]{"<keine Auswahl>", "Schneider Joyce", "ZX Egg Painter", "ZX81", "ZX Spectrum Standard", "ZX Spectrum Speedplot", "ZX Spectrum Speedplot extended", "C64"}));
        this.cboPresets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.cboPresetsActionPerformed(evt);
            }
        });
        this.lblErrorMsg.setForeground(new Color(255, 0, 0));
        this.lblErrorMsg.setMinimumSize(new Dimension(100, 20));
        this.lblErrorMsg.setName("");
        this.lblErrorMsg.setPreferredSize(new Dimension(100, 20));
        this.butOK.setText("OK");
        this.butOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.butOKActionPerformed(evt);
            }
        });
        this.butCancel.setText(TinySVG.getBundle().getString("CANCEL"));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.butCancelActionPerformed(evt);
            }
        });
        this.cbVe2.setText("VE2 (.ve2)");
        this.butProfile.setText(TinySVG.getBundle().getString("PROFILE"));
        this.butProfile.setMargin(new Insets(0, 5, 0, 5));
        this.butProfile.setMaximumSize(new Dimension(27, 17));
        this.butProfile.setMinimumSize(new Dimension(27, 17));
        this.butProfile.setPreferredSize(new Dimension(27, 17));
        this.butProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.butProfileActionPerformed(evt);
            }
        });
        this.cbSvg.setText("SVG (.svg)");
        this.cbSvg.setToolTipText(TinySVG.getBundle().getString("OUTPUT_SVG_TOOLTIP"));
        this.cbZXSpectrumSpeedplotExt.setToolTipText(TinySVG.getBundle().getString("OUTPUT_ZX_SPECTRUM_SPEEDPLOT_TOOLTIP"));
        this.cbZXSpectrumSpeedplotExt.setLabel("ZX Spectrum speedplot extended (.zxx)");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblErrorMsg, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator2).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addComponent(this.butOK, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.butCancel, -2, 160, -2)).addComponent(this.jSeparator3).addComponent(this.cboPresets, 0, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblTitle).addComponent(this.lblOutputFiles).addComponent(this.lblScreenResolution).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rb240x800).addComponent(this.rb720x256).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.rbCustomResolution).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtCustomX, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblX).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtCustomY, -2, 40, -2)).addComponent(this.rb320x200))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbDoubleHeight).addComponent(this.rb256x176).addComponent(this.rb256x192).addComponent(this.cbOriginBottomLeft))).addComponent(this.lblPresets).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbBezierCurveApproximation).addGroup(layout.createSequentialGroup().addComponent(this.cbCenter).addGap(18, 18, 18).addComponent(this.cbResize)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbLineReducer).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.cbArcApproximation).addGap(30, 30, 30)))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblScaleFactor).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtScaleFactor, -2, 44, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.cbMirrorVertically, -2, 108, -2).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.lblBezierFactor).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtBezierFactor, -2, 26, -2)))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.lblOffsetY).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtOffsetY)).addGroup(layout.createSequentialGroup().addComponent(this.lblOffsetX).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtOffsetX, -2, 50, -2)))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.lblRotateClockwise).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtRotateClockwise, -2, 36, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblDegrees)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(115, 115, 115).addComponent(this.cbMirrorHorizontally))))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbVec).addComponent(this.cbEggPainter).addComponent(this.cbZxCnc).addComponent(this.cbHpgl).addComponent(this.cbSvg)).addGap(26, 26, 26).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cbVe2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.butProfile, -2, 71, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbZXSpectrumStandard).addComponent(this.cbZX81).addComponent(this.cbZXSpectrumSpeedplot).addComponent(this.cbZXSpectrumSpeedplotExt)).addGap(0, 0, Short.MAX_VALUE))))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbCenter).addComponent(this.cbResize).addComponent(this.lblScaleFactor).addComponent(this.txtScaleFactor, -2, -1, -2).addComponent(this.lblOffsetX).addComponent(this.txtOffsetX, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbBezierCurveApproximation).addComponent(this.txtBezierFactor, -2, -1, -2).addComponent(this.lblBezierFactor).addComponent(this.lblOffsetY).addComponent(this.txtOffsetY, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbArcApproximation).addComponent(this.cbMirrorVertically).addComponent(this.cbMirrorHorizontally)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbLineReducer).addComponent(this.txtRotateClockwise, -2, -1, -2).addComponent(this.lblDegrees).addComponent(this.lblRotateClockwise)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblOutputFiles).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbVec).addComponent(this.cbZX81)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbEggPainter).addComponent(this.cbZXSpectrumStandard)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbZxCnc).addComponent(this.cbZXSpectrumSpeedplot)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbHpgl).addComponent(this.cbZXSpectrumSpeedplotExt)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbSvg).addComponent(this.cbVe2).addComponent(this.butProfile, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblScreenResolution).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.rb720x256).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rb240x800)).addGroup(layout.createSequentialGroup().addComponent(this.rb256x192).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rb256x176))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbDoubleHeight).addComponent(this.rb320x200)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbOriginBottomLeft).addComponent(this.rbCustomResolution).addComponent(this.txtCustomX, -2, -1, -2).addComponent(this.lblX).addComponent(this.txtCustomY, -2, -1, -2)).addGap(12, 12, 12).addComponent(this.jSeparator3, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPresets).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cboPresets, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblErrorMsg, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 9, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.butOK).addComponent(this.butCancel)).addContainerGap()));
        this.pack();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.config.setCancelled(true);
        this.dispose();
    }

    private void butOKActionPerformed(ActionEvent evt) {
        if (this.isInputValid()) {
            this.config.setCenter(this.cbCenter.isSelected());
            this.config.setResize(this.cbResize.isSelected());
            double scaleFactor = Util.toDouble(this.txtScaleFactor.getText());
            if (scaleFactor <= 0.0) {
                JOptionPane.showMessageDialog(this, TinySVG.getBundle().getString("ERR_MSG_SCALE_FACTOR"), TinySVG.getBundle().getString("ERR_MSG_TITLE_SCALE_FACTOR"), 0);
            } else {
                this.config.setScaleFactor(scaleFactor);
            }
            this.config.setOffsetX(Util.toDouble(this.txtOffsetX.getText()));
            this.config.setOffsetY(Util.toDouble(this.txtOffsetY.getText()));
            this.config.setMirrorVertically(this.cbMirrorVertically.isSelected());
            this.config.setMirrorHorizontally(this.cbMirrorHorizontally.isSelected());
            this.config.setRotateClockwise(Util.toDouble(this.txtRotateClockwise.getText()));
            this.config.setOriginAtBottomLeft(this.cbOriginBottomLeft.isSelected());
            this.config.setUseBezierCurveApproximation(this.cbBezierCurveApproximation.isSelected());
            int bezierFactor = Util.toInt(this.txtBezierFactor.getText());
            if (bezierFactor < 1 || bezierFactor > 50) {
                JOptionPane.showMessageDialog(this, TinySVG.getBundle().getString("ERR_MSG_BEZIER_FACTOR"), TinySVG.getBundle().getString("ERR_MSG_TITLE_BEZIER_FACTOR"), 0);
            } else {
                this.config.setBezierFactor(bezierFactor);
            }
            this.config.setUseArcApproximation(this.cbArcApproximation.isSelected());
            this.config.setLineReducerActivated(this.cbLineReducer.isSelected());
            this.config.setWriteVec(this.cbVec.isSelected());
            this.config.setWriteEggPainter(this.cbEggPainter.isSelected());
            this.config.setWriteZxCnc(this.cbZxCnc.isSelected());
            this.config.setWriteHpgl(this.cbHpgl.isSelected());
            this.config.setWriteZX81(this.cbZX81.isSelected());
            this.config.setWriteZXSpectrum(this.cbZXSpectrumStandard.isSelected());
            this.config.setWriteZXSpectrumSpeedplot(this.cbZXSpectrumSpeedplot.isSelected());
            this.config.setWriteZXSpectrumSpeedplotExt(this.cbZXSpectrumSpeedplotExt.isSelected());
            this.config.setWriteVe2(this.cbVe2.isSelected());
            this.config.setWriteSvg(this.cbSvg.isSelected());
            if (this.rb720x256.isSelected()) {
                this.config.setResolutionX(720);
                this.config.setResolutionY(256);
            } else if (this.rb240x800.isSelected()) {
                this.config.setResolutionX(240);
                this.config.setResolutionY(800);
            } else if (this.rb256x192.isSelected()) {
                this.config.setResolutionX(256);
                this.config.setResolutionY(192);
            } else if (this.rb256x176.isSelected()) {
                this.config.setResolutionX(256);
                this.config.setResolutionY(176);
            } else if (this.rb320x200.isSelected()) {
                this.config.setResolutionX(320);
                this.config.setResolutionY(200);
            } else if (this.rbCustomResolution.isSelected()) {
                int x = Util.toInt(this.txtCustomX.getText());
                int y = Util.toInt(this.txtCustomY.getText());
                this.config.setResolutionX(x);
                this.config.setResolutionY(y);
            }
            this.config.setDoubleHeightPreview(this.cbDoubleHeight.isSelected());
            this.config.setCancelled(false);
            this.dispose();
        }
    }

    private void cboPresetsActionPerformed(ActionEvent evt) {
        switch (this.cboPresets.getSelectedIndex()) {
            case 0: {
                break;
            }
            case 1: {
                this.cbOriginBottomLeft.setSelected(false);
                this.cbVec.setSelected(false);
                this.cbEggPainter.setSelected(false);
                this.cbZxCnc.setSelected(false);
                this.cbHpgl.setSelected(false);
                this.cbZX81.setSelected(false);
                this.cbZXSpectrumStandard.setSelected(false);
                this.cbZXSpectrumSpeedplot.setSelected(false);
                this.cbZXSpectrumSpeedplotExt.setSelected(false);
                this.cbVe2.setSelected(true);
                this.cbSvg.setSelected(false);
                this.rb720x256.setSelected(true);
                this.cbDoubleHeight.setSelected(true);
                this.config.setProfileFlags(511);
                break;
            }
            case 2: {
                this.cbOriginBottomLeft.setSelected(true);
                this.cbVec.setSelected(false);
                this.cbEggPainter.setSelected(false);
                this.cbZxCnc.setSelected(true);
                this.cbHpgl.setSelected(false);
                this.cbZX81.setSelected(false);
                this.cbZXSpectrumStandard.setSelected(false);
                this.cbZXSpectrumSpeedplot.setSelected(false);
                this.cbZXSpectrumSpeedplotExt.setSelected(false);
                this.cbVe2.setSelected(false);
                this.cbSvg.setSelected(false);
                this.rb240x800.setSelected(true);
                this.cbDoubleHeight.setSelected(false);
                this.config.setProfileFlags(2);
                break;
            }
            case 3: {
                this.cbOriginBottomLeft.setSelected(true);
                this.cbVec.setSelected(false);
                this.cbEggPainter.setSelected(false);
                this.cbZxCnc.setSelected(false);
                this.cbHpgl.setSelected(false);
                this.cbZX81.setSelected(true);
                this.cbZXSpectrumStandard.setSelected(false);
                this.cbZXSpectrumSpeedplot.setSelected(false);
                this.cbZXSpectrumSpeedplotExt.setSelected(false);
                this.cbVe2.setSelected(false);
                this.cbSvg.setSelected(false);
                this.rb256x192.setSelected(true);
                this.cbDoubleHeight.setSelected(false);
                this.config.setProfileFlags(39);
                break;
            }
            case 4: {
                this.cbOriginBottomLeft.setSelected(true);
                this.cbVec.setSelected(false);
                this.cbEggPainter.setSelected(false);
                this.cbZxCnc.setSelected(false);
                this.cbHpgl.setSelected(false);
                this.cbZX81.setSelected(false);
                this.cbZXSpectrumStandard.setSelected(true);
                this.cbZXSpectrumSpeedplot.setSelected(false);
                this.cbZXSpectrumSpeedplotExt.setSelected(false);
                this.cbVe2.setSelected(false);
                this.cbSvg.setSelected(false);
                this.rb256x176.setSelected(true);
                this.cbDoubleHeight.setSelected(false);
                this.config.setProfileFlags(39);
                break;
            }
            case 5: {
                this.cbOriginBottomLeft.setSelected(true);
                this.cbVec.setSelected(false);
                this.cbEggPainter.setSelected(false);
                this.cbZxCnc.setSelected(false);
                this.cbHpgl.setSelected(false);
                this.cbZX81.setSelected(false);
                this.cbZXSpectrumStandard.setSelected(false);
                this.cbZXSpectrumSpeedplot.setSelected(true);
                this.cbZXSpectrumSpeedplotExt.setSelected(false);
                this.cbVe2.setSelected(false);
                this.cbSvg.setSelected(false);
                this.rb256x192.setSelected(true);
                this.cbDoubleHeight.setSelected(false);
                this.config.setProfileFlags(2);
                break;
            }
            case 6: {
                this.cbOriginBottomLeft.setSelected(true);
                this.cbVec.setSelected(false);
                this.cbEggPainter.setSelected(false);
                this.cbZxCnc.setSelected(false);
                this.cbHpgl.setSelected(false);
                this.cbZX81.setSelected(false);
                this.cbZXSpectrumStandard.setSelected(false);
                this.cbZXSpectrumSpeedplot.setSelected(false);
                this.cbZXSpectrumSpeedplotExt.setSelected(true);
                this.cbVe2.setSelected(false);
                this.cbSvg.setSelected(false);
                this.rb256x192.setSelected(true);
                this.cbDoubleHeight.setSelected(false);
                this.config.setProfileFlags(50);
                break;
            }
            case 7: {
                this.cbOriginBottomLeft.setSelected(false);
                this.cbVec.setSelected(false);
                this.cbEggPainter.setSelected(false);
                this.cbZxCnc.setSelected(false);
                this.cbHpgl.setSelected(false);
                this.cbZX81.setSelected(false);
                this.cbZXSpectrumStandard.setSelected(false);
                this.cbZXSpectrumSpeedplot.setSelected(false);
                this.cbZXSpectrumSpeedplotExt.setSelected(false);
                this.cbVe2.setSelected(true);
                this.cbSvg.setSelected(false);
                this.rb320x200.setSelected(true);
                this.cbDoubleHeight.setSelected(false);
                this.config.setProfileFlags(511);
            }
        }
    }

    private void cbCenterActionPerformed(ActionEvent evt) {
        this.enableControls();
    }

    private void cbResizeActionPerformed(ActionEvent evt) {
        this.enableControls();
    }

    private void butProfileActionPerformed(ActionEvent evt) {
        OutputFileProfileDialog dialog = new OutputFileProfileDialog(this.parentFrame, true, this.config);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private boolean isInputValid() {
        double scaleFactor = Util.toDouble(this.txtScaleFactor.getText());
        if (scaleFactor <= 0.0) {
            this.lblErrorMsg.setText(TinySVG.getBundle().getString("ERR_MSG_SCALE_FACTOR2"));
            this.txtScaleFactor.setBackground(Color.red);
            return false;
        }
        this.txtScaleFactor.setBackground(Color.white);
        int bezierFactor = Util.toInt(this.txtBezierFactor.getText());
        if (bezierFactor < 1 || bezierFactor > 50) {
            this.lblErrorMsg.setText(TinySVG.getBundle().getString("ERR_MSG_BEZIER_FACTOR2"));
            this.txtBezierFactor.setBackground(Color.red);
            return false;
        }
        this.txtBezierFactor.setBackground(Color.white);
        if (!this.txtCustomX.getText().isEmpty()) {
            int x = Util.toInt(this.txtCustomX.getText());
            if (x < 8 || x > 4096) {
                this.lblErrorMsg.setText(TinySVG.getBundle().getString("ERR_MSG_CUSTOM_X"));
                this.txtCustomX.setBackground(Color.red);
                return false;
            }
            this.txtCustomX.setBackground(Color.white);
        }
        if (!this.txtCustomY.getText().isEmpty()) {
            int y = Util.toInt(this.txtCustomY.getText());
            if (y < 8 || y > 4096) {
                this.lblErrorMsg.setText(TinySVG.getBundle().getString("ERR_MSG_CUSTOM_Y"));
                this.txtCustomY.setBackground(Color.red);
                return false;
            }
            this.txtCustomY.setBackground(Color.white);
        }
        return true;
    }

    private void enableControls() {
        boolean enable = !this.cbResize.isSelected();
        this.lblScaleFactor.setEnabled(enable);
        this.txtScaleFactor.setEnabled(enable);
        enable = !this.cbCenter.isSelected();
        this.lblOffsetX.setEnabled(enable);
        this.txtOffsetX.setEnabled(enable);
        this.lblOffsetY.setEnabled(enable);
        this.txtOffsetY.setEnabled(enable);
        enable = this.cbCenter.isSelected() && this.cbResize.isSelected();
        this.cbLineReducer.setEnabled(enable);
    }

    private void addEscapeListener() {
        ActionListener escListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigDialog.this.butCancelActionPerformed(null);
            }
        };
        this.getRootPane().registerKeyboardAction(escListener, KeyStroke.getKeyStroke(27, 0), 2);
    }
}

